/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import thunderheadeng.gui.framework.UndoFramework;
import ventus.actions.Undo;
import ventus.data.GeomComposite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;

public class SetWorkingGroup {
    public static void setWorkingGroup(VentusData md, Floor floor, GeomComposite<IMerlinObj> group) {
        ChangeWorkingGroupOp op = new ChangeWorkingGroupOp(floor, floor.getWorkingGeomGroup(), group);
        Undo.insertEntry(md, op.perform());
    }

    private static class ChangeWorkingGroupOp
    implements UndoFramework.UndoOp {
        private final Floor floor;
        private final GeomComposite<IMerlinObj> oldGroup;
        private final GeomComposite<IMerlinObj> newGroup;

        public ChangeWorkingGroupOp(Floor floor, GeomComposite<IMerlinObj> oldGroup, GeomComposite<IMerlinObj> newGroup) {
            this.floor = floor;
            this.oldGroup = oldGroup;
            this.newGroup = newGroup;
        }

        @Override
        public UndoFramework.UndoOp perform() {
            this.floor.setWorkingGeomGroup(this.newGroup);
            return new ChangeWorkingGroupOp(this.floor, this.newGroup, this.oldGroup);
        }

        @Override
        public boolean isMajor() {
            return true;
        }
    }
}

