/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.AbstractDlgListener;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.data.IMerlinObj;
import ventus.data.MerlinSelectionModel;
import ventus.data.VentusData;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.gui.MerlinUDF;
import ventus.unitsystem.UnitSystem;

public class SetVolumeAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SetVolumeAction(), Intl.intl("Edit Custom Volume..."));

    public SetVolumeAction() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        VentusData data = VentusApp.getApp().getData();
        Set sel = data.selection.getSelected(IMerlinObj.class);
        this.setEnabled(sel.size() == 1 && sel.iterator().next() instanceof SchematicRoom);
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        MerlinSelectionModel sel = md.selection;
        assert (!sel.isEmpty());
        final Set<IMerlinObj> d_elements = sel.getSelected(IMerlinObj.class);
        UnitSystem us = VentusApp.getApp().getUnitSystem();
        UnitDouble vol = new UnitDouble(0.0, us.getUnit(16));
        boolean selected = false;
        try (VentusData.ReadLock lock = md.lockRead();){
            for (IMerlinObj selObj : d_elements) {
                if (!(selObj instanceof SchematicRoom)) continue;
                SchematicRoom r = (SchematicRoom)selObj;
                selected = r.getUseManualVolume();
                vol = selected ? r.getManualVolume() : r.getVolume();
            }
        }
        final SetVolumeDlg dlg = new SetVolumeDlg(app.getMainFrame(), d_elements);
        dlg.load(vol, selected);
        dlg.addDlgListener(new AbstractDlgListener(this){

            @Override
            public void okPressed() {
                AMerlinOp op = new AMerlinOp(){

                    @Override
                    public void run(VentusApp app, VentusData md) {
                        try (VentusData.WriteLock lock = md.lockWrite();){
                            dlg.save(d_elements);
                        }
                    }
                };
                UIHook.run(null, "SetVolumeAction", op, 0);
            }
        });
        dlg.doModal();
    }

    public static class SetVolumeDlg
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private final guiCheckBox d_useManualVolumeCB = new guiCheckBox(Intl.intl("Custom Volume:"));
        private final guiUnitDoubleField d_volume = new MerlinUDF(16);

        public SetVolumeDlg(JFrame owner, Collection<IMerlinObj> elements) {
            super((Window)owner, Intl.intl("Edit Custom Volume"), 9);
            this.d_volume.setToolTipText(Intl.intl("Override the calculated zone volume with a custom value."));
            LinkStatus.link((AbstractButton)this.d_useManualVolumeCB, this.d_volume);
            guiPanel p = this.getDialogPane();
            p.setLayout(new MigLayout("insets 0, gap 6"));
            p.add(this.d_useManualVolumeCB);
            p.add((Component)this.d_volume, "wrap");
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_useManualVolumeCB.isSelected() && ((UnitDouble)this.d_volume.getValue()).getRawValue() < 0.0) {
                this.showMessageBox(Intl.intl("A volume cannot be negative."));
                return false;
            }
            return true;
        }

        public void load(UnitDouble volume, boolean selected) {
            this.d_useManualVolumeCB.setSelected(selected);
            this.d_volume.setValue(volume);
        }

        public void save(Collection<IMerlinObj> elements) {
            for (IMerlinObj selObj : elements) {
                if (!(selObj instanceof SchematicRoom)) continue;
                SchematicRoom r = (SchematicRoom)selObj;
                r.setUseManualVolume(this.d_useManualVolumeCB.isSelected());
                if (!this.d_useManualVolumeCB.isSelected()) continue;
                r.setManualVolume((UnitDouble)this.d_volume.getValue());
            }
        }
    }
}

