/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.Visibility;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.FloorComposite;
import ventus.data.schematics.FloorOptions;

public class SetActiveFloor
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SetActiveFloor(), Intl.intl("Set as Active Level"));

    public SetActiveFloor() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        Set sel = VentusApp.getApp().getData().selection.getSelected(Object.class);
        this.setEnabled(sel.size() == 1 && sel.iterator().next() instanceof Floor);
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        try (VentusData.WriteLock lock = md.lockWrite();){
            Set selFloors = md.selection.getSelected(Floor.class);
            if (selFloors.isEmpty()) {
                return;
            }
            Floor floor = (Floor)selFloors.iterator().next();
            SetActiveFloor.setActiveFloor2(md, floor);
        }
    }

    public static void setActiveFloor(Component c, final Floor floor) {
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(VentusApp app, VentusData md) {
                try (VentusData.WriteLock lock = md.lockWrite();){
                    SetActiveFloor.setActiveFloor2(md, floor);
                }
            }
        };
        UIHook.run(c, "SetActiveFloor.setActiveFloor", op, 0);
    }

    public static void setActiveFloor2(VentusData md, Floor floor) {
        Undo.begin(Intl.intl("Change Level"));
        Undo.insertUndoEntry_restore(md, md.floors);
        LinkedIdentityHashSet<Floor> allFloors = new LinkedIdentityHashSet<Floor>(md.floors.getMembers(Floor.class));
        Undo.insertUndoEntry_restore(md, allFloors);
        md.floors.setActive(floor);
        List<FloorComposite> toHide = Arrays.asList(md.floors);
        ArrayList<Floor> toShow = new ArrayList<Floor>();
        toShow.add(floor);
        if (md.floorOptions.get(FloorOptions.SHOW_LOWER_FLOOR).booleanValue()) {
            SetActiveFloor.getFloorBelow(md, floor).ifPresent(toShow::add);
        }
        Visibility.setVisibility(md, toShow, toHide, true);
        Undo.end(md);
    }

    public static Optional<Floor> getFloorBelow(VentusData md, Floor floor) {
        ArrayList<Floor> floors = new ArrayList<Floor>(md.floors.flatten(Floor.class));
        int ix = floors.indexOf(floor);
        if (ix > 0) {
            Floor prev = (Floor)floors.get(ix - 1);
            return Optional.of(prev);
        }
        return Optional.empty();
    }

    public static void setFloorBelowVisible(VentusData md, Floor floor, boolean visible) {
        SetActiveFloor.getFloorBelow(md, floor).ifPresent(below -> {
            Set<Floor> coll = Collections.singleton(below);
            Visibility.setVisibility(md, visible ? coll : Collections.emptyList(), !visible ? coll : Collections.emptyList(), false);
        });
    }
}

