/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;
import ventus.VentusApp;
import ventus.data.VentusData;

public class SelectionObserver
implements IEventObserver {
    private final Map<Class<?>, List<IEventObserver>> d_observers = new LinkedHashMap();
    private static final SelectionObserver s_instance = new SelectionObserver();

    public static boolean isSelectionEvent(Events events) {
        IEventRecord<Object> evts = events.getEvents(Object.class, new Class[0]);
        return evts.hasRemovedObjs() || evts.hasAddedObjs() || evts.containsChange(VentusData.SELECTION_CHANGED) || evts.containsChange(VentusData.MODEL_RESET) || evts.containsChange(VentusData.MODEL_LOADED);
    }

    public static void add(IEventObserver observer, Class<?> ... types) {
        for (Class<?> type : types) {
            List<IEventObserver> observers = SelectionObserver.s_instance.d_observers.get(type);
            if (observers == null) {
                observers = new ArrayList<IEventObserver>();
                SelectionObserver.s_instance.d_observers.put(type, observers);
            }
            observers.add(observer);
        }
    }

    public SelectionObserver() {
        VentusApp.getApp().getData().getEvents().addObserver(this);
    }

    @Override
    public void update(Events events) {
        LinkedIdentityHashSet affectedObservers = new LinkedIdentityHashSet();
        for (EventChannel<Object> channel : events.getAffectedChannels(Object.class, new Class[0])) {
            if (!channel.containsChange(VentusData.SELECTION_CHANGED) && !channel.hasRemovedObjs() && !channel.hasAddedObjs()) continue;
            theUtil.findObjectsForClass(this.d_observers, channel.getObjectType(), observers -> affectedObservers.addAll(observers));
        }
        for (IEventObserver observer : affectedObservers) {
            observer.update(events);
        }
    }
}

