/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Set;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.VentusData;

public class SelectSubitems
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectSubitems(), Intl.intl("Select Subitems"));

    public SelectSubitems() {
        SelectionObserver.add(this, Composite.class);
        this.update();
    }

    @Override
    public void update(Events events) {
        this.update();
    }

    private void update() {
        this.setEnabled(!VentusApp.getApp().getData().selection.isDeepEmpty(Composite.class));
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Select Subitems"));
            Set selObjs = md.selection.getSelected(Composite.class);
            Undo.insertUndoEntry_restoreSelection(md);
            md.selection.clear();
            for (Composite selObj : selObjs) {
                md.selection.selectAll(selObj.getDeepMembers());
            }
            Undo.end(md);
        }
    }
}

