/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Predicates;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.Shortcut;
import ventus.actions.ShortcutInfo;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.VentusData;
import ventus.data.schematics.ISchematicObj;
import ventus.feature.comps.BasicHotkey;
import ventus.feature.comps.IContextMenuItem;
import ventus.feature.comps.IHotkey;
import ventus.gui.ContextMenuUtils;

public class SelectConnectedSchematicObjs<T1 extends ISchematicObj, T2 extends ISchematicObj>
extends AMerlinOp
implements IHotkey<UIHook>,
IContextMenuItem {
    private final Class<T1> selectionClass;
    private final Class<T2> searchClass;
    private final Predicate<T2> searchFilter;
    private final String d_actionDescription;
    private final UIHook d_hook;
    private final IHotkey<UIHook> d_hotkey;

    public SelectConnectedSchematicObjs(Class<T1> selectionClass, Class<T2> searchClass, String actionDescription, String shortcutKey) {
        this(selectionClass, searchClass, Predicates.alwaysTrue(), actionDescription, shortcutKey);
    }

    public SelectConnectedSchematicObjs(Class<T1> selectionClass, Class<T2> searchClass, Predicate<T2> searchFilter, String actionDescription, String shortcutKey) {
        this.selectionClass = selectionClass;
        this.searchClass = searchClass;
        this.searchFilter = searchFilter;
        this.d_actionDescription = actionDescription;
        this.d_hook = new UIHook(this, actionDescription);
        this.d_hotkey = new BasicHotkey<UIHook>(shortcutKey, ShortcutInfo.Category.SELECTION, this.d_hook, true);
    }

    public UIHook getHook() {
        return this.d_hook;
    }

    @Override
    public Shortcut<UIHook> getKeyboardShortcut() {
        return this.d_hotkey.getKeyboardShortcut();
    }

    @Override
    public boolean isHeadless() {
        return this.d_hotkey.isHeadless();
    }

    @Override
    public void addContextMenuItem(GroupedSequence root) {
        root.getNode(ContextMenuUtils.ContextMenuNode.ENABLE_SELECT.id).getNode(ContextMenuUtils.ContextMenuNode.SELECT_WITHIN_ZONE.id).add(this.d_hook);
    }

    @Override
    public void run(VentusApp app, VentusData vd) {
        Set selObjs = vd.selection.getDeepSelected(this.selectionClass);
        try (VentusData.WriteLock lock = vd.lockWrite();){
            Undo.begin(this.d_actionDescription);
            Undo.insertUndoEntry_restoreSelection(vd);
            IdentityHashSet connectedObjs = new IdentityHashSet();
            for (ISchematicObj selObj : selObjs) {
                connectedObjs.addAll(selObj.getConnections(this.searchClass, this.searchFilter));
            }
            vd.selection.clear();
            vd.selection.selectAll(connectedObjs);
            Undo.end(vd);
        }
    }
}

