/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicComp;

public class SelectConflictingComps
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectConflictingComps(), Intl.intl("Select Conflicting Components"));

    public SelectConflictingComps() {
        VentusApp.getApp().getData().getEvents().addObserver(this);
        this.update(null);
    }

    public static Predicate<ISchematicComp> getFilter() {
        return new Predicate<ISchematicComp>(){

            @Override
            public boolean test(ISchematicComp o) {
                return !o.getConflicts().isEmpty();
            }
        };
    }

    @Override
    public void update(Events events) {
        if (events == null) {
            this.updateEnabled();
            return;
        }
        IEventRecord<ISchematicComp> evts = events.getEvents(ISchematicComp.class, new Class[0]);
        if (evts.isModified()) {
            this.updateEnabled();
        }
    }

    protected void updateEnabled() {
        VentusData md = VentusApp.getApp().getData();
        Set comps = md.selection.getDeepSelected(ISchematicComp.class);
        this.setEnabled(!(comps = theUtil.filter(comps, SelectConflictingComps.getFilter())).isEmpty());
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Select Conflicting Components"));
            Set comps = VentusApp.getApp().getData().selection.getDeepSelected(ISchematicComp.class);
            comps = theUtil.filter(comps, SelectConflictingComps.getFilter());
            Undo.insertUndoEntry_restoreSelection(md);
            md.selection.clear();
            for (ISchematicComp comp : comps) {
                for (Pair<ISchematicComp, ISchematicComp.ConflictType> conflict : comp.getConflicts()) {
                    md.selection.select((ISchematicComp)conflict.v1);
                }
            }
            Undo.end(md);
        }
    }
}

