/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import thunderheadeng.gui.OutputLog;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.FileFilters;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.MerlinOp;
import ventus.actions.UIHook;
import ventus.data.VentusData;

public class SaveOutputLogAction
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new SaveOutputLogAction(), Intl.intl("Save Output &Log..."), 84);

    @Override
    public void run(VentusApp app, VentusData md) {
        Object filename = md.filename;
        if (filename == null) {
            filename = "log.txt";
        } else {
            String[] fn = FilenameManager.splitFilename((String)filename);
            filename = fn[0] + "_log.txt";
        }
        guiJFXFileChooser chooser = new guiJFXFileChooser((String)filename, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_TEXT);
        File f = chooser.showSaveDialog();
        if (f == null) {
            return;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
        try {
            System.out.printf("Copying log file to: %s%n", f.getAbsolutePath());
            CopyFile.copy(OutputLog.logFile, f);
        }
        catch (IOException e) {
            e.printStackTrace();
            md.ui(() -> JOptionPane.showMessageDialog(app.getMainFrame(), e.getLocalizedMessage()));
        }
    }
}

