/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.io.File;
import javafx.stage.FileChooser;
import javax.swing.Icon;
import thunderheadeng.gui.guiJFXFileChooser;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.MerlinOp;
import ventus.actions.UIHook;
import ventus.data.RecentFilesEntry;
import ventus.data.VentusData;
import ventus.gui.guiUtil;
import ventus.io.VentusIO;

public class Save
extends AMerlinOp {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Save16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Save(), Intl.intl("&Save,S,Save model,Save the current model"), ICON);
    private static boolean s_forceSavePrompt = false;

    public static void setForceSavePrompt(boolean force) {
        s_forceSavePrompt = force;
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Save.saveToFile(app, md, false);
    }

    private static String promptForSaveFile(VentusApp app, VentusData md, String fn) {
        guiJFXFileChooser chooser;
        File saveFile;
        if (fn == null) {
            fn = String.format(Intl.intl("untitled.%s"), "vnts");
        }
        if ((saveFile = (chooser = new guiJFXFileChooser(fn, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, new FileChooser.ExtensionFilter(String.format(Intl.intl("%s File"), "Ventus"), "*.vnts"))).showSaveDialog()) == null) {
            return null;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, saveFile.getParent());
        return saveFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveToFile(VentusApp app, VentusData md, boolean forcePrompt) {
        String filename = md.filename;
        if ((forcePrompt |= s_forceSavePrompt) || filename == null) {
            String result = Save.promptForSaveFile(app, md, filename);
            if (result == null) {
                return false;
            }
            filename = result;
            app.setWorkingDir(filename);
        }
        app.beginWaitCursor();
        try {
            try {
                VentusIO.writeModel(filename, md);
            }
            catch (Throwable e) {
                guiUtil.showError(app, Intl.intl("File Error"), String.format(Intl.intl("Could not save %s"), filename), e);
                boolean bl = false;
                app.endWaitCursor();
                return bl;
            }
            s_forceSavePrompt = false;
            try (VentusData.WriteLock lock = md.lockWrite();){
                md.filename = filename;
                md.modified = false;
                md.getEvents().added((Object)new RecentFilesEntry(md.filename));
                md.getEvents().changed(md, VentusData.MODIFIED_CHANGED);
                md.getEvents().changed(md, VentusData.MODEL_SAVED);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            app.endWaitCursor();
        }
    }
}

