/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Set;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.MerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.VentusData;
import ventus.data.camera.Camera;
import ventus.data.camera.CameraList;
import ventus.mv.ModelView;

public class NewViewFromCamera
extends AMerlinOp
implements IEventObserver {
    public static final UIHook MENU_HOOK = new UIHook((MerlinOp)new NewViewFromCamera(true), Intl.intl("New View,-,Add a view initialized to the current perspective view."), EntryPointFactory.cameraIcon);
    public static final UIHook CONTEXT_HOOK = new UIHook((MerlinOp)new NewViewFromCamera(false), Intl.intl("New View,-,Add a view initialized to the current perspective view."), EntryPointFactory.cameraIcon);
    private final boolean d_mainMenu;

    public NewViewFromCamera(boolean mainMenu) {
        this.d_mainMenu = mainMenu;
        if (!this.d_mainMenu) {
            SelectionObserver.add(this, CameraList.class);
            this.update(null);
        }
    }

    @Override
    public void update(Events events) {
        VentusData md = VentusApp.getApp().getData();
        this.setEnabled(md.selection.isExclusive(CameraList.class));
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        CameraRecord state = md.ui(() -> {
            ModelView mv = app.getModelView();
            thunderheadeng.scene3d.nativebuffered.Camera mvcam = mv.getPredefCamera(3);
            return mvcam.capture();
        });
        try (VentusData.WriteLock lock = md.lockWrite();){
            Set selCamGroups;
            Undo.begin(Intl.intl("Add View"));
            CameraList group = null;
            if (!this.d_mainMenu && !(selCamGroups = md.selection.getSelected(CameraList.class)).isEmpty()) {
                group = (CameraList)selCamGroups.iterator().next();
            }
            if (group == null) {
                group = md.cameras;
            }
            Camera newCamera = new Camera(md.cameraNameGen.getCurrentName());
            md.cameraNameGen.nextName();
            newCamera.setCameraState(state);
            Undo.insertUndoEntry_delete(md, group, newCamera);
            group.add(newCamera);
            Undo.insertUndoEntry_restoreSelection(md);
            md.selection.set(newCamera);
            Undo.end(md);
        }
    }
}

