/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.beans.PropertyChangeListener;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.TaskProgress;
import ventus.VentusApp;
import ventus.data.VentusData;

public interface MerlinOp {
    public static final String ENABLED_CHANGED = "ENABLED_CHANGED";

    public void run(VentusApp var1, VentusData var2);

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public void removePropertyChangeListener(PropertyChangeListener var1);

    default public <T> Optional<Nullable<T>> execLongReadTaskNoThrow(VentusApp app, VentusData md, String title, TaskProgress progress, Callable<T> task) {
        try {
            return Optional.of(Nullable.of(this.execLongReadTask(app, md, title, progress, task)));
        }
        catch (CancellationException e) {
            return Optional.empty();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    default public <T> T execLongReadTask(VentusApp app, VentusData md, String title, TaskProgress progress, Callable<T> task) throws ExecutionException {
        guiProgressMonitor pm = new guiProgressMonitor(app.getMainFrame(), title, true, progress);
        return (T)pm.exec(() -> {
            try (VentusData.ReadLock lock = md.lockRead();){
                Object v = task.call();
                return v;
            }
        });
    }
}

