/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.Function;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.gui.ManagerDlg;
import ventus.util.MerlinUtil;

public class EditObjects<T extends IMerlinObj>
extends AMerlinOp {
    private final TypedProp<String> d_propName;
    private final Function<VentusData, Composite<? super T>> d_getRoot;
    private final BiConsumer<CompositeManager<T>, T> d_createDlg;
    private final Class<T> d_clazz;

    public EditObjects(TypedProp<String> propName, Function<VentusData, Composite<? super T>> getRoot, BiConsumer<CompositeManager<T>, T> createDlg, Class<T> clazz) {
        this.d_propName = propName;
        this.d_getRoot = getRoot;
        this.d_createDlg = createDlg;
        this.d_clazz = clazz;
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Composite<? super T> group = this.d_getRoot.apply(md);
        EditObjects.editObject(app, md, null, this.d_propName, group, this.d_createDlg, this.d_clazz);
    }

    public static <T extends IMerlinObj, TDlg extends ManagerDlg<?, ?>> void editObject(VentusApp app, VentusData md, final T init, final TypedProp<String> propName, final Composite<? extends IMerlinObj> group, final BiConsumer<CompositeManager<T>, T> createDlg, final Class<T> clazz) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Comparator cmp = new Comparator<T>(){

                    @Override
                    public int compare(T o1, T o2) {
                        String n1 = o1.getWithDetails(propName).orElse("");
                        String n2 = o2.getWithDetails(propName).orElse("");
                        return n1.compareToIgnoreCase(n2);
                    }
                };
                CompositeManager mgr = new CompositeManager(group, cmp, clazz);
                createDlg.accept(mgr, init);
            }
        };
        md.uiLater(runner);
    }

    public static class CompositeManager<T extends IMerlinObj>
    implements ManagerDlg.IManager<T> {
        private final Composite<?> d_objs;
        private final Class<T> d_clazz;
        private final Comparator<T> d_cmp;

        public CompositeManager(Composite<?> objs, Comparator<T> cmp, Class<T> clazz) {
            this.d_objs = objs;
            this.d_clazz = clazz;
            this.d_cmp = cmp;
        }

        @Override
        public String describe(T obj) {
            return MerlinUtil.getName(obj);
        }

        @Override
        public Collection<T> getSorted() {
            ArrayList<T> sorted = new ArrayList<T>(this.d_objs.flatten(this.d_clazz));
            Collections.sort(sorted, this.d_cmp);
            return sorted;
        }

        @Override
        public int size() {
            return this.d_objs.flatten(this.d_clazz).size();
        }
    }
}

