/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.VentusData;

public class ClearSelection
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new ClearSelection(), Intl.intl("Clear Selection"));

    public ClearSelection() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Clear Selection"));
            Undo.insertUndoEntry_restoreSelection(md);
            boolean modified = !md.selection.isEmpty();
            md.selection.clear();
            Undo.end(md, modified);
        }
    }

    @Override
    public void update(Events events) {
        VentusData md = VentusApp.getApp().getData();
        if (md == null) {
            return;
        }
        this.setEnabled(!md.selection.isEmpty());
    }
}

