/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.awt.Color;
import java.util.Collection;
import thunderheadeng.geometry.AABox;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.importgeom.ImportCAD;
import ventus.data.Composite;
import ventus.data.ImportedGeom;
import ventus.data.VentusData;

public class AddBackgroundQuad
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new AddBackgroundQuad(), Intl.intl("Add Background Rectangle"));

    public AddBackgroundQuad() {
        SelectionObserver.add(this, ImportedGeom.class);
        this.update(null);
    }

    protected Collection<ImportedGeom> getObjs(VentusData md) {
        return md.selection.getDeepSelected(ImportedGeom.class);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(!this.getObjs(VentusApp.getApp().getData()).isEmpty());
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        try (VentusData.WriteLock lock = md.lockWrite();){
            Collection<ImportedGeom> geom = this.getObjs(md);
            AABox bounds = new AABox();
            for (ImportedGeom ig : geom) {
                bounds.add(ig.getBounds());
            }
            if (!bounds.isValid()) {
                return;
            }
            ImportedGeom quad = ImportCAD.createBackgroundQuad(bounds, Color.BLACK);
            Object commonParent = md.hierarchy.getCommonParent(geom);
            if (commonParent instanceof Composite && ((Composite)commonParent).getFilter().test(quad)) {
                Undo.begin(Intl.intl("Add Background Rectangle"));
                Undo.insertUndoEntry_delete(md, (Composite)commonParent, quad);
                ((Composite)commonParent).add(quad);
                Undo.insertUndoEntry_restoreSelection(md);
                md.selection.set(quad);
                Undo.end(md);
            }
        }
    }
}

