/*
 * Decompiled with CFR 0.152.
 */
package ventus;

import java.awt.Font;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.Icon;
import ventus.EntryPoint;
import ventus.EntryPointFactory;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.INameGenerator;
import ventus.data.VentusData;
import ventus.data.schematics.SimError;
import ventus.feature.CompositeFeatureGuid;
import ventus.feature.FeatureGuid;
import ventus.feature.props.PropertyDefs;

public class EntryPointHelper<T> {
    public EntryPoint.Getter<T, Collection<? extends SimError>> getErrors;
    public EntryPoint.Getter<T, Collection<? extends SimError>> getRuntimeErrors;
    public EntryPoint.Getter<T, String> getName;
    public EntryPoint.Setter<T, String> setName;
    public EntryPoint.Getter<T, Boolean> canRename;
    public EntryPoint.AsyncGetter<T, Icon> getIcon;
    public EntryPoint.Getter<T, String> getType;
    public EntryPoint.Getter<T, Font> getBaseFont;
    public EntryPoint.Getter<T, Boolean> isVisible;
    public EntryPoint.Getter<T, Boolean> isEnabled;
    public EntryPoint.Getter<T, Boolean> getForcedAutoexpand;
    public EntryPoint.Getter<T, Boolean> isLeaf;
    public EntryPoint.Getter<T, Collection<?>> getChildren;
    public EntryPoint.Getter<T, Object> getParent;
    public EntryPoint.Getter<T, String> getCategoryName;
    public EntryPoint.Getter<T, Collection<? extends IMerlinObj>> getOtherDeleteObjs;
    public EntryPoint.Getter<T, Boolean> isDelUndoable;
    public EntryPoint.Getter<T, Class<? super T>> getDomainRequiredType;
    public EntryPoint.Getter<T, T> getConflict;
    public EntryPoint.Action<T, Boolean, Object> delete;
    public EntryPoint.Getter<T, Exception> canDelete;
    public EntryPoint.Getter<T, Boolean> isAutoDeleteGroup;
    public EntryPoint.Setter<T, Boolean> setVisible;
    public EntryPoint.Supplier<T, Composite<? extends IMerlinObj>> getRootComposite;
    public EntryPoint.Getter<T, INameGenerator> getNameGenerator;
    public EntryPoint.Getter<T, EntryPoint.INameGroup> getNameGroup;
    public EntryPoint.Getter<T, Predicate<String>> getNameFormat;
    public EntryPoint.Getter<T, Boolean> isIndexed;
    public EntryPoint.Getter<T, Boolean> isMovable;
    public EntryPoint.Getter<T, Boolean> canShowInReferencingLists;
    public EntryPoint.Supplier<T, PropertyDefs<? super T>> getPropertyDefs;
    public EntryPoint.Supplier<T, Boolean> isSearchType;
    public final Class<T> type;

    private EntryPointHelper(Class<T> type) {
        this.type = type;
    }

    public static <T> EntryPointHelper<T> rootEP(Class<T> clazz, Icon treeIcon, String category) {
        EntryPointHelper<T> helper = new EntryPointHelper<T>(clazz);
        helper.getIcon = (vd, obj, unused) -> treeIcon;
        helper.getCategoryName = EntryPointFactory.always(category);
        helper.isSearchType = EntryPointFactory.alwaysSupp(true);
        return helper;
    }

    public static <RootT extends Composite<ObjT>, ObjT extends IMerlinObj, V extends IMerlinObj> EntryPointHelper<V> objectEP(CompositeFeatureGuid<RootT, ObjT> guid, Class<V> type, PropertyDefs<? super V> propertyDefs, Icon treeIcon, String categoryName) {
        return EntryPointHelper.objectEP(guid, type, propertyDefs, (VentusData vd, V obj, Consumer<Icon> unused) -> treeIcon, (VentusData vd, V obj) -> categoryName);
    }

    public static <RootT extends Composite<ObjT>, ObjT extends IMerlinObj, V extends IMerlinObj> EntryPointHelper<V> objectEP(CompositeFeatureGuid<RootT, ObjT> guid, Class<V> type, PropertyDefs<? super V> propertyDefs, EntryPoint.AsyncGetter<V, Icon> getIcon, EntryPoint.Getter<V, String> getCategoryName) {
        EntryPointHelper<V> helper = new EntryPointHelper<V>(type);
        helper.getPropertyDefs = vd -> propertyDefs;
        helper.getIcon = getIcon;
        helper.getCategoryName = getCategoryName;
        helper.getType = (md, obj) -> EntryPointFactory.makeValidType((String)getCategoryName.get(md, obj));
        helper.getConflict = EntryPointFactory.getStandardConflictGetter(type);
        helper.getRootComposite = vd -> (Composite)vd.getComponentData(guid);
        helper.isSearchType = EntryPointFactory.alwaysSupp(true);
        return helper;
    }

    public static <RootT extends Composite<V>, V extends IMerlinObj, CompV extends Composite<V>> EntryPointHelper<CompV> groupEP(FeatureGuid<RootT> guid, Class<CompV> clazz, PropertyDefs<? super CompV> propertyDefs, Icon treeIcon, String category) {
        EntryPointHelper<CompV> helper = new EntryPointHelper<CompV>(clazz);
        helper.getIcon = (vd, obj, unused) -> treeIcon;
        String type = EntryPointFactory.makeValidType(category);
        helper.getType = (vd, obj) -> type;
        helper.getConflict = EntryPointFactory.getStandardConflictGetter(clazz);
        helper.getRootComposite = vd -> vd.getComponentData(guid);
        helper.getCategoryName = EntryPointFactory.always(category);
        helper.getPropertyDefs = vd -> propertyDefs;
        helper.isSearchType = EntryPointFactory.alwaysSupp(true);
        return helper;
    }

    public static <V extends IMerlinObj> EntryPointHelper<V> helperEP(Class<V> clazz) {
        return new EntryPointHelper<V>(clazz);
    }

    public void register() {
        EntryPointFactory.register(this);
    }
}

