/*
 * Decompiled with CFR 0.152.
 */
package ventus;

import java.awt.Font;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JFrame;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.theUtil;
import ventus.EntryPoint;
import ventus.EntryPointHelper;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.RenameAction;
import ventus.data.Composite;
import ventus.data.GeomComposite;
import ventus.data.IMerlinObj;
import ventus.data.INamed;
import ventus.data.ImportedGeom;
import ventus.data.MerlinSelectionModel;
import ventus.data.NamedMerlinObj;
import ventus.data.Proxy;
import ventus.data.SequentialNameGen;
import ventus.data.VentusData;
import ventus.data.ViewProps;
import ventus.data.camera.Camera;
import ventus.data.camera.CameraList;
import ventus.data.camera.ICameraObj;
import ventus.data.image.BGImage;
import ventus.data.image.ImageGroup;
import ventus.data.image.RasterImage;
import ventus.data.material.Material;
import ventus.data.material.MaterialDB;
import ventus.data.schematics.Floor;
import ventus.data.schematics.FloorComposite;
import ventus.data.schematics.FloorOptions;
import ventus.data.schematics.SimError;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.props.PropertyDefs;
import ventus.geom.Geometry;
import ventus.gui.guiUtil;
import ventus.mv.ModelView;
import ventus.mv.displays.IMerlinDispMgr;
import ventus.treeview.TVEntryPoint;

public class EntryPointFactory {
    private static final Map<Class<?>, EntryPoint> s_entryPoints = new LinkedHashMap();
    private static final Map<Pair<Class<?>, FuncType>, EntryPoint.Func<?>> s_funcs = new LinkedHashMap();
    private static final Map<FuncType, EntryPoint.Func> s_defaults = new HashMap<FuncType, EntryPoint.Func>();
    private static final Pattern FIND_MULTI_SPACES = Pattern.compile("[ ]+");
    public static final Icon mgrIcon = guiUtil.loadMerlinIcon("manager8.png");
    public static final Icon materialsIcon = guiUtil.loadIcon("ventus/icons/surfacedb16.gif", 16);
    public static final Icon cameraListIcon = guiUtil.loadMerlinIcon("cameras16.png", 16);
    public static final Icon cameraIcon = guiUtil.loadMerlinIcon("camera16.png", 16);
    public static final Icon floorIcon = guiUtil.loadMerlinIcon("floor16.png", 16);
    public static final Icon stairsIcon = guiUtil.loadMerlinIcon("stairs216.png", 16);
    public static final Icon exitIcon = guiUtil.loadMerlinIcon("exit16.png", 16);
    public static final Icon doorIcon = guiUtil.loadMerlinIcon("door216.png", 16);
    public static final Icon rampIcon = guiUtil.loadMerlinIcon("ramp16.png", 16);
    public static final Icon roomIcon = guiUtil.loadMerlinIcon("openrect16.png", 16);
    public static final Icon resumePriorIcon = guiUtil.loadMerlinIcon("return16.png", 16);
    public static final Icon importedGeometry2DIcon = guiUtil.loadMerlinIcon("2Dgeometry16.png", 16);
    public static final Icon importedGeometry3DIcon = guiUtil.loadMerlinIcon("block16_2.gif", 16);
    public static final Icon importedGeometryGroupIcon = guiUtil.loadMerlinIcon("composite16.png", 16);
    public static final Icon floorGroupIcon = guiUtil.loadMerlinIcon("mesh16.png", 16);
    public static final Icon backgroundImageIcon = guiUtil.loadMerlinIcon("backgroundImage16.gif", 16);
    public static final Icon blankIcon = null;
    public static final Icon waitIcon;
    public static final Icon waitUntilEndIcon;
    private static final Font s_plain;
    private static final Font s_bold;
    private static final Font s_italic;
    private static final Font s_italicBold;
    private static final EntryPoint.Getter<Composite<?>, Collection<? extends SimError>> processCompositeErrors;

    public static Icon getManagerIcon(Icon itemIcon) {
        return itemIcon == null ? null : new DecoratedIcon(itemIcon, mgrIcon, 3);
    }

    private static void registerDefault(FuncType funcType, EntryPoint.Func<?> func) {
        s_defaults.put(funcType, func);
    }

    public static void register(EntryPointHelper helper) {
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetErrors, helper.getErrors);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetRuntimeErrors, helper.getRuntimeErrors);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetName, helper.getName);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_SetName, helper.setName);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_CanRename, helper.canRename);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetIcon, helper.getIcon);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetType, helper.getType);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetBaseFont, helper.getBaseFont);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_IsVisible, helper.isVisible);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_IsEnabled, helper.isVisible);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetForcedAutoexpand, helper.getForcedAutoexpand);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_IsLeaf, helper.isLeaf);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetChildren, helper.getChildren);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetParent, helper.getParent);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.CategoryName, helper.getCategoryName);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.GetDeletionErr, helper.canDelete);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.IsDelUndoable, helper.isDelUndoable);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.DomainRequiredType, helper.getDomainRequiredType);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.GetConflict, helper.getConflict);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.Delete, helper.delete);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.IsAutoDeleteGroup, helper.isAutoDeleteGroup);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.IsVisible, helper.isVisible);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.SetVisible, helper.setVisible);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.GetCompositeRoot, helper.getRootComposite);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.GetNameGenerator, helper.getNameGenerator);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.GetUniqueNameGroup, helper.getNameGroup);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.GetNameFormatRules, helper.getNameFormat);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.IsIndexed, helper.isIndexed);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.IsMovable, helper.isMovable);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.CanShowInReferencingLists, helper.canShowInReferencingLists);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.GetPropertyDefs, helper.getPropertyDefs);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.IsSearchType, helper.isSearchType);
    }

    private static <T> void registerIfPresent(Class<T> type, FuncType funcType, EntryPoint.Func<?> func) {
        if (func != null) {
            EntryPointFactory.register(type, funcType, func);
        }
    }

    public static <T> void register(Class<T> type, FuncType funcType, EntryPoint.Func<?> func) {
        s_funcs.put(new Pair<Class<T>, FuncType>(type, funcType), func);
    }

    public static <T, ReturnT> void register(Class<T> type, FuncType funcType, EntryPoint.Getter<T, ReturnT> getter) {
        EntryPointFactory.register(type, funcType, getter);
    }

    public static <T, ReturnT> void register(Class<T> type, FuncType funcType, EntryPoint.Supplier<T, ReturnT> supplier) {
        EntryPointFactory.register(type, funcType, supplier);
    }

    public static <T, ReturnT, ArgT> void register(Class<T> type, FuncType funcType, EntryPoint.Action<T, ReturnT, ArgT> action) {
        EntryPointFactory.register(type, funcType, action);
    }

    public static <T, ArgT> void register(Class<T> type, FuncType funcType, EntryPoint.Setter<T, ArgT> setter) {
        EntryPointFactory.register(type, funcType, setter);
    }

    public static void registerIcon(Class<?> type, Icon icon) {
        EntryPointFactory.register(type, FuncType.TV_GetIcon, new ConstantAsyncGetter(icon));
    }

    private static <T extends IMerlinObj> void registerType(Class<T> type, PropertyDefs<? super T> propertyDefs, String category, boolean searchable) {
        EntryPointFactory.registerType(type, propertyDefs, category, EntryPointFactory.makeValidType(category), searchable);
    }

    private static <T extends IMerlinObj> void registerType(Class<T> type, PropertyDefs<? super T> propertyDefs, String categoryName, String typeString, boolean searchable) {
        EntryPointFactory.register(type, FuncType.GetPropertyDefs, new ConstantSupplier(propertyDefs));
        EntryPointFactory.register(type, FuncType.TV_GetType, new ConstantGetter(typeString));
        EntryPointFactory.register(type, FuncType.CategoryName, new ConstantGetter(categoryName));
        EntryPointFactory.register(type, FuncType.IsSearchType, new ConstantSupplier(searchable));
    }

    public static <T> EntryPoint<T> get(T obj) {
        return EntryPointFactory.get(obj.getClass(), obj);
    }

    public static synchronized <T> EntryPoint<T> get(Class clazz) {
        return EntryPointFactory.get(clazz, null);
    }

    private static synchronized <T> EntryPoint<T> get(Class clazz, T obj) {
        EntryPoint ep = s_entryPoints.get(clazz);
        if (ep != null) {
            return ep;
        }
        TVEntryPoint tvep = new TVEntryPoint((EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetErrors, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetRuntimeErrors, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetName, obj), (EntryPoint.Setter)EntryPointFactory.findFunc(clazz, FuncType.TV_SetName, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_CanRename, obj), (EntryPoint.AsyncGetter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetIcon, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetBaseFont, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_IsVisible, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_IsEnabled, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetForcedAutoexpand, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_IsLeaf, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetChildren, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetParent, obj));
        ep = new EntryPoint(clazz, tvep, (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetDeletionErr, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetConflict, obj), (EntryPoint.Action)EntryPointFactory.findFunc(clazz, FuncType.Delete, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsAutoDeleteGroup, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsDelUndoable, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsVisible, obj), (EntryPoint.Setter)EntryPointFactory.findFunc(clazz, FuncType.SetVisible, obj), (EntryPoint.Supplier)EntryPointFactory.findFunc(clazz, FuncType.GetCompositeRoot, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetNameFormatRules, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetNameGenerator, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetUniqueNameGroup, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsIndexed, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsMovable, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetType, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.CategoryName, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.DomainRequiredType, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.CanShowInReferencingLists, obj), (EntryPoint.Supplier)EntryPointFactory.findFunc(clazz, FuncType.GetPropertyDefs, obj), (EntryPoint.Supplier)EntryPointFactory.findFunc(clazz, FuncType.IsSearchType, obj));
        s_entryPoints.put(clazz, ep);
        return ep;
    }

    private static Collection<SimError> lazyAdd(Collection<SimError> coll, SimError err) {
        if (coll.isEmpty()) {
            coll = new ArrayDeque<SimError>();
        }
        coll.add(err);
        return coll;
    }

    public static <T, RetT> EntryPoint.Getter<T, RetT> always(RetT value) {
        return new ConstantGetter(value);
    }

    public static <T, RetT> EntryPoint.Supplier<T, RetT> alwaysSupp(RetT value) {
        return new ConstantSupplier(value);
    }

    private static <T extends IMerlinObj> EntryPoint.Func<T> findFunc(Class<?> clazz, FuncType funcType, Object obj) {
        EntryPoint.Func func = EntryPointFactory.findFuncHelper(clazz, funcType);
        return func != null ? func : s_defaults.get((Object)funcType);
    }

    private static <T extends IMerlinObj> EntryPoint.Func<T> findFuncHelper(Class<?> clazz, FuncType funcType) {
        if (clazz == null) {
            return null;
        }
        EntryPoint.Func<Object> func = s_funcs.get(new Pair(clazz, funcType));
        if (func != null) {
            return func;
        }
        func = EntryPointFactory.findFuncHelper(clazz.getSuperclass(), funcType);
        if (func != null) {
            return func;
        }
        for (Class<?> ifaceClass : clazz.getInterfaces()) {
            func = EntryPointFactory.findFuncHelper(ifaceClass, funcType);
            if (func == null) continue;
            return func;
        }
        return null;
    }

    public static synchronized List<EntryPoint> getAll() {
        return s_funcs.keySet().stream().map(key -> (Class)key.v1).distinct().map(EntryPointFactory::get).toList();
    }

    public static <T> EntryPoint.Getter<T, T> getStandardConflictGetter(final Class<T> clazz) {
        return new EntryPoint.Getter<T, T>(){

            @Override
            public T get(VentusData md, T comparable) {
                Collection members = EntryPointFactory.get(comparable).getRootComposite(md).flatten(clazz);
                for (Object conflict : members) {
                    if (!theUtil.equal(comparable, conflict)) continue;
                    return conflict;
                }
                return null;
            }
        };
    }

    public static <T> boolean deletingAllOfType(VentusData vd, Set<? extends IMerlinObj> delObjs, Class<T> type, Composite<? super T> root) {
        return root.flatten(type).stream().allMatch(obj -> {
            Object mobj = obj;
            while (mobj != null) {
                if (delObjs.contains(mobj)) {
                    return true;
                }
                mobj = vd.hierarchy.getParent(mobj);
            }
            return false;
        });
    }

    public static <T> EntryPoint.Getter<T, EntryPoint.INameGroup> nameGroup(Function<VentusData, ? extends Collection<?>> getter) {
        EntryPoint.INameGroup group = getter::apply;
        return new ConstantGetter(group);
    }

    public static String makeValidType(String str) {
        String result = str.replace('/', '_').replace('\\', '_').replace("-", " ");
        String noSpaces = FIND_MULTI_SPACES.matcher(result).replaceAll(m -> "_");
        return noSpaces;
    }

    static {
        waitUntilEndIcon = waitIcon = guiUtil.loadMerlinIcon("clock16.png", 16);
        s_plain = new Font("Sans Serif", 0, 11);
        s_bold = new Font("Sans Serif", 1, 11);
        s_italic = new Font("Sans Serif", 2, 11);
        s_italicBold = s_italic.deriveFont(1);
        processCompositeErrors = (vd, obj) -> {
            ArrayList<SimError> moderateErrors = new ArrayList<SimError>();
            ArrayList<SimError> criticalErrors = new ArrayList<SimError>();
            SimError.Type type = SimError.Type.RESULTS;
            for (IMerlinObj eobj : obj.getMembers(IMerlinObj.class)) {
                for (SimError se : EntryPointFactory.get(eobj).tvEntryPoint.getErrors(vd, eobj)) {
                    int numErrors;
                    if (se.type.equals((Object)SimError.Type.DATA)) {
                        type = SimError.Type.DATA;
                    }
                    int n = numErrors = se instanceof CompositeSimError ? ((CompositeSimError)se).errorCount : 1;
                    if (se.level == SimError.Level.CRITICAL) {
                        criticalErrors.add(se);
                        continue;
                    }
                    moderateErrors.add(se);
                }
            }
            if (!moderateErrors.isEmpty() || !criticalErrors.isEmpty()) {
                ArrayList<CompositeSimError> errors = new ArrayList<CompositeSimError>(2);
                if (!moderateErrors.isEmpty()) {
                    errors.add(new CompositeSimError(SimError.Level.MODERATE, moderateErrors, type));
                }
                if (!criticalErrors.isEmpty()) {
                    errors.add(new CompositeSimError(SimError.Level.CRITICAL, criticalErrors, type));
                }
                return errors;
            }
            return Collections.emptyList();
        };
        EntryPointFactory.registerDefault(FuncType.GetDeletionErr, EntryPointFactory.always(null));
        EntryPointFactory.registerDefault(FuncType.GetConflict, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.Delete, new NullAction(false));
        EntryPointFactory.registerDefault(FuncType.IsAutoDeleteGroup, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.IsDelUndoable, EntryPointFactory.always(true));
        EntryPointFactory.registerDefault(FuncType.DomainRequiredType, EntryPointFactory.always(null));
        EntryPointFactory.registerDefault(FuncType.IsVisible, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.SetVisible, new NullSetter());
        EntryPointFactory.registerDefault(FuncType.GetCompositeRoot, new ConstantSupplier(null));
        EntryPointFactory.registerDefault(FuncType.GetNameFormatRules, new ConstantGetter(Predicates.alwaysTrue()));
        EntryPointFactory.registerDefault(FuncType.GetNameGenerator, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.GetUniqueNameGroup, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.IsIndexed, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.IsMovable, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.CategoryName, new ConstantGetter(""));
        EntryPointFactory.registerDefault(FuncType.CanShowInReferencingLists, EntryPointFactory.always(true));
        EntryPointFactory.registerDefault(FuncType.GetPropertyDefs, new ConstantSupplier(null));
        EntryPointFactory.registerDefault(FuncType.IsSearchType, new ConstantSupplier(true));
        EntryPointFactory.registerDefault(FuncType.TV_GetErrors, new ConstantGetter(Collections.EMPTY_LIST));
        EntryPointFactory.registerDefault(FuncType.TV_GetName, new ConstantGetter(""));
        EntryPointFactory.registerDefault(FuncType.TV_SetName, new NullSetter());
        EntryPointFactory.registerDefault(FuncType.TV_CanRename, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.TV_GetIcon, new ConstantAsyncGetter(null));
        EntryPointFactory.registerDefault(FuncType.TV_GetType, new EntryPoint.Getter<Object, String>(){

            @Override
            public String get(VentusData md, Object obj) {
                return EntryPointFactory.makeValidType(EntryPointFactory.get(obj).getCategoryName(md, obj));
            }
        });
        EntryPointFactory.registerDefault(FuncType.TV_GetBaseFont, new ConstantGetter(s_plain));
        EntryPointFactory.registerDefault(FuncType.TV_IsVisible, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.TV_IsEnabled, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.TV_GetForcedAutoexpand, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.TV_IsLeaf, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.TV_GetChildren, new ConstantGetter(Collections.EMPTY_LIST));
        EntryPointFactory.registerDefault(FuncType.TV_GetParent, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.TV_GetRuntimeErrors, new ConstantGetter(Collections.EMPTY_LIST));
        EntryPointFactory.register(VentusData.class, FuncType.TV_GetErrors, (VentusData md, T obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            for (IMerlinObj iMerlinObj : md.getChildren()) {
                errors.addAll(EntryPointFactory.get(iMerlinObj).tvEntryPoint.getErrors(md, iMerlinObj));
            }
            return errors;
        });
        EntryPointFactory.register(VentusData.class, FuncType.TV_GetChildren, (VentusData md, T obj) -> {
            Predicate<IMerlinObj> filter = o -> EntryPointFactory.get(o).tvEntryPoint.getParent(md, (IMerlinObj)o) == md;
            return obj.getChildren().stream().filter(filter).collect(Collectors.toList());
        });
        EntryPointFactory.register(INamed.class, FuncType.TV_GetName, new EntryPoint.Getter<INamed, String>(){

            @Override
            public String get(VentusData md, INamed obj) {
                return obj.getName();
            }
        });
        EntryPointFactory.register(INamed.class, FuncType.TV_SetName, new EntryPoint.Setter<INamed, String>(){

            @Override
            public void set(VentusData md, INamed obj, String arg) {
                VentusApp app = VentusApp.getApp();
                JFrame parent = app != null ? app.getActiveFrame() : null;
                RenameAction.rename(md, parent, Arrays.asList(obj), arg);
            }
        });
        EntryPointFactory.register(INamed.class, FuncType.TV_CanRename, new EntryPoint.Getter<INamed, Boolean>(){

            @Override
            public Boolean get(VentusData md, INamed obj) {
                return obj.isSetNameSupported();
            }
        });
        EntryPointFactory.registerType(NamedMerlinObj.class, NamedMerlinObj.PROP_TYPES, Intl.intl("Named Object"), false);
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_GetChildren, (VentusData md, T obj) -> obj.getChildren());
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_GetParent, (VentusData md, T obj) -> md.hierarchy.getParent(obj));
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_IsLeaf, (VentusData md, T obj) -> obj.getChildren().isEmpty());
        EntryPointFactory.register(IMerlinObj.class, FuncType.GetCompositeRoot, (VentusData md) -> md.floors);
        EntryPointFactory.register(IMerlinObj.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Geom", 2)));
        EntryPointFactory.register(IMerlinObj.class, FuncType.Delete, new EntryPoint.Action<IMerlinObj, Boolean, Object>(){

            @Override
            public Boolean perform(VentusData md, IMerlinObj obj, Object arg) {
                Object parentObj = md.hierarchy.getParent(obj);
                if (!(parentObj instanceof Composite)) {
                    return false;
                }
                Composite parent = (Composite)parentObj;
                return parent.remove(obj);
            }
        });
        EntryPointFactory.register(IMerlinObj.class, FuncType.IsVisible, new EntryPoint.Getter<IMerlinObj, Boolean>(){

            @Override
            public Boolean get(VentusData md, IMerlinObj obj) {
                PropValue<Boolean> value = obj.getWithDetails(VentusData.VISIBILITY);
                boolean basevis = value.orElse(true);
                return basevis && !md.displayFilter.filter(obj);
            }
        });
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_IsEnabled, new EntryPoint.Getter<IMerlinObj, Boolean>(){

            @Override
            public Boolean get(VentusData md, IMerlinObj obj) {
                return obj.getWithDetails(VentusData.ENABLED).orElse(true);
            }
        });
        EntryPointFactory.register(IMerlinObj.class, FuncType.SetVisible, new EntryPoint.Setter<IMerlinObj, Boolean>(){

            @Override
            public void set(VentusData md, IMerlinObj obj, Boolean arg) {
                obj.set(VentusData.VISIBILITY, arg);
                if (!arg.booleanValue()) {
                    md.selection.deselect(obj);
                }
            }
        });
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_IsVisible, new EntryPoint.Getter<IMerlinObj, Boolean>(){

            @Override
            public Boolean get(VentusData md, IMerlinObj obj) {
                return obj.getWithDetails(VentusData.VISIBILITY).orElse(true);
            }
        });
        EntryPointFactory.registerType(Composite.class, Composite.PROP_TYPES, Intl.intl("Group"), false);
        EntryPointFactory.register(Composite.class, FuncType.GetDeletionErr, new EntryPoint.Getter<Composite<?>, Exception>(){

            @Override
            public Exception get(VentusData md, Composite<?> obj) {
                if (md.hierarchy.getParent(obj) == md) {
                    return new Exception(Intl.intl("Cannot delete a root object."));
                }
                for (IMerlinObj child : obj.getChildren()) {
                    EntryPoint<IMerlinObj> ep = EntryPointFactory.get(child);
                    try {
                        ep.testDelete(md, child);
                    }
                    catch (Exception e) {
                        return e;
                    }
                }
                return null;
            }
        });
        EntryPointFactory.register(Composite.class, FuncType.TV_GetErrors, processCompositeErrors);
        EntryPointFactory.register(Composite.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.registerType(GeomComposite.class, GeomComposite.PROP_TYPES, Intl.intl("Group"), true);
        EntryPointFactory.register(GeomComposite.class, FuncType.TV_GetBaseFont, new EntryPoint.Getter<GeomComposite<?>, Font>(){

            @Override
            public Font get(VentusData md, GeomComposite<?> obj) {
                if (md.floors.getActive().getWorkingGeomGroup() == obj) {
                    return s_italic;
                }
                return EntryPointFactory.get(GeomComposite.class.getSuperclass()).tvEntryPoint.getBaseFont(md, obj);
            }
        });
        EntryPointFactory.register(GeomComposite.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<GeomComposite<?>, Icon>(){

            @Override
            public Icon get(VentusData md, GeomComposite<?> obj, Consumer<Icon> whenReady) {
                if (md.hierarchy.isDescendent(md.sceneGeom, obj)) {
                    return importedGeometryGroupIcon;
                }
                if (md.hierarchy.isDescendent(md.floors, obj)) {
                    return floorGroupIcon;
                }
                return blankIcon;
            }
        });
        EntryPointFactory.register(GeomComposite.class, FuncType.CategoryName, new EntryPoint.Getter<GeomComposite<?>, String>(){

            @Override
            public String get(VentusData md, GeomComposite<?> obj) {
                return Intl.intl("Geometry Group");
            }
        });
        EntryPointFactory.register(CameraList.class, FuncType.GetCompositeRoot, (VentusData md) -> md.cameras);
        EntryPointFactory.register(CameraList.class, FuncType.GetNameGenerator, (VentusData md, T obj) -> md.cameraNameGen);
        EntryPointFactory.registerIcon(CameraList.class, cameraListIcon);
        EntryPointFactory.registerType(CameraList.class, CameraList.PROP_TYPES, Intl.intl("View Group"), true);
        EntryPointFactory.register(CameraList.class, FuncType.IsAutoDeleteGroup, new EntryPoint.Getter<CameraList, Boolean>(){

            @Override
            public Boolean get(VentusData md, CameraList obj) {
                return md.cameras != obj;
            }
        });
        EntryPointFactory.registerIcon(Camera.class, cameraIcon);
        EntryPointFactory.registerType(Camera.class, Camera.PROP_TYPES, Intl.intl("View"), true);
        EntryPointFactory.register(ICameraObj.class, FuncType.GetCompositeRoot, (VentusData md) -> md.cameras);
        EntryPointFactory.register(ICameraObj.class, FuncType.GetNameGenerator, (VentusData md, T obj) -> md.cameraNameGen);
        EntryPointFactory.register(ICameraObj.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(Floor.class, FuncType.GetCompositeRoot, (VentusData md) -> md.floors);
        EntryPointFactory.register(Floor.class, FuncType.GetNameGenerator, (VentusData md, T obj) -> new ConstantGetter(new SequentialNameGen("Level", 2)));
        EntryPointFactory.register(Floor.class, FuncType.IsMovable, new ConstantGetter(false));
        EntryPointFactory.registerIcon(Floor.class, floorIcon);
        EntryPointFactory.registerType(Floor.class, Floor.PROP_TYPES, Intl.intl("Floor"), true);
        EntryPointFactory.register(Floor.class, FuncType.TV_GetBaseFont, new EntryPoint.Getter<Floor, Font>(){

            @Override
            public Font get(VentusData md, Floor obj) {
                boolean working;
                boolean active = md.floors.getActive() == obj;
                boolean bl = working = md.floors.getActive().getWorkingGeomGroup() == obj;
                if (active && working) {
                    return s_italicBold;
                }
                if (active) {
                    return s_bold;
                }
                if (working) {
                    return s_italic;
                }
                return EntryPointFactory.get(Floor.class.getSuperclass()).tvEntryPoint.getFont(md, obj);
            }
        });
        EntryPointFactory.register(Floor.class, FuncType.GetDeletionErr, new EntryPoint.Getter<Floor, Exception>(){

            @Override
            public Exception get(VentusData md, Floor obj) {
                if (obj == md.activeFloor()) {
                    return new Exception(Intl.intl("The active level cannot be deleted."));
                }
                return null;
            }
        });
        EntryPointFactory.register(Floor.class, FuncType.TV_GetErrors, new EntryPoint.Getter<Floor, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(VentusData vd, Floor obj) {
                ArrayList<? extends SimError> errors = new ArrayList<SimError>();
                Optional<Floor> floorAbove = vd.floors.flatten(Floor.class).stream().sorted(Comparator.comparingDouble(floor -> floor.getWorkingZ().get(Geometry.LENGTH_UNIT))).filter(floor -> floor.getWorkingZ().gt(obj.getWorkingZ(), 0.0)).findFirst();
                if (!floorAbove.isEmpty()) {
                    Floor above = floorAbove.get();
                    UnitDouble zMax = obj.getWorkingZ().add(obj.getHeight());
                    if (zMax.gt(above.getWorkingZ(), 0.0)) {
                        String msg = Intl.intl("Height causes overlap into next floor.");
                        String action = Intl.intl("Please Review");
                        errors.add(new SimError(SimError.Level.MODERATE, msg, action, obj));
                    }
                }
                if (obj instanceof Composite) {
                    Floor compFloor = obj;
                    errors.addAll(processCompositeErrors.get(vd, compFloor));
                }
                return errors;
            }
        });
        EntryPointFactory.registerIcon(FloorComposite.class, floorIcon);
        EntryPointFactory.registerType(FloorComposite.class, FloorComposite.PROP_TYPES, Intl.intl("Floor Group"), true);
        EntryPointFactory.registerType(ISchematicRoom.class, ISchematicRoom.PROP_TYPES, Intl.intl("Room"), false);
        EntryPointFactory.registerIcon(ISchematicRoom.class, roomIcon);
        EntryPointFactory.register(ISchematicRoom.class, FuncType.GetConflict, (VentusData vd, T comparable) -> null);
        EntryPointFactory.register(ISchematicRoom.class, FuncType.TV_GetErrors, new EntryPoint.Getter<ISchematicRoom, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(VentusData md, ISchematicRoom obj) {
                Collection<SimError> warnings = Collections.emptyList();
                Collection<Pair<ISchematicComp, ISchematicComp.ConflictType>> conflicts = obj.getConflicts();
                for (Pair<ISchematicComp, ISchematicComp.ConflictType> conflict : conflicts) {
                    if (!Objects.equals(conflict.v2, (Object)ISchematicComp.ConflictType.LEVEL_MISMATCH_Z)) continue;
                    String msg = String.format(Intl.intl("Vertical position of zone outside level working-z and height"), obj.getName());
                    String fix = Intl.intl("Set Z for zone, update level, or ignore.");
                    warnings = EntryPointFactory.lazyAdd(warnings, new SimError(SimError.Level.MODERATE, msg, fix, obj));
                }
                return warnings;
            }
        });
        EntryPointFactory.registerType(SchematicRoom.class, SchematicRoom.PROP_TYPES, Intl.intl("Zone"), true);
        EntryPointFactory.register(SchematicRoom.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(SchematicRoom.class));
        EntryPointFactory.register(SchematicRoom.class, FuncType.TV_GetErrors, new EntryPoint.Getter<SchematicRoom, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(VentusData md, SchematicRoom room) {
                Collection<SimError> errors = Collections.emptyList();
                if (!room.isCeiling() && !room.connectedToAmbient()) {
                    errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("%s has no connection to Ambient."), room.getName()), Intl.intl("Add Flow Path connections to the Zone or remove it."), room));
                }
                return errors;
            }
        });
        EntryPointFactory.registerType(ImportedGeom.class, ImportedGeom.PROP_TYPES, Intl.intl("Imported Geometry"), Intl.intl("Imported"), true);
        EntryPointFactory.register(ImportedGeom.class, FuncType.GetCompositeRoot, (VentusData md) -> md.sceneGeom);
        EntryPointFactory.register(ImportedGeom.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Imported", 2)));
        EntryPointFactory.register(ImportedGeom.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<ImportedGeom, Icon>(){

            @Override
            public Icon get(VentusData md, ImportedGeom obj, Consumer<Icon> whenReady) {
                if (obj.getGeom().getNumPrims(1) > 0) {
                    return importedGeometry3DIcon;
                }
                return importedGeometry2DIcon;
            }
        });
        EntryPointFactory.registerType(ImageGroup.class, ImageGroup.PROP_TYPES, Intl.intl("Image Group"), false);
        EntryPointFactory.registerIcon(RasterImage.class, backgroundImageIcon);
        EntryPointFactory.registerType(RasterImage.class, RasterImage.PROP_TYPES, Intl.intl("Image"), false);
        EntryPointFactory.registerType(BGImage.class, BGImage.PROP_TYPES, Intl.intl("Background Image"), true);
        EntryPointFactory.register(Proxy.class, FuncType.TV_GetForcedAutoexpand, new EntryPoint.Getter<Proxy<? extends IMerlinObj>, Boolean>(){

            @Override
            public Boolean get(VentusData md, Proxy<? extends IMerlinObj> obj) {
                return md.selection.isSelected(obj);
            }
        });
        EntryPointFactory.register(Proxy.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<Proxy<? extends IMerlinObj>, Icon>(){

            @Override
            public Icon get(VentusData md, Proxy<? extends IMerlinObj> proxy, Consumer<Icon> whenReady) {
                IMerlinObj obj = proxy.getObj();
                return ((EntryPoint.AsyncGetter)EntryPointFactory.findFunc(obj.getClass(), FuncType.TV_GetIcon, obj)).get(md, obj, whenReady);
            }
        });
        EntryPointFactory.register(Proxy.class, FuncType.TV_GetErrors, new EntryPoint.Getter<Proxy, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(VentusData md, Proxy obj) {
                EntryPoint superep = EntryPointFactory.get(obj.getClass().getSuperclass());
                ArrayList<SimError> errors = new ArrayList<SimError>(superep.tvEntryPoint.getErrors(md, obj));
                return errors;
            }
        });
        EntryPointFactory.register(MerlinSelectionModel.class, FuncType.TV_GetParent, (VentusData md, T obj) -> null);
        EntryPointFactory.register(ViewProps.class, FuncType.TV_GetParent, (VentusData md, T obj) -> null);
        EntryPointFactory.register(FloorOptions.class, FuncType.TV_GetParent, (VentusData md, T obj) -> null);
        EntryPointFactory.register(MaterialDB.class, FuncType.TV_GetParent, (VentusData md, T obj) -> null);
        EntryPointFactory.registerIcon(MaterialDB.class, materialsIcon);
        EntryPointFactory.registerType(MaterialDB.class, MaterialDB.PROP_TYPES, Intl.intl("Material Database"), false);
        EntryPointFactory.register(Material.class, FuncType.IsDelUndoable, (VentusData md, T obj) -> !md.materials.isPermanent((Material)obj));
        EntryPointFactory.registerType(Material.class, Material.PROP_TYPES, Intl.intl("Material"), false);
        EntryPointFactory.register(Material.class, FuncType.GetCompositeRoot, (VentusData md) -> md.materials);
        EntryPointFactory.register(Material.class, FuncType.Delete, new EntryPoint.Action<Material, Boolean, Object>(){

            @Override
            public Boolean perform(VentusData md, Material obj, Object arg) {
                MaterialDB db = md.materials;
                return db.remove(obj, true);
            }
        });
        EntryPointFactory.register(Material.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<Material, Icon>(){

            @Override
            public Icon get(VentusData md, Material obj, Consumer<Icon> whenReady) {
                return guiUtil.getIconsAsync(icons -> whenReady.accept(icons[0]), obj, 16, 16, 0, guiUtil.ImageFilter.NORMAL)[0];
            }
        });
        EntryPointFactory.register(Material.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(Material.class));
        for (Pair<Class<?>, FuncType> funcEntry : s_funcs.keySet()) {
            EntryPointFactory.get((Class)funcEntry.v1);
        }
    }

    public static enum FuncType {
        GetDeletionErr,
        GetConflict,
        Delete,
        IsAutoDeleteGroup,
        IsDelUndoable,
        DomainRequiredType,
        IsVisible,
        SetVisible,
        GetCompositeRoot,
        GetNameGenerator,
        GetUniqueNameGroup,
        GetNameFormatRules,
        IsIndexed,
        IsMovable,
        CategoryName,
        CanShowInReferencingLists,
        GetPropertyDefs,
        IsSearchType,
        TV_GetErrors,
        TV_GetRuntimeErrors,
        TV_GetName,
        TV_SetName,
        TV_CanRename,
        TV_GetIcon,
        TV_GetType,
        TV_GetBaseFont,
        TV_IsVisible,
        TV_IsEnabled,
        TV_GetForcedAutoexpand,
        TV_IsLeaf,
        TV_GetChildren,
        TV_GetParent;

    }

    public static class ConstantAsyncGetter<T, ReturnT>
    implements EntryPoint.AsyncGetter<T, ReturnT> {
        private final ReturnT d_value;

        public ConstantAsyncGetter(ReturnT value) {
            this.d_value = value;
        }

        @Override
        public ReturnT get(VentusData md, T obj, Consumer<ReturnT> whenReady) {
            return this.d_value;
        }
    }

    public static class ConstantSupplier<T, ReturnT>
    implements EntryPoint.Supplier<T, ReturnT> {
        private final ReturnT d_value;

        public ConstantSupplier(ReturnT value) {
            this.d_value = value;
        }

        @Override
        public ReturnT get(VentusData md) {
            return this.d_value;
        }
    }

    public static class ConstantGetter<T, ReturnT>
    implements EntryPoint.Getter<T, ReturnT> {
        private final ReturnT d_value;

        public ConstantGetter(ReturnT value) {
            this.d_value = value;
        }

        @Override
        public ReturnT get(VentusData md, T obj) {
            return this.d_value;
        }
    }

    public static class CompositeSimError
    extends SimError {
        public final int errorCount;
        public final Collection<? extends SimError> children;

        public CompositeSimError(SimError.Level level, Collection<? extends SimError> errors) {
            this(level, errors, SimError.Type.DATA);
        }

        public CompositeSimError(SimError.Level level, Collection<? extends SimError> errors, SimError.Type type) {
            super(level, Integer.toString(errors.size()), "", errors.stream().flatMap(e -> e.causeObjs.stream()).toList(), type);
            this.errorCount = errors.size();
            this.children = errors;
        }
    }

    public static class NullAction<T, ReturnT, ArgT>
    implements EntryPoint.Action<T, ReturnT, ArgT> {
        private final ReturnT d_value;

        public NullAction(ReturnT defReturn) {
            this.d_value = defReturn;
        }

        @Override
        public ReturnT perform(VentusData md, T obj, ArgT arg) {
            return this.d_value;
        }
    }

    public static class NullSetter<T, ArgT>
    implements EntryPoint.Setter<T, ArgT> {
        @Override
        public void set(VentusData md, T obj, ArgT arg) {
        }
    }

    private static abstract class MVMgrConstructor<T>
    implements EntryPoint.Action<T, Collection<? extends IMerlinDispMgr<?>>, ModelView> {
        private Collection<? extends IMerlinDispMgr<?>> d_managers;

        private MVMgrConstructor() {
        }

        @Override
        public Collection<? extends IMerlinDispMgr<?>> perform(VentusData md, T obj, ModelView mv) {
            if (this.d_managers != null) {
                return this.d_managers;
            }
            this.d_managers = this.create(md, obj, mv);
            return this.d_managers;
        }

        protected abstract Collection<? extends IMerlinDispMgr<?>> create(VentusData var1, T var2, ModelView var3);
    }
}

