/*
 * Decompiled with CFR 0.152.
 */
package ventus;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.INameGenerator;
import ventus.data.VentusData;
import ventus.feature.props.PropertyDefs;
import ventus.treeview.TVEntryPoint;

public class EntryPoint<T> {
    public final Class<T> clazz;
    public final TVEntryPoint<T> tvEntryPoint;
    private final Getter<T, T> getConflict;
    private final Action<T, Boolean, Object> delete;
    private final Getter<T, Exception> canDelete;
    private final Getter<T, Boolean> isAutoDeleteGroup;
    private final Getter<T, Boolean> isDelUndoable;
    private final Getter<T, Boolean> isVisible;
    private final Setter<T, Boolean> setVisible;
    private final Supplier<T, Composite<? extends IMerlinObj>> getRootComposite;
    private final Getter<T, INameGenerator> getNameGenerator;
    private final Getter<T, Predicate<String>> getNameFormat;
    private final Getter<T, INameGroup> getUniqueNameGroup;
    private final Getter<T, Boolean> isIndexed;
    private final Getter<T, Boolean> isMovable;
    private final Getter<T, String> typeString;
    private final Getter<T, String> categoryName;
    private final Getter<T, Class<? super T>> getDomainRequiredType;
    private final Getter<T, Boolean> showInReferencingLists;
    private final Supplier<T, PropertyDefs<? super T>> getPropertyDefs;
    private final Supplier<T, Boolean> isSearchType;

    public EntryPoint(Class<T> clazz, TVEntryPoint<T> tvEntryPoint, Getter<T, Exception> canDelete, Getter<T, T> getConflict, Action<T, Boolean, Object> delete, Getter<T, Boolean> isAutoDeleteGroup, Getter<T, Boolean> isDelUndoable, Getter<T, Boolean> isVisible, Setter<T, Boolean> setVisible, Supplier<T, Composite<? extends IMerlinObj>> getRootComposite, Getter<T, Predicate<String>> getNameFormat, Getter<T, INameGenerator> getNameGenerator, Getter<T, INameGroup> getUniqueNameGroup, Getter<T, Boolean> isIndexed, Getter<T, Boolean> isMovable, Getter<T, String> typeString, Getter<T, String> categoryName, Getter<T, Class<? super T>> getDomainRequiredType, Getter<T, Boolean> showInReferencingLists, Supplier<T, PropertyDefs<? super T>> getPropertyDefs, Supplier<T, Boolean> isSearchType) {
        this.clazz = clazz;
        this.tvEntryPoint = tvEntryPoint;
        this.canDelete = canDelete;
        this.isDelUndoable = isDelUndoable;
        this.getConflict = getConflict;
        this.delete = delete;
        this.isAutoDeleteGroup = isAutoDeleteGroup;
        this.isVisible = isVisible;
        this.setVisible = setVisible;
        this.getRootComposite = getRootComposite;
        this.getNameGenerator = getNameGenerator;
        this.isIndexed = isIndexed;
        this.isMovable = isMovable;
        this.typeString = typeString;
        this.getUniqueNameGroup = getUniqueNameGroup;
        this.getNameFormat = getNameFormat;
        this.categoryName = categoryName;
        this.getDomainRequiredType = getDomainRequiredType;
        this.showInReferencingLists = showInReferencingLists;
        this.getPropertyDefs = getPropertyDefs;
        this.isSearchType = isSearchType;
    }

    public boolean isSearchType(VentusData vd) {
        return this.isSearchType.get(vd);
    }

    public PropertyDefs<? super T> getPropertyDefs(VentusData md) {
        return this.getPropertyDefs.get(md);
    }

    public void testDelete(VentusData md, T obj) throws Exception {
        Exception exp = this.canDelete.get(md, obj);
        if (exp != null) {
            throw exp;
        }
    }

    public boolean canDelete(VentusData md, T obj) {
        return this.canDelete.get(md, obj) == null;
    }

    public Exception getDeletionErr(VentusData md, T obj) {
        return this.canDelete.get(md, obj);
    }

    public boolean isDeleteUndoable(VentusData md, T obj) {
        return this.isDelUndoable.get(md, obj);
    }

    public T getConflict(VentusData md, T comparable) {
        return this.getConflict.get(md, comparable);
    }

    public boolean delete(VentusData md, T obj) {
        return this.delete.perform(md, obj, null);
    }

    public boolean isAutoDeleteGroup(VentusData md, T obj) {
        return this.isAutoDeleteGroup.get(md, obj);
    }

    public Class<? super T> getDomainRequiredType(VentusData md, T obj) {
        return this.getDomainRequiredType.get(md, obj);
    }

    public boolean isIndexed(VentusData md, T obj) {
        return this.isIndexed.get(md, obj);
    }

    public boolean isMovable(VentusData md, T obj) {
        return this.isMovable.get(md, obj);
    }

    public String getTypeString(VentusData md, T obj) {
        return this.typeString.get(md, obj);
    }

    public String getCategoryName(VentusData md, T obj) {
        return this.categoryName.get(md, obj);
    }

    public INameGroup getUniqueNameGroup(VentusData vd, T obj) {
        return this.getUniqueNameGroup.get(vd, obj);
    }

    public Predicate<String> getNameFormat(VentusData vd, T obj) {
        return this.getNameFormat.get(vd, obj);
    }

    public boolean canShowInReferencingLists(VentusData md, T obj) {
        return this.showInReferencingLists.get(md, obj);
    }

    public boolean isVisible(VentusData md, T obj) {
        return this.isVisible.get(md, obj);
    }

    public void setVisible(VentusData md, T obj, boolean visible) {
        this.setVisible.set(md, obj, visible);
    }

    public Composite<? extends IMerlinObj> getRootComposite(VentusData md) {
        return this.getRootComposite.get(md);
    }

    public INameGenerator getNameGenerator(VentusData md, T obj) {
        return this.getNameGenerator.get(md, obj);
    }

    public static interface Getter<T, ReturnT>
    extends Func<T> {
        public ReturnT get(VentusData var1, T var2);
    }

    public static interface Action<T, ReturnT, ArgT>
    extends Func<T> {
        public ReturnT perform(VentusData var1, T var2, ArgT var3);
    }

    public static interface Setter<T, ArgT>
    extends Func<T> {
        public void set(VentusData var1, T var2, ArgT var3);
    }

    public static interface Supplier<T, ReturnT>
    extends Func<T> {
        public ReturnT get(VentusData var1);
    }

    public static interface INameGroup {
        public Collection<?> getSharedNameGroupObjs(VentusData var1);
    }

    public static interface AsyncGetter<T, ReturnT>
    extends Func<T> {
        public ReturnT get(VentusData var1, T var2, Consumer<ReturnT> var3);
    }

    public static interface Func<T> {
    }
}

