/*
 * Decompiled with CFR 0.152.
 */
package ventus.treeview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import thunderheadeng.gui.IDnDTreeModel;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.SortCache;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.ChangeGroupAction;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.treeview.TVEntryPoint;
import ventus.treeview.Util;
import ventus.util.Hierarchy;

public class Model
implements IDnDTreeModel {
    private final VentusData d_data;
    private final List<TreeModelListener> d_listeners;
    private boolean d_dragging;
    private final Map<Object, SortCache<Object>> d_ixCacheMap;

    public Model(VentusData data) {
        this.d_data = data;
        this.d_listeners = new ArrayList<TreeModelListener>();
        this.d_dragging = false;
        this.d_ixCacheMap = new IdentityHashMap<Object, SortCache<Object>>();
    }

    @Override
    public void addTreeModelListener(TreeModelListener arg0) {
        this.d_listeners.add(arg0);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener arg0) {
        this.d_listeners.remove(arg0);
    }

    @Override
    public Object getRoot() {
        return this.d_data;
    }

    @Override
    public IDnDTreeModel.IDragPacket preparePacket(List<? extends TreePath> dragPaths) {
        return new DragPacket(this.d_data, dragPaths);
    }

    @Override
    public boolean isLeafDroppable(Object leaf) {
        return leaf instanceof Composite;
    }

    @Override
    public boolean canDrop(IDnDTreeModel.IDragPacket packet, Object target) {
        try {
            DragPacket pkt = (DragPacket)packet;
            return pkt.d_validChangeGroups.contains(target);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void drop(IDnDTreeModel.IDragPacket packet, final Object target, final int insertPos) {
        final DragPacket pkt = (DragPacket)packet;
        AMerlinOp op = new AMerlinOp(this){

            @Override
            public void run(VentusApp app, VentusData md) {
                try (VentusData.WriteLock lock = md.lockWrite();){
                    Undo.begin(Intl.intl("Reorder"));
                    ChangeGroupAction.move(md, pkt.d_objs, (Composite)target, insertPos);
                    Undo.end(md);
                }
            }
        };
        UIHook.run(null, "ventus.treeview.Model.drop", op, 0);
    }

    @Override
    public void drop(IDnDTreeModel.IDragPacket selPaths, Object target) {
        this.drop(selPaths, target, 0);
    }

    @Override
    public boolean isDragging() {
        return this.d_dragging;
    }

    @Override
    public void setDragging(boolean dragging) {
        this.d_dragging = dragging;
    }

    private void invalidateAllChildCaches() {
        this.d_ixCacheMap.clear();
    }

    private void invalidateChildCaches(Object ... parents) {
        this.invalidateChildCaches(Arrays.asList(parents));
    }

    private void invalidateChildCaches(Collection<?> parents) {
        for (Object parent : parents) {
            this.d_ixCacheMap.remove(parent);
        }
    }

    private SortCache<Object> getChildCache(Object parent) {
        SortCache childCache = this.d_ixCacheMap.computeIfAbsent(parent, p -> new SortCache(this.getChildren(p)));
        return childCache;
    }

    @Override
    public boolean isLeaf(Object obj) {
        TVEntryPoint<Object> ep = Util.getEP(obj);
        return ep == null || ep.isLeaf(this.d_data, (IMerlinObj)obj);
    }

    @Override
    public int getChildCount(Object parent) {
        SortCache<Object> ixCache = this.getChildCache(parent);
        if (ixCache == null) {
            return 0;
        }
        return ixCache.size();
    }

    @Override
    public Object getChild(Object parent, int index) {
        SortCache<Object> ixCache = this.getChildCache(parent);
        assert (ixCache != null);
        assert (ixCache.size() > index);
        return ixCache.get(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        SortCache<Object> ixCache = this.getChildCache(parent);
        assert (ixCache != null);
        return ixCache.indexOf(child);
    }

    @Override
    public void valueForPathChanged(final TreePath path, final Object newVal) {
        AMerlinOp op = new AMerlinOp(this){

            @Override
            public void run(VentusApp app, VentusData md) {
                try (VentusData.WriteLock lock = md.lockWrite();){
                    Object obj = path.getLastPathComponent();
                    TVEntryPoint<Object> ep = Util.getEP(obj);
                    if (ep != null) {
                        String newName = ((String)newVal).trim();
                        if (newName.length() == 0) {
                            return;
                        }
                        ep.setName(md, (IMerlinObj)obj, newName);
                    }
                }
            }
        };
        UIHook.run(null, "ventus.treeview.Model.valueForPathChanged", op, 0);
    }

    protected void fireTreeStructureChanged(TreeModelEvent evt) {
        for (TreeModelListener listener : this.d_listeners) {
            listener.treeStructureChanged(evt);
        }
    }

    protected void fireTreeNodesChanged(TreeModelEvent evt) {
        for (TreeModelListener listener : this.d_listeners) {
            listener.treeNodesChanged(evt);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent evt) {
        for (TreeModelListener listener : this.d_listeners) {
            listener.treeNodesInserted(evt);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent evt) {
        for (TreeModelListener listener : this.d_listeners) {
            listener.treeNodesRemoved(evt);
        }
    }

    private Function<Object, Object> getParentMapper() {
        return obj -> {
            TVEntryPoint<Object> ep = Util.getEP(obj);
            return ep == null ? null : ep.getParent(this.d_data, obj);
        };
    }

    public TreePath getPath(Object obj) {
        Object[] path = Hierarchy.getPath(obj, this.getParentMapper());
        TreePath treePath = new TreePath(path);
        return treePath;
    }

    public TreePath[] getPaths(Collection<?> objs) {
        TreePath[] paths = new TreePath[objs.size()];
        int m = 0;
        for (Object o : objs) {
            paths[m++] = this.getPath(o);
        }
        return paths;
    }

    public void update(Events events) {
        for (EventChannel<IMerlinObj> channel : events.getAffectedChannels(IMerlinObj.class, new Class[0])) {
            this.invalidateChildCaches(channel.getChangedObjs(VentusData.CHILD_ADDED, VentusData.CHILD_REMOVED, VentusData.CHILDREN_CHANGED));
        }
        LinkedIdentityHashSet structuresChanged = new LinkedIdentityHashSet();
        LinkedIdentityHashSet nodesChanged = new LinkedIdentityHashSet();
        Set<IMerlinObj> addedObjs = new LinkedIdentityHashSet<IMerlinObj>();
        for (EventChannel<IMerlinObj> channel : events.getAffectedChannels(IMerlinObj.class, new Class[0])) {
            structuresChanged.addAll(channel.getChangedObjs(VentusData.CHILDREN_CHANGED, VentusData.CHILD_REMOVED));
            addedObjs.addAll(channel.getAddedObjs());
            addedObjs.addAll(channel.getChangedObjs(VentusData.PARENT_CHANGED));
            Set changedObjs = channel.getChangedNotOfType(VentusData.SELECTION_CHANGED, VentusData.PARENT_CHANGED);
            nodesChanged.addAll(changedObjs);
        }
        Iterator<Object> it = structuresChanged.iterator();
        block2: while (it.hasNext()) {
            Object obj = it.next();
            while (obj != null) {
                if ((obj = this.d_data.hierarchy.getParent(obj)) == null || !structuresChanged.contains(obj)) continue;
                it.remove();
                continue block2;
            }
        }
        addedObjs = this.pruneToHighestParents(addedObjs);
        for (TreeModelEvent evt : this.toInsertionTreeEvents(addedObjs)) {
            this.fireTreeNodesInserted(evt);
        }
        for (Object obj : structuresChanged) {
            TreePath path = this.getPath(obj);
            if (path == null) continue;
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, path));
        }
        List<TreeModelEvent> changeEvents = this.toGeneralTreeEvents(nodesChanged, true);
        for (TreeModelEvent changeEvent : changeEvents) {
            this.fireTreeNodesChanged(changeEvent);
        }
    }

    public void fireDecorationChanged(Collection<?> objs) {
        List<TreeModelEvent> changeEvents = this.toGeneralTreeEvents(objs, false);
        for (TreeModelEvent changeEvent : changeEvents) {
            this.fireTreeNodesChanged(changeEvent);
        }
    }

    private Set<IMerlinObj> pruneToHighestParents(Set<IMerlinObj> objs) {
        LinkedIdentityHashSet<IMerlinObj> result = new LinkedIdentityHashSet<IMerlinObj>(objs.size());
        for (IMerlinObj obj : objs) {
            Object parent = this.getParent(obj);
            if (objs.contains(parent)) continue;
            result.add(obj);
        }
        return result;
    }

    private Set<Object> getParents(Collection<?> objs) {
        return Hierarchy.getParents(objs, this.getParentMapper());
    }

    private <E> List<TreeModelEvent> toGeneralTreeEvents(Collection<E> objs, boolean shouldBeValid) {
        Map<Object, Set<E>> parentChildMap = this.getParentChildMap(objs);
        return this.toGeneralTreeEvents(parentChildMap, shouldBeValid);
    }

    private <E> List<TreeModelEvent> toGeneralTreeEvents(Map<?, Set<E>> parentChildMap, boolean shouldBeValid) {
        ArrayList<TreeModelEvent> events = new ArrayList<TreeModelEvent>(parentChildMap.size());
        for (Map.Entry<?, Set<E>> entry : parentChildMap.entrySet()) {
            Object parent = entry.getKey();
            Set<E> children = entry.getValue();
            TreePath parentPath = this.getPath(parent);
            int[] childIxes = new int[children.size()];
            Object[] childArr = new Object[children.size()];
            int nIxes = 0;
            for (E child : children) {
                int cix = this.getIndexOfChild(parent, child);
                if (cix >= 0) {
                    childIxes[nIxes] = cix;
                    childArr[nIxes] = child;
                    ++nIxes;
                    continue;
                }
                if (!shouldBeValid) continue;
                System.out.printf("parent=%s, child=%s%n", parent, child);
                assert (false) : "tree event for object that is not in the tree, check a getChildren() method";
            }
            if (nIxes == 0) continue;
            if (nIxes < children.size()) {
                childIxes = Arrays.copyOf(childIxes, nIxes);
                childArr = Arrays.copyOf(childArr, nIxes);
            }
            events.add(new TreeModelEvent((Object)this, parentPath, childIxes, childArr));
        }
        return events;
    }

    private <C, E> List<TreeModelEvent> toInsertionTreeEvents(Set<E> objs) {
        return this.toAddRemoveTreeEvents(this.getParentChildMap(objs), true);
    }

    private <C, E> List<TreeModelEvent> toRemovalTreeEvents(Set<E> objs) {
        return this.toAddRemoveTreeEvents(this.getParentChildMap(objs), false);
    }

    private <E> List<TreeModelEvent> toAddRemoveTreeEvents(Map<?, Set<E>> parentChildMap, boolean ascending) {
        ArrayList<TreeModelEvent> events = new ArrayList<TreeModelEvent>(parentChildMap.size());
        for (Map.Entry<?, Set<E>> entry : parentChildMap.entrySet()) {
            Object parent = entry.getKey();
            Set<E> childSet = entry.getValue();
            TreePath parentPath = this.getPath(parent);
            NavigableMap indexChildMap = new TreeMap<Integer, E>();
            for (E child : childSet) {
                indexChildMap.put(this.getIndexOfChild(parent, child), child);
            }
            if (!ascending) {
                indexChildMap = indexChildMap.descendingMap();
            }
            int[] childIxes = theUtil.toIntArray(indexChildMap.keySet());
            Object[] children = indexChildMap.values().toArray();
            events.add(new TreeModelEvent((Object)this, parentPath, childIxes, children));
        }
        return events;
    }

    private Object getParent(Object obj) {
        return this.getParentMapper().apply(obj);
    }

    private Collection<?> getChildren(Object obj) {
        TVEntryPoint<Object> ep = Util.getEP(obj);
        return ep == null ? Collections.EMPTY_LIST : ep.getChildren(this.d_data, obj);
    }

    private <E> Map<Object, Set<E>> getParentChildMap(Collection<E> objs) {
        LinkedIdentityHashMap<Object, Set<E>> map = new LinkedIdentityHashMap<Object, Set<E>>();
        for (E obj : objs) {
            Object parent = this.getParent(obj);
            if (parent == null) continue;
            LinkedIdentityHashSet children = (LinkedIdentityHashSet)map.get(parent);
            if (children == null) {
                children = new LinkedIdentityHashSet();
                map.put(parent, children);
            }
            children.add(obj);
        }
        return map;
    }

    private static class DragPacket
    extends IDnDTreeModel.DefaultDragPacket {
        private final Set<IMerlinObj> d_objs = new LinkedIdentityHashSet<IMerlinObj>();
        private final Set<Composite<?>> d_validChangeGroups;

        public DragPacket(VentusData md, List<? extends TreePath> dragPaths) {
            super(dragPaths);
            for (TreePath treePath : dragPaths) {
                this.d_objs.add((IMerlinObj)treePath.getLastPathComponent());
            }
            this.d_validChangeGroups = ChangeGroupAction.getValidChangeGroups(md, this.d_objs);
        }
    }
}

