/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.mv.tools.RoomToolUtil;

public class RoomSnapConstraint
implements ISnapConstraint {
    public final VentusData md;
    public final ISnapConstraint backupConstraint;
    public final Predicate<IsectInfo> snapFilter;
    public final BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> roomFilter;

    public RoomSnapConstraint(VentusData md, ISnapConstraint backupConstraint, BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> roomFilter) {
        this(md, backupConstraint, roomFilter, isect -> isect.searchType.fromFace && isect.getFaceNormal != null && isect.getFaceNormal.get().lengthSquared() > 0.0);
    }

    public RoomSnapConstraint(VentusData md, ISnapConstraint backupConstraint, BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> roomFilter, Predicate<IsectInfo> snapFilter) {
        this.md = md;
        this.backupConstraint = backupConstraint;
        this.snapFilter = snapFilter;
        this.roomFilter = roomFilter;
    }

    @Override
    public Pair<Point3d, Collection<IsectInfo>> snapRay(Runnable validateProgress, Vector3d viewDir, Point3d rayBegin, Vector3d rayDir) {
        try (VentusData.ReadLock lock = this.md.lockRead();){
            Collection<IsectInfo> iis = this.findRoomIsects(validateProgress, rayBegin, rayDir);
            if (iis.isEmpty()) {
                Pair<Point3d, Collection<IsectInfo>> pair = this.backupConstraint != null ? this.backupConstraint.snapRay(validateProgress, viewDir, rayBegin, rayDir) : null;
                return pair;
            }
            Point3d rayPoint = iis.iterator().next().isectPoint;
            Pair<Point3d, Collection<IsectInfo>> pair = new Pair<Point3d, Collection<IsectInfo>>(rayPoint, iis);
            return pair;
        }
    }

    @Override
    public Collection<IsectInfo> snapPoint(Runnable validateProgress, Point3d p) {
        try (VentusData.ReadLock lock = this.md.lockRead();){
            Collection<IsectInfo> isects = this.findRoomIsects(validateProgress, p, GeomConstants.VEC3D_ZNEG);
            if (!isects.isEmpty()) {
                Collection<IsectInfo> collection = isects;
                return collection;
            }
            List<IsectInfo> list = this.backupConstraint != null ? this.backupConstraint.snapPoint(validateProgress, p) : Collections.emptyList();
            return list;
        }
    }

    @Override
    public Collection<IsectInfo> snapPoint(Runnable validateProgress, Collection<IsectInfo> snaps, Vector3d projectionDir) {
        try (VentusData.ReadLock lock = this.md.lockRead();){
            if (snaps.isEmpty()) {
                Collection<IsectInfo> collection = snaps;
                return collection;
            }
            IsectInfo first = snaps.iterator().next();
            Collection<IsectInfo> roomSnaps = theUtil.preFilter(snaps, IsectInfo.class, snap -> {
                validateProgress.run();
                return (first.prox == null || snap.prox == null || theUtil.le(snap.prox.getZDist(), first.prox.getZDist(), 1.0E-6)) && snap.obj instanceof ISchematicRoom && this.roomFilter.test((ISchematicRoom)snap.obj, snap.elements.getElement(ISchematicRoom.COMPONENT_ELEMENT).orElse(null)) && this.snapFilter.test((IsectInfo)snap);
            });
            if (!roomSnaps.isEmpty()) {
                Collection<IsectInfo> collection = roomSnaps;
                return collection;
            }
            Vector3d searchDir = projectionDir != null ? projectionDir : GeomConstants.VEC3D_ZNEG;
            Collection<IsectInfo> roomIsects = this.findRoomIsects(validateProgress, snaps.iterator().next().isectPoint, searchDir);
            if (!roomIsects.isEmpty()) {
                Collection<IsectInfo> collection = roomIsects;
                return collection;
            }
            if (this.backupConstraint != null) {
                roomIsects = this.backupConstraint.snapPoint(validateProgress, snaps, projectionDir);
                if (!roomIsects.isEmpty()) {
                    Collection<IsectInfo> collection = roomIsects;
                    return collection;
                }
                Collection<IsectInfo> collection = snaps;
                return collection;
            }
            List<IsectInfo> list = Collections.emptyList();
            return list;
        }
    }

    private Collection<IsectInfo> findRoomIsects(Runnable validateProgress, Point3d rayBegin, Vector3d rayDir) {
        return theUtil.filter(RoomToolUtil.findRoomIsects(this.md, validateProgress, rayBegin, rayDir, this.roomFilter), this.snapFilter);
    }

    @Override
    public ISnapConstraint transform(Matrix4d xform) {
        return this;
    }
}

