/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.tools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import ventus.builders.PlanarGeomBuilder;
import ventus.geom.Geometry;
import ventus.mv.ModelView;
import ventus.mv.tools.VentusTool;

public abstract class NewPlanarGeomTool<T extends PlanarGeomBuilder>
extends VentusTool<T> {
    public NewPlanarGeomTool(ModelView mv, Func<? extends T, ? extends NewPlanarGeomTool<T>> func) {
        super(mv, func);
        this.setSnapInfo(SnapMode.FILTERED_ONE_PASS, new DefaultFilter());
    }

    @Override
    public boolean cancel() {
        ((PlanarGeomBuilder)this.props()).cancel();
        return super.cancel();
    }

    protected Point3d getLoc(Point2d p2d) {
        if (p2d == null) {
            return null;
        }
        return new Point3d(p2d.x, p2d.y, ((PlanarGeomBuilder)this.props()).getZLoc().getValue(Geometry.LENGTH_UNIT));
    }

    protected Point3d getAddLoc() {
        return this.getP1().getFinalSnapLocation();
    }

    protected Point2d getPlanarAddLoc() {
        Point3d loc = this.getAddLoc();
        if (loc == null) {
            return null;
        }
        return new Point2d(loc.x, loc.y);
    }

    protected abstract String getShapeName();

    @Override
    protected String getStatusMessage() {
        return this.getShapeName() + ": " + this.toString(this.getAddLoc());
    }

    protected static class Func<PropT extends PlanarGeomBuilder, ToolT extends NewPlanarGeomTool<PropT>>
    extends AToolFunction<ToolT> {
        protected Func() {
        }

        @Override
        public Cursor getCursor(ToolT tool) {
            return null;
        }

        @Override
        public ISnapConstraint getSnapConstraint(ToolT tool) {
            double z = ((PlanarGeomBuilder)((VentusTool)tool).props()).getZLoc().getValue(Geometry.LENGTH_UNIT);
            Plane3d plane = new Plane3d(0.0, 0.0, 1.0, -z);
            return new PlanarConstraint(plane);
        }

        @Override
        public void mousePressed(ToolT tool, MouseEvent e) {
        }

        @Override
        public void mouseReleased(ToolT tool, MouseEvent e) {
        }

        @Override
        public void mouseMoved(ToolT tool, MouseEvent e) {
        }

        @Override
        public void mouseDragged(ToolT tool, MouseEvent e) {
            ((CursorTool)tool).mouseMoved(e);
        }
    }
}

