/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.tools;

import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.jscience.physics.units.Unit;
import thunderheadeng.scene3d.tools.AdvancedTool;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.units.IUnitSrc;
import ventus.VentusApp;
import ventus.actions.Shortcut;
import ventus.actions.VentusShortcuts;
import ventus.data.VentusData;
import ventus.geom.Geometry;
import ventus.unitsystem.UnitSystem;

public class MerlinToolHooks
implements AdvancedTool.IAppHook {
    private final VentusData d_data;

    public MerlinToolHooks(VentusData md) {
        this.d_data = md;
    }

    @Override
    public void init(AdvancedTool tool) {
    }

    @Override
    public boolean isToolUndoEvent(AdvancedTool tool, KeyEvent evt, MouseHistory mouseHistory) {
        return MerlinToolHooks.isShortcutEvent(VentusShortcuts.UNDO, evt, mouseHistory);
    }

    @Override
    public boolean isToolRedoEvent(AdvancedTool tool, KeyEvent evt, MouseHistory mouseHistory) {
        return MerlinToolHooks.isShortcutEvent(VentusShortcuts.REDO, evt, mouseHistory);
    }

    private static boolean isShortcutEvent(Shortcut sc, KeyEvent evt, MouseHistory ms) {
        if (VentusApp.getApp() == null) {
            return false;
        }
        KeyStroke ks = VentusApp.getApp().getHotkeys().getUiHelper().getKeyStrokeForID(sc.getKey());
        KeyStroke ksEv = KeyStroke.getKeyStrokeForEvent(evt);
        return ks != null && ks.equals(ksEv) && ms.isRedoAvailable();
    }

    @Override
    public double getWorkingZLocation(AdvancedTool tool) {
        return this.d_data.activeFloor().getWorkingZ().get(this.getNativeLengthUnit());
    }

    @Override
    public Unit getNativeLengthUnit() {
        return Geometry.LENGTH_UNIT;
    }

    @Override
    public IUnitSrc getLengthUnitSrc() {
        return UnitSystem.getType(0, true);
    }

    @Override
    public Unit getNativeAngleUnit() {
        return Geometry.ANGLE_UNIT;
    }
}

