/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitPoint3D;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.manip.TranslateManip;
import ventus.mv.gui.ATransformPanel;
import ventus.mv.gui.LocationPanel;

public class TranslatePanel
extends ATransformPanel<TranslateManip> {
    private static final long serialVersionUID = 5852514131150857287L;
    private final MoveVecPanel d_moveVecPanel = new MoveVecPanel();

    public TranslatePanel(VentusData data) {
        super(data, Integer.MAX_VALUE);
        this.addSeparator();
        this.addSection(this.d_moveVecPanel);
        this.addCompletionPanel();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                TranslatePanel.this.d_moveVecPanel.updateToProps((TranslateManip)TranslatePanel.this.d_moveVecPanel.props());
            }
        });
    }

    @Override
    protected String getXformName() {
        return Intl.intl("Move");
    }

    private static class MoveVecPanel
    extends LocationPanel<TranslateManip> {
        private static final long serialVersionUID = -5114545946641091222L;

        public MoveVecPanel() {
            super(Intl.intl("Move X"), Intl.intl("Move Y"), Intl.intl("Move Z"), TranslateManip.TRANSFORM_CHANGED, TranslateManip.CANCELLED, TranslateManip.OBJS_TRANSFORMED);
        }

        @Override
        protected void updateFromProps(TranslateManip props) {
            UnitPoint3D moveVec = props.getMoveVec();
            if (moveVec != null) {
                this.setValue(moveVec);
            } else {
                this.setValue(new UnitPoint3D(0.0, 0.0, 0.0, SI.METER));
            }
        }

        @Override
        protected void updateToProps(TranslateManip props) {
            props.setMoveVec(this.getValue());
        }
    }
}

