/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextArea;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.gui.guiValueField;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.SemaphoreLock;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CompElementActions;
import ventus.actions.MerlinOpImpl;
import ventus.actions.RenameAction;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.Visibility;
import ventus.data.CompositePropertyUtil;
import ventus.data.IMerlinObj;
import ventus.data.INamed;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.material.Material;
import ventus.data.value.IFunction1d;
import ventus.data.value.IVariant;
import ventus.data.value.Schedule;
import ventus.gui.MaterialBtn;
import ventus.gui.MerlinComboBox;
import ventus.gui.guiUtil;
import ventus.gui.value.IVariantEditor;
import ventus.gui.value.ScheduleField;
import ventus.mv.gui.SelectionEditorPanel;
import ventus.unitsystem.UnitSystem;

public class PropConnections {
    public static void runCommitOp(Class invokingClass, String methodName, boolean isModified, Semaphore optLock, BiConsumer<VentusApp, VentusData> task) {
        if (!isModified) {
            return;
        }
        SemaphoreLock.whileHeld(optLock, () -> {
            MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                try (VentusData.WriteLock lock = md.lockWrite();){
                    task.accept((VentusApp)app, (VentusData)md);
                }
            });
            UIHook.run((Component)VentusApp.getApp().getActiveFrame(), String.format("%s.%s", invokingClass.getName(), methodName), op, 20);
        });
    }

    public static <ObjT extends IMerlinObj, PropT> void setPropRecursive(String actionName, CompElementActions.IObjectProp<ObjT, PropT> prop, Collection<? extends ObjT> objs, PropT newVal) {
        Undo.begin(actionName);
        VentusData md = VentusApp.getApp().getData();
        prop.set(md, objs, newVal);
        Undo.end(VentusApp.getApp().getData());
    }

    public static class BoolRadioPropConn
    extends ASinglePropConnection<guiRadioButton, CompElementActions.IObjectProp<IMerlinObj, Boolean>> {
        private final boolean d_valueWhenSelected;

        public BoolRadioPropConn(TypedProp<Boolean> prop, guiRadioButton control, boolean valueWhenSelected) {
            super(new CompElementActions.DefProp(prop), control);
            this.d_valueWhenSelected = valueWhenSelected;
            control.addItemListener(this);
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, guiRadioButton comp) {
            if (objs.isEmpty()) {
                return;
            }
            if (!comp.isSelected()) {
                return;
            }
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Wind Pressure"), prop, objs, Boolean.valueOf(this.d_valueWhenSelected));
            comp.setModified(false);
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, guiRadioButton comp) {
            ButtonGroup group;
            if (objs.isEmpty()) {
                return;
            }
            PropValue<Boolean> value = prop.get(VentusApp.getAppData(), objs);
            if (!value.isUniform() && (group = comp.getModel().getGroup()) != null) {
                group.clearSelection();
            }
            comp.setSelected(value.map(b -> b == this.d_valueWhenSelected).orElse(false));
            comp.setModified(false);
        }
    }

    public static class ColorConn
    extends ASinglePropConnection<ColorButton, CompElementActions.IObjectProp<IMerlinObj, Color>>
    implements Observer {
        public ColorConn(ColorButton cb) {
            this(cb, (TypedProp<Color>)VentusData.COLOR);
        }

        public ColorConn(ColorButton cb, TypedProp<Color> prop) {
            super(new CompElementActions.DefProp(prop), cb);
            cb.addObserver(this);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, Color> prop, Collection<? extends IMerlinObj> objs, ColorButton comp) {
            PropValue<Color> val = prop.get(VentusApp.getApp().getData(), objs);
            if (val.isUniform()) {
                if (val.get() == null) {
                    comp.setColor(Color.WHITE);
                } else {
                    comp.setColor(val.get());
                }
            } else {
                comp.setColor(null);
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, Color> prop, Collection<? extends IMerlinObj> objs, ColorButton comp) {
            Color color = comp.getColor();
            if (color != null) {
                PropConnections.setPropRecursive(Intl.intl("Set Color"), prop, objs, color);
            }
        }
    }

    public static class ScheduleProp
    extends ASinglePropConnection<ScheduleField, CompElementActions.IObjectProp<IMerlinObj, Schedule>> {
        private final ScheduleField d_varEditor;
        private boolean d_modified;

        public ScheduleProp(CompElementActions.IObjectProp<IMerlinObj, Schedule> prop, ScheduleField varEditor) {
            super(prop, varEditor);
            this.d_varEditor = varEditor;
            this.d_modified = false;
            varEditor.addPropertyChangeListener("value", e -> {
                this.d_modified = true;
                this.onControlChanged();
                this.initFromProp();
            });
        }

        @Override
        protected boolean isModified(ScheduleField comp) {
            return this.d_modified;
        }

        @Override
        protected void setModified(ScheduleField comp, boolean modified) {
            this.d_modified = modified;
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, Schedule> prop, Collection<? extends IMerlinObj> objs, ScheduleField comp) {
            SelectionEditorPanel.setPropRecursive(String.format(Intl.intl("Edit %s"), this.d_varEditor.getPropName()), prop, objs, this.d_varEditor.getValue());
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, Schedule> prop, Collection<? extends IMerlinObj> objs, ScheduleField comp) {
            PropValue<Schedule> value = prop.get(VentusApp.getAppData(), objs);
            Schedule d_currVal = value.orElse(null);
            this.d_varEditor.setValue(d_currVal);
            this.setModified(comp, false);
        }
    }

    public static class VariantProp<ValType>
    extends ASinglePropConnection<HTMLBtn, CompElementActions.IObjectProp<IMerlinObj, IVariant<ValType>>> {
        private final String d_propDesc;
        private final IVariantEditor<ValType> d_varEditor;
        private IVariant<ValType> d_currVal;
        private boolean d_modified;

        public VariantProp(String propDesc, CompElementActions.IObjectProp<IMerlinObj, IVariant<ValType>> prop, HTMLBtn btn, IVariantEditor<ValType> varEditor) {
            super(prop, btn);
            this.d_varEditor = varEditor;
            this.d_propDesc = propDesc;
            this.d_modified = false;
            btn.addActionListener(e -> this.edit(prop));
        }

        private void edit(CompElementActions.IObjectProp<IMerlinObj, IVariant<ValType>> prop) {
            IVariant<ValType> newVal;
            guiPanel editorPnl = this.d_varEditor.getEditorPanel(UnitSystem.getType(1, true));
            this.d_varEditor.load(editorPnl, this.d_currVal);
            JFrame parent = Application.getApp() != null ? Application.getApp().getActiveFrame() : null;
            String title = String.format(Intl.intl("Edit %s"), this.d_propDesc);
            guiDialog dlg = new guiDialog((Window)parent, title, 9);
            guiPanel c = dlg.getDialogPane();
            c.setLayout(new BorderLayout());
            c.add((Component)editorPnl, "Center");
            if (dlg.doModal() == 1 && dlg.isModified() && (newVal = this.d_varEditor.save(editorPnl)) != null && !Objects.equals(this.d_currVal, newVal)) {
                this.d_modified = true;
                this.d_currVal = newVal;
                this.onControlChanged();
                this.initFromProp();
            }
        }

        @Override
        protected boolean isModified(HTMLBtn comp) {
            return this.d_modified;
        }

        @Override
        protected void setModified(HTMLBtn comp, boolean modified) {
            this.d_modified = modified;
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, IVariant<ValType>> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            SelectionEditorPanel.setPropRecursive(String.format(Intl.intl("Edit %s"), this.d_propDesc), prop, objs, this.d_currVal);
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, IVariant<ValType>> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            PropValue<IVariant<ValType>> value = prop.get(VentusApp.getApp().getData(), objs);
            this.d_currVal = value.orElse(null);
            if (this.d_currVal != null) {
                comp.setText(this.d_varEditor.describe(this.d_currVal));
            } else {
                comp.setText("&lt;" + Intl.intl("varies") + "&gt;");
            }
            this.setModified(comp, false);
        }
    }

    public static class ValEditorConn<T, CompT extends JComponent>
    extends ASinglePropConnection<JComponent, CompElementActions.IObjectProp<IMerlinObj, IFunction1d>>
    implements Observer {
        private final IValEditor<T> d_editor;

        public ValEditorConn(CompElementActions.IObjectProp<IMerlinObj, IFunction1d> prop, IValEditor<T> editor) {
            super(prop, editor.getComponent());
            this.d_editor = editor;
            VentusApp.getApp().getData().getEvents().addObserver(this);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, IFunction1d> prop, Collection<? extends IMerlinObj> objs, JComponent comp) {
            PropValue<IFunction1d> obj = prop.get(VentusApp.getApp().getData(), objs);
            Class type = this.d_editor.getType();
            this.d_editor.setValue(obj.map(func -> type.isInstance(func) ? type.cast(func) : null).orElse(null));
            if (comp instanceof Modifiable) {
                ((Modifiable)((Object)comp)).setModified(false);
            }
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, IFunction1d> prop, Collection<? extends IMerlinObj> objs, Object val) {
            if (val != null) {
                SelectionEditorPanel.setPropRecursive(Intl.intl("Edit Property"), prop, objs, val);
            }
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, IFunction1d> prop, Collection<? extends IMerlinObj> objs, JComponent comp) {
            this.setProp(prop, objs, this.d_editor.getValue());
        }
    }

    public static class BoolPropConnection
    extends ASinglePropConnection<guiMultiStateCheckBox, CompElementActions.IObjectProp<IMerlinObj, Boolean>> {
        public BoolPropConnection(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, guiMultiStateCheckBox control) {
            super(prop, control);
            control.addItemListener(this);
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, guiMultiStateCheckBox comp) {
            if (comp.getState() != 2) {
                Boolean newval = comp.isSelected() ? Boolean.TRUE : Boolean.FALSE;
                this.apply(prop, objs, newval);
            }
        }

        public void apply(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, Boolean val) {
            PropConnections.setPropRecursive(Intl.intl("Set Property"), prop, objs, val);
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, guiMultiStateCheckBox comp) {
            PropValue<Boolean> val = prop.get(VentusApp.getApp().getData(), objs);
            if (val.isUniform()) {
                comp.setMode(0);
                Boolean b = val.get();
                comp.setSelected(b);
            } else {
                comp.setMode(1);
                comp.setState(2);
                ItemEvent evt = new ItemEvent(comp.getModel(), 2000, comp.getModel(), 2);
                for (ItemListener il : comp.getItemListeners()) {
                    il.itemStateChanged(evt);
                }
            }
            comp.setModified(false);
        }
    }

    public static class VisPropConnection
    extends BoolPropConnection {
        public VisPropConnection(guiMultiStateCheckBox control) {
            super((CompElementActions.IObjectProp<IMerlinObj, Boolean>)new CompElementActions.DefProp<IMerlinObj, Boolean>(VentusData.VISIBILITY){

                @Override
                public void set(VentusData md, Collection<? extends IMerlinObj> objs, Boolean newVal) {
                    Collection<Object> toShow = Collections.EMPTY_LIST;
                    Collection<Object> toHide = Collections.EMPTY_LIST;
                    if (newVal.booleanValue()) {
                        toShow = objs;
                    } else {
                        toHide = objs;
                    }
                    Visibility.setVisibility(VentusApp.getApp().getData(), toShow, toHide, true);
                }
            }, control);
        }
    }

    public static class MaterialConn
    extends ASinglePropConnection<MaterialBtn, CompElementActions.IObjectProp<IMerlinObj, IMaterial[]>>
    implements IObserver {
        public MaterialConn(MaterialBtn btn) {
            super(new CompElementActions.DefProp(VentusData.MATERIAL), btn);
            btn.addObserver(this, true);
        }

        @Override
        public void update(IObservable source, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, IMaterial[]> prop, Collection<? extends IMerlinObj> objs, MaterialBtn comp) {
            Material mat = (Material)comp.getMaterial();
            PropConnections.setPropRecursive(Intl.intl("Set Material"), prop, objs, new IMaterial[]{mat});
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, IMaterial[]> prop, Collection<? extends IMerlinObj> objs, MaterialBtn comp) {
            PropValue<IMaterial[]> val = prop.get(VentusApp.getApp().getData(), objs);
            PropValue<Material> uniformMat = val.filter(theUtil::isUniform, PropValue.nonUniform()).flatMap(mats -> PropValue.of(mats[0])).filter(m -> m == null || m instanceof Material, PropValue.nonUniform()).map(m -> (Material)m);
            if (uniformMat.isPresent()) {
                comp.setMaterial(uniformMat.get());
            } else {
                comp.setMultiple();
            }
            comp.setModified(false);
        }
    }

    public static class IntPropConn
    extends NumberPropConn<Integer> {
        public IntPropConn(CompElementActions.IObjectProp<IMerlinObj, Integer> prop, guiIntField control) {
            super(prop, control, Integer.class);
        }
    }

    public static class DoublePropConn
    extends NumberPropConn<Double> {
        public DoublePropConn(CompElementActions.IObjectProp<IMerlinObj, Double> prop, guiDoubleField control) {
            super(prop, control, Double.class);
        }
    }

    public static class UDPropConnection
    extends NumberPropConn<UnitDouble> {
        public UDPropConnection(CompElementActions.IObjectProp<IMerlinObj, UnitDouble> prop, guiUnitDoubleField control) {
            super(prop, control, UnitDouble.class);
        }
    }

    public static class DToUDProp<ObjT>
    implements CompElementActions.IObjectProp<ObjT, UnitDouble> {
        private final Unit d_storageUnit;
        private final CompElementActions.IObjectProp<ObjT, Double> d_dProp;

        public DToUDProp(Unit storageUnit, CompElementActions.IObjectProp<ObjT, Double> dProp) {
            this.d_storageUnit = storageUnit;
            this.d_dProp = dProp;
        }

        @Override
        public PropValue<UnitDouble> get(VentusData md, Collection<? extends ObjT> objs) {
            return this.d_dProp.get(md, objs).map(v -> new UnitDouble((double)v, this.d_storageUnit));
        }

        @Override
        public void set(VentusData md, Collection<? extends ObjT> objs, UnitDouble newVal) {
            this.d_dProp.set(md, objs, newVal.getValue(this.d_storageUnit));
        }
    }

    public static class NumberPropConn<NT>
    extends ASinglePropConnection<guiValueField<NT>, CompElementActions.IObjectProp<IMerlinObj, NT>> {
        private final Class<NT> d_type;

        public NumberPropConn(CompElementActions.IObjectProp<IMerlinObj, NT> prop, guiValueField<NT> control, Class<NT> type) {
            super(prop, control);
            this.d_type = type;
            control.setEmptyAllowed(true);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, NT> prop, Collection<? extends IMerlinObj> objs, guiValueField<NT> comp) {
            PropValue<NT> val = prop.get(VentusApp.getApp().getData(), objs);
            this.initFromVal(val, comp);
        }

        public void initFromVal(PropValue<NT> val, guiValueField<NT> comp) {
            if (val.isUniform()) {
                comp.setValue(val.get());
            } else {
                comp.setValue(null);
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, NT> prop, Collection<? extends IMerlinObj> objs, guiValueField<NT> comp) {
            if (comp.validateData(false, true)) {
                if (comp.getValue() != null) {
                    this.apply(prop, objs, comp.getValue());
                    this.initFromProp(prop, objs, comp);
                }
            } else {
                comp.setValue(comp.getValue());
            }
            comp.selectAll();
        }

        protected void apply(CompElementActions.IObjectProp<IMerlinObj, NT> prop, Collection<? extends IMerlinObj> objs, NT val) {
            PropConnections.setPropRecursive(Intl.intl("Set Property"), prop, objs, val);
        }
    }

    public static class ComboPropConn<T>
    extends ASinglePropConnection<guiComboBox<T>, CompElementActions.IObjectProp<IMerlinObj, T>> {
        private final String d_actionName;

        public ComboPropConn(CompElementActions.IObjectProp<IMerlinObj, T> prop, guiComboBox<T> control) {
            this(Intl.intl("Set Property"), prop, control);
        }

        public ComboPropConn(String actionName, CompElementActions.IObjectProp<IMerlinObj, T> prop, guiComboBox<T> control) {
            super(prop, control);
            this.d_actionName = actionName;
            control.addItemListener(this);
            if (control instanceof MerlinComboBox) {
                this.setUpdateLock(((MerlinComboBox)control).getUpdateLock());
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (this.isLocked()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.onControlChanged();
                    }
                });
            }
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, T> prop, Collection<? extends IMerlinObj> objs, guiComboBox<T> comp) {
            IListenerStripper ls = guiUtil.stripListeners(comp);
            PropValue<T> val = prop.get(VentusApp.getApp().getData(), objs);
            if (val.isEmpty()) {
                comp.setSelectedItem(null);
            } else {
                comp.setSelectedItem(val.get());
            }
            comp.setModified(false);
            ls.restore();
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, T> prop, Collection<? extends IMerlinObj> objs, guiComboBox<T> comp) {
            if (!comp.isEditable() && comp.getSelectedIndex() < 0) {
                return;
            }
            PropConnections.setPropRecursive(this.d_actionName, prop, objs, comp.getSelectedItem());
            this.initFromProp(prop, objs, comp);
        }
    }

    public static class SelectNamedPropConnection
    extends ASinglePropConnection<HTMLBtn, TypedProp<? extends INamed>> {
        public SelectNamedPropConnection(TypedProp<? extends INamed> prop, HTMLBtn control) {
            super(prop, control);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void setProp(TypedProp<? extends INamed> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
        }

        @Override
        public void initFromProp(TypedProp<? extends INamed> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            PropValue<? extends INamed> val = CompositePropertyUtil.getValue(prop, objs);
            comp.setText("");
            comp.setVisible(false);
            if (val.isUniform()) {
                INamed named = val.get();
                comp.setText(named.getName());
                comp.setVisible(true);
                comp.addActionListener(new SelectNamedAction(named));
            }
        }

        private static class SelectNamedAction
        extends AMerlinOp
        implements ActionListener {
            private static INamed d_named;

            public SelectNamedAction(INamed named) {
                d_named = named;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                UIHook.run(UIHook.getComponent(e), "SelectNamedAction", this, 0);
            }

            @Override
            public void run(VentusApp app, VentusData md) {
                try (VentusData.WriteLock lock = md.lockWrite();){
                    Undo.begin(Intl.intl("Select Object"));
                    Undo.insertUndoEntry_restoreSelection(md);
                    md.selection.set(d_named);
                    Undo.end(md);
                }
            }
        }
    }

    public static class NamePropConnection
    extends TextPropConnection {
        public NamePropConnection(guiTextField control) {
            super((TypedProp<String>)NamedMerlinObj.NAME, control);
        }

        @Override
        public void setProp(TypedProp<String> prop, Collection<? extends IMerlinObj> objs, String newText) {
            JFrame parent;
            VentusApp app = VentusApp.getApp();
            VentusData md = app != null ? app.getData() : null;
            boolean updateAll = RenameAction.rename(md, parent = app != null ? app.getActiveFrame() : null, theUtil.filter(objs, INamed.class), newText);
            if (!updateAll) {
                this.initFromProp(prop, objs, (guiTextField)this.getControl());
            }
        }
    }

    public static class TextPropConnection
    extends ASinglePropConnection<guiTextField, TypedProp<String>> {
        public TextPropConnection(TypedProp<String> prop, guiTextField control) {
            super(prop, control);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void initFromProp(TypedProp<String> prop, Collection<? extends IMerlinObj> objs, guiTextField comp) {
            PropValue<String> val = CompositePropertyUtil.getValue(prop, objs);
            if (val.isUniform()) {
                String s = val.get();
                comp.setValue(s);
                comp.setCaretPosition(0);
            } else {
                comp.setText("");
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(TypedProp<String> prop, Collection<? extends IMerlinObj> objs, guiTextField comp) {
            if (!comp.getText().isEmpty() && comp.isModified() && comp.validateData(false, true)) {
                VentusData md = VentusApp.getApp().getData();
                assert (md != null);
                this.setProp(prop, objs, comp.getValue());
                comp.setModified(false);
            }
            comp.selectAll();
        }

        @Override
        public void setProp(TypedProp<String> prop, Collection<? extends IMerlinObj> objs, String newText) {
            VentusData md = VentusApp.getApp().getData();
            Undo.begin(Intl.intl("Set Property"));
            Undo.insertUndoEntry_propRestore(md, objs, prop);
            CompositePropertyUtil.setValue(prop, newText, objs);
            Undo.end(md);
        }
    }

    public static class StringPropConnection
    extends ASinglePropConnection<guiTextArea, TypedProp<String>> {
        public StringPropConnection(TypedProp<String> prop, guiTextArea control) {
            super(prop, control);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void initFromProp(TypedProp<String> prop, Collection<? extends IMerlinObj> objs, guiTextArea comp) {
            PropValue<String> val = CompositePropertyUtil.getValue(prop, objs);
            if (val.isUniform()) {
                String s = val.get();
                comp.setValue(s);
                comp.setCaretPosition(0);
            } else {
                comp.setText("");
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(TypedProp<String> prop, Collection<? extends IMerlinObj> objs, guiTextArea comp) {
            if (!comp.getText().isEmpty() && comp.isModified() && comp.validateData(false, true)) {
                VentusData md = VentusApp.getApp().getData();
                assert (md != null);
                this.setProp(prop, objs, comp.getValue());
                comp.setModified(false);
            }
            comp.selectAll();
        }

        @Override
        public void setProp(TypedProp<String> prop, Collection<? extends IMerlinObj> objs, String newText) {
            VentusData md = VentusApp.getApp().getData();
            Undo.begin(Intl.intl("Set Property"));
            Undo.insertUndoEntry_propRestore(md, objs, prop);
            CompositePropertyUtil.setValue(prop, newText, objs);
            Undo.end(md);
        }
    }

    public static abstract class AMultiPropConnection<T extends JComponent, PropT>
    extends APropConnection<T> {
        private final Collection<? extends PropT> d_props;

        public AMultiPropConnection(Collection<? extends PropT> props, T control) {
            super(control);
            this.d_props = props;
        }

        @Override
        protected void forceCommit() {
            VentusData md = VentusApp.getApp().getData();
            md.pauseUpdates();
            this.setProps(this.d_props, this.d_data, this.d_control);
            md.resumeUpdates();
            this.setModified(this.d_control, false);
        }

        @Override
        protected void initFromProp() {
            this.runWhileLocked(() -> this.initFromProp(this.d_props, this.d_data, this.d_control));
        }

        public abstract void setProps(Collection<? extends PropT> var1, Collection<? extends IMerlinObj> var2, T var3);

        protected abstract void initFromProp(Collection<? extends PropT> var1, Collection<? extends IMerlinObj> var2, T var3);
    }

    public static abstract class ASinglePropConnection<T extends JComponent, PropT>
    extends APropConnection<T> {
        private final PropT d_prop;

        public ASinglePropConnection(PropT prop, T control) {
            super(control);
            this.d_prop = prop;
        }

        @Override
        protected void forceCommit() {
            VentusData md = VentusApp.getApp().getData();
            md.pauseUpdates();
            this.setProp(this.d_prop, this.d_data, this.d_control);
            md.resumeUpdates();
            this.setModified(this.d_control, false);
        }

        @Override
        protected void initFromProp() {
            this.runWhileLocked(() -> this.initFromProp(this.d_prop, this.d_data, this.d_control));
        }

        public abstract void setProp(PropT var1, Collection<? extends IMerlinObj> var2, T var3);

        public abstract void initFromProp(PropT var1, Collection<? extends IMerlinObj> var2, T var3);
    }

    public static abstract class APropConnection<T extends JComponent>
    extends APropEditorListener
    implements IPropConnection {
        protected T d_control;
        protected Collection<IMerlinObj> d_data;
        private final Action d_listenerAction;
        protected Semaphore d_lock;
        protected boolean d_live;

        protected APropConnection(T control) {
            this.d_control = control;
            this.d_live = true;
            this.d_lock = new Semaphore(1);
            this.d_listenerAction = new AbstractAction(){
                private static final long serialVersionUID = 3563125676559170424L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.onControlChanged();
                }
            };
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            ((JComponent)this.d_control).getInputMap().put(enter, "enter");
            ((JComponent)this.d_control).getActionMap().put("enter", this.d_listenerAction);
        }

        public T getControl() {
            return this.d_control;
        }

        public void setUpdateLock(Semaphore lock) {
            this.d_lock = lock;
        }

        public Semaphore getUpdateLock() {
            return this.d_lock;
        }

        protected boolean isLocked() {
            return this.d_lock.availablePermits() == 0;
        }

        public Collection<IMerlinObj> getObjs() {
            return this.d_data;
        }

        protected boolean isDataEmpty() {
            return this.d_data == null || this.d_data.isEmpty();
        }

        protected boolean isModified(T comp) {
            return !(this.d_control instanceof Modifiable) || ((Modifiable)this.d_control).isModified();
        }

        protected void setModified(T comp, boolean modified) {
            if (comp instanceof Modifiable) {
                ((Modifiable)comp).setModified(modified);
            }
        }

        @Override
        public void update(Events events) {
            if (this.isDataEmpty()) {
                return;
            }
            this.initFromProp();
        }

        @Override
        public void keyPressed(KeyEvent evt) {
        }

        public void setLive(boolean live) {
            this.d_live = live;
        }

        public boolean isLive() {
            return this.d_live;
        }

        @Override
        public void onControlChanged() {
            if (this.d_live) {
                this.runCommitOp("onControlChanged");
            }
        }

        protected void runCommitOp(String methodName) {
            PropConnections.runCommitOp(this.getClass(), methodName, this.isModified(), this.d_lock, (app, md) -> this.forceCommit());
        }

        @Override
        public final void commit() {
            if (!this.isModified()) {
                return;
            }
            this.runWhileLocked(() -> this.forceCommit());
        }

        protected boolean isModified() {
            return !this.isDataEmpty() && this.isModified(this.d_control);
        }

        protected abstract void forceCommit();

        @Override
        public void release() {
            this.d_data = Collections.EMPTY_LIST;
        }

        @Override
        public void bind(Collection<IMerlinObj> objs) {
            this.d_data = objs;
            Runnable r = () -> {
                if (this.isDataEmpty()) {
                    return;
                }
                this.initFromProp();
            };
            SwingUtilities.invokeLater(r);
        }

        protected SemaphoreLock tryLock() {
            return new SemaphoreLock(this.d_lock);
        }

        protected void runWhileLocked(Runnable whileLocked) {
            try (SemaphoreLock lock = this.tryLock();){
                if (lock.isValid()) {
                    whileLocked.run();
                }
            }
        }

        protected abstract void initFromProp();
    }

    public static abstract class APropEditorListener
    implements ItemListener,
    FocusListener,
    KeyListener,
    ActionListener,
    IEventObserver {
        public abstract void onControlChanged();

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.onControlChanged();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                this.onControlChanged();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.onControlChanged();
        }
    }

    public static interface IPropConnection
    extends IEventObserver {
        public void bind(Collection<IMerlinObj> var1);

        public void release();

        public void commit();
    }
}

