/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.awt.Component;
import java.util.Collection;
import java.util.concurrent.Semaphore;
import javax.swing.JButton;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.scene3d.manip.HandleMgr;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.units.UnitPoint3D;
import ventus.Intl;
import ventus.geom.Geometry;
import ventus.gui.APropEditPanel;
import ventus.gui.IPropEditCommand;
import ventus.mv.gui.LocationPanel;
import ventus.util.MerlinProps;

public class HandleManipPanel
extends APropEditPanel<MerlinProps> {
    private static final long serialVersionUID = -8253549904926373509L;
    private final Component d_renderComponent;
    private final HandleMgr d_handleMgr;
    private final LocPanel d_locPanel;
    private final CreateBtPanel d_createPanel;

    public HandleManipPanel(HandleMgr handleMgr, Component renderComp) {
        super(new Object[0]);
        this.d_handleMgr = handleMgr;
        this.d_renderComponent = renderComp;
        this.d_locPanel = new LocPanel();
        this.d_createPanel = new CreateBtPanel();
        this.d_locPanel.setProps(new MerlinProps());
        this.d_createPanel.setProps(new MerlinProps());
        this.addSection(this.d_locPanel);
        this.addSeparator();
        this.addSection(this.d_createPanel);
    }

    public void update() {
        this.d_locPanel.updateFromProps(null);
        this.d_createPanel.updateFromProps(null);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.d_locPanel.getXFld().requestFocusInWindow();
    }

    private class LocPanel
    extends LocationPanel<MerlinProps> {
        private static final long serialVersionUID = -6077636088698020673L;
        private final Semaphore d_lock = new Semaphore(1);

        private LocPanel() {
        }

        @Override
        protected void updateFromProps(MerlinProps props) {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            try {
                if (HandleManipPanel.this.d_handleMgr.isModifying()) {
                    Point3d p = HandleManipPanel.this.d_handleMgr.getManipLast();
                    if (p == null) {
                        p = HandleManipPanel.this.d_handleMgr.getManipBegin();
                    }
                    if (p == null) {
                        return;
                    }
                    this.setValue(new UnitPoint3D(p, Geometry.LENGTH_UNIT));
                }
            }
            finally {
                this.d_lock.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateToProps(MerlinProps props) {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            try {
                if (HandleManipPanel.this.d_handleMgr.isModifying()) {
                    IsectInfo isect = null;
                    Point3d p = this.getValue().getPoint3dValue(Geometry.LENGTH_UNIT);
                    ISnapConstraint constraint = HandleManipPanel.this.d_handleMgr.getManipConstraint();
                    if (constraint != null) {
                        Collection<IsectInfo> ii = constraint.snapPoint(() -> {}, p);
                        if (!ii.isEmpty()) {
                            isect = ii.iterator().next();
                            p = isect.isectPoint;
                        } else {
                            p = null;
                        }
                    }
                    if (p != null) {
                        HandleManipPanel.this.d_handleMgr.manip(isect, p);
                        HandleManipPanel.this.d_renderComponent.repaint();
                    }
                }
            }
            catch (ManipException e) {
                TeciLogging.logFlowControlException(e);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                this.d_lock.release();
            }
        }
    }

    private class CreateBtPanel
    extends APropEditPanel<MerlinProps> {
        private static final long serialVersionUID = 8098179489673551372L;
        private final JButton d_commitBtn;
        private final JButton d_cancelBtn;

        public CreateBtPanel() {
            super(new Object[0]);
            this.d_commitBtn = this.initButton(new JButton(Intl.intl("Commit")), new IPropEditCommand(){

                @Override
                public void updateProp(Component c, boolean hardValidate) {
                    if (!CreateBtPanel.this.validateData(hardValidate, hardValidate) || !HandleManipPanel.this.d_locPanel.validateData(hardValidate, hardValidate)) {
                        return;
                    }
                    HandleManipPanel.this.d_handleMgr.end(true);
                }
            });
            this.d_cancelBtn = this.initButton(new JButton(Intl.intl("Cancel")), new IPropEditCommand(){

                @Override
                public void updateProp(Component c, boolean hardValidate) {
                    if (!CreateBtPanel.this.validateData(hardValidate, hardValidate)) {
                        return;
                    }
                    HandleManipPanel.this.d_handleMgr.end(false);
                    HandleManipPanel.this.d_renderComponent.repaint();
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_commitBtn);
            gb.addRow(this.d_cancelBtn);
        }

        @Override
        protected void updateFromProps(MerlinProps props) {
            this.d_commitBtn.setEnabled(HandleManipPanel.this.d_handleMgr.isModifying() && HandleManipPanel.this.d_handleMgr.isModified());
            this.d_cancelBtn.setEnabled(HandleManipPanel.this.d_handleMgr.isModifying());
        }

        @Override
        protected void updateToProps(MerlinProps props) {
        }
    }
}

