/*
 * Decompiled with CFR 0.152.
 */
package ventus.io.contamx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import thunderheadeng.util.Pair;

public class PrjData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String name = "ContamW";
    public String version = "3.4.0.6";
    public int echo = 1;
    public int rows = 58;
    public int cols = 66;
    public int ud;
    public int uf;
    public double T = 293.15;
    public int uT = 2;
    public double N;
    public double wH = 10.0;
    public int u;
    public double Ao = 0.6;
    public double a = 0.28;
    public double scale = 1.0;
    public int us;
    public int orgRow = 56;
    public int orgCol = 1;
    public int invYaxis;
    public int showGeom;
    public WeatherData steadyStateSim;
    public WeatherData windPresTest;
    public double Xref;
    public double Yref;
    public double Zref;
    public double angle;
    public int uXYZ;
    public double epsP = 0.01;
    public double epsS = 0.01;
    public String tShift = "00:00:00";
    public String dStart = "1/1";
    public String dEnd = "1/1";
    public int wp;
    public int mf;
    public int wpctrig;
    public double latd = 40.0;
    public double longtd = -90.0;
    public double tznr = -6.0;
    public double altd;
    public double Tgrnd = 283.15;
    public int utg = 2;
    public int u_a;
    public int sim_af;
    public int afcalc = 1;
    public int afmaxi = 30;
    public double afrcnvg = 1.0E-5;
    public double afacnvg = 1.0E-6;
    public double afrelax = 0.75;
    public int uac;
    public double Pbldg = 50.0;
    public int uPb;
    public int slae;
    public int rs = 1;
    public int aflmaxi = 100;
    public double aflcnvg = 1.0E-6;
    public int aflinit = 1;
    public int Tadj;
    public LinearSolverContam cyclic;
    public LinearSolverContam nonTrace;
    public LinearSolverContam trace;
    public LinearSolverContam cvodeSolver;
    public int mfSolver;
    public int sim1dz = 1;
    public int sim1dd;
    public double celldx = 0.1;
    public int simVjt;
    public int udx;
    public int cvode;
    public double rcnvg = 1.0E-6;
    public double acnvg = 1.0E-13;
    public double dtmax;
    public int tsdens = 0;
    public double relax = 0.75;
    public int tsmaxi = 20;
    public int cnvgSS = 1;
    public int densZP;
    public int stackD;
    public int dodMdt;
    public String dateSt = "Jan01";
    public String timeSt = "00:00:00";
    public String date0 = "Jan01";
    public String time0 = "00:00:00";
    public String date1 = "Jan01";
    public String time1 = "24:00:00";
    public String tStep = "00:05:00";
    public String tList = "01:00:00";
    public String tScrn = "01:00:00";
    public int restart;
    public String date = "Jan01";
    public String time = "00:00:00";
    public int list = 1;
    public int doDlg = 0;
    public int pfsave = 1;
    public int zfsave = 1;
    public int zcsave = 1;
    public int achvol;
    public int achsave;
    public int abwsave;
    public int cbwsave;
    public int expsave;
    public int ebwsave;
    public int zaasave;
    public int zbwsave;
    public int rzf;
    public int rzm;
    public int rz1;
    public int csm = 1;
    public int srf = 1;
    public int log = 1;
    public int bcx;
    public int dcx;
    public int pfq = 1;
    public int zfq = 1;
    public int zcq = 1;
    public double dens = 1.2041;
    public double grav = 9.8055;
    public String extra = "  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0";
    public int nrvals;
    public int valZ;
    public int valD;
    public int valC;
    public int cfd;
    public double cfdcnvg = 0.01;
    public int var;
    public int zref;
    public int maxi = 1000;
    public int dtcmo = 1;
    public int solv = 1;
    public int smooth = 1;
    public double cnvgUVW = 0.001;
    public double cnvgT = 0.001;
    public int nctm;
    public List<Integer> contaminantsList;
    public int nspcs;
    public List<Species> speciesList;
    public int nlev;
    public List<Level> levelList;
    public int ndsch;
    public List<DaySchedule> dayScheduleList;
    public int nwsch;
    public List<WeekSchedule> weekScheduleList;
    public int nwpf;
    public List<WindProfile> windProfileList;
    public int nkinr;
    public int nflte;
    public int nfilt;
    public int ncse;
    public List<SourceSinkElem> sourceSinkElementList;
    public Map<Integer, SourceSinkTypeCsCcf> csCcfMap = new HashMap<Integer, SourceSinkTypeCsCcf>();
    public int nafe;
    public List<AirFlowElem> airFlowList;
    public Map<Integer, AirFlowTypePlrOrf> plrOrfMap = new HashMap<Integer, AirFlowTypePlrOrf>();
    public Map<Integer, AirFlowTypePlrLeakArea> plrLeakAreaMap = new HashMap<Integer, AirFlowTypePlrLeakArea>();
    public Map<Integer, AirFlowTypePlrStair> plrStairMap = new HashMap<Integer, AirFlowTypePlrStair>();
    public Map<Integer, AirFlowTypePlrShaft> plrShaftMap = new HashMap<Integer, AirFlowTypePlrShaft>();
    public Map<Integer, AirFlowTypeSelfRegulatingVent> selfRegulatingVentMap = new HashMap<Integer, AirFlowTypeSelfRegulatingVent>();
    public Map<Integer, AirFlowTypeQvP> qvpMap = new HashMap<Integer, AirFlowTypeQvP>();
    public Map<Integer, AirFlowTypeTwoWayOneOpening> twOneOpMap = new HashMap<Integer, AirFlowTypeTwoWayOneOpening>();
    public Map<Integer, AirFlowTypeTwoWayTwoOpening> twTwoOpMap = new HashMap<Integer, AirFlowTypeTwoWayTwoOpening>();
    public Map<Integer, AirFlowTypeConstantMassFlowFan> constantMassFlowFanMap = new HashMap<Integer, AirFlowTypeConstantMassFlowFan>();
    public Map<Integer, AirFlowTypeConstantVolumeFlowFan> constantVolumeFlowFanMap = new HashMap<Integer, AirFlowTypeConstantVolumeFlowFan>();
    public Map<Integer, AirFlowTypePerformanceCurve> performanceCurveMap = new HashMap<Integer, AirFlowTypePerformanceCurve>();
    public Map<Integer, AirFlowTypeTestData1Point> plrTest1Map = new HashMap<Integer, AirFlowTypeTestData1Point>();
    public Map<Integer, AirFlowTypeTestData2Point> plrTest2Map = new HashMap<Integer, AirFlowTypeTestData2Point>();
    public Map<Integer, AirFlowTypeCrackDescription> plrCrackMap = new HashMap<Integer, AirFlowTypeCrackDescription>();
    public List<AHS> ahsList;
    public int ndfe;
    public List<DuctFlowElem> ductFlowList;
    public Map<Integer, DuctFlowTypeDarceyColebrook> dctDwcMap = new HashMap<Integer, DuctFlowTypeDarceyColebrook>();
    public Map<Integer, DuctGeometry> ductGeometryMap = new HashMap<Integer, DuctGeometry>();
    public Map<Integer, DuctFlowTypeConstantMassFan> ductConstMassMap = new HashMap<Integer, DuctFlowTypeConstantMassFan>();
    public Map<Integer, DuctFlowTypeConstantVolumeFan> ductConstVolumeMap = new HashMap<Integer, DuctFlowTypeConstantVolumeFan>();
    public Map<Integer, DuctFlowPlrElem> ductPlrMap = new HashMap<Integer, DuctFlowPlrElem>();
    public Map<Integer, DuctFlowTypePerformanceCurve> ductPerformanceCurveMap = new HashMap<Integer, DuctFlowTypePerformanceCurve>();
    public int nselmt;
    public int nctrl;
    public int nahs;
    public int nzone;
    public List<Zone> zoneList;
    public int nn;
    public List<String> zoneConcentrationHeaders;
    public List<ZoneConcentration> zoneConcentrationList;
    public int npath;
    public List<AirFlowPath> airFlowPathList;
    public int njct;
    public List<Junction> junctionList;
    public int numOfMassFractions;
    public List<String> juncConcentrationHeaders;
    public List<JunctionConcentration> juncConcentrationList;
    public int ndct;
    public List<Segment> segmentList;
    public int ncss;
    public List<SourceSink> sourceSinkList;
    public int nosch;
    public int npexp;
    public int nnote;

    public PrjData() {
        this.steadyStateSim = new WeatherData(0.0, 0.0);
        this.windPresTest = new WeatherData(1.0, 270.0);
        this.cyclic = new LinearSolverContam(0, null, null, 30, 1.0E-4, 1.0E-15, 1.25, null, 0);
        this.nonTrace = new LinearSolverContam(null, 0, 1, 100, 1.0E-6, 1.0E-15, 1.1, 1.0, 0);
        this.trace = new LinearSolverContam(null, 0, 1, 100, 1.0E-6, 1.0E-15, 1.1, 1.0, 0);
        this.cvodeSolver = new LinearSolverContam(null, 0, 1, 100, 1.0E-6, 1.0E-15, 1.1, null, 0);
        this.dayScheduleList = new ArrayList<DaySchedule>();
        this.weekScheduleList = new ArrayList<WeekSchedule>();
        this.speciesList = new ArrayList<Species>();
        this.contaminantsList = new ArrayList<Integer>();
        this.levelList = new ArrayList<Level>();
        this.airFlowList = new ArrayList<AirFlowElem>();
        this.ductFlowList = new ArrayList<DuctFlowElem>();
        this.sourceSinkElementList = new ArrayList<SourceSinkElem>();
        this.ahsList = new ArrayList<AHS>();
        this.zoneList = new ArrayList<Zone>();
        this.zoneConcentrationHeaders = new ArrayList<String>();
        this.zoneConcentrationList = new ArrayList<ZoneConcentration>();
        this.airFlowPathList = new ArrayList<AirFlowPath>();
        this.sourceSinkList = new ArrayList<SourceSink>();
        this.ductFlowList = new ArrayList<DuctFlowElem>();
        this.junctionList = new ArrayList<Junction>();
        this.juncConcentrationHeaders = new ArrayList<String>();
        this.juncConcentrationList = new ArrayList<JunctionConcentration>();
        this.segmentList = new ArrayList<Segment>();
        this.windProfileList = new ArrayList<WindProfile>();
    }

    public boolean assertValid() {
        PrjData.assertEquals(this.nlev, this.levelList.size());
        this.assertProperNr(this.levelList, obj -> obj.nr);
        PrjData.assertEquals(this.nafe, this.airFlowList.size());
        this.assertProperNr(this.airFlowList, obj -> obj.nr);
        PrjData.assertEquals(this.nahs, this.ahsList.size());
        this.assertProperNr(this.ahsList, obj -> obj.nr);
        PrjData.assertEquals(this.nzone, this.zoneList.size());
        this.assertProperNr(this.zoneList, obj -> obj.nr);
        PrjData.assertEquals(this.npath, this.airFlowPathList.size());
        this.assertProperNr(this.airFlowPathList, obj -> obj.nr);
        PrjData.assertEquals(this.nwpf, this.windProfileList.size());
        this.assertProperNr(this.windProfileList, obj -> obj.nr);
        return true;
    }

    private static void assertEquals(int a, int b) {
        assert (a == b) : "Expected " + a + " found " + b;
    }

    private <T> void assertProperNr(List<T> vals, Function<T, Integer> extractNr) {
        for (int i = 0; i < vals.size(); ++i) {
            int nr = extractNr.apply(vals.get(i));
            assert (nr == i + 1);
        }
    }

    public Zone findZoneNr(int nr) {
        Optional<Zone> result = this.zoneList.stream().filter(obj -> obj.nr == nr).findAny();
        return result.isPresent() ? result.get() : null;
    }

    public AirFlowPath findFlowPathNr(int nr) {
        Optional<AirFlowPath> result = this.airFlowPathList.stream().filter(obj -> obj.nr == nr).findAny();
        return result.isPresent() ? result.get() : null;
    }

    public Species findSpeciesNr(int nr) {
        Optional<Species> result = this.speciesList.stream().filter(obj -> obj.nr == nr).findAny();
        return result.orElse(null);
    }

    public SourceSinkElem findSourceSinkElemNr(int nr) {
        Optional<SourceSinkElem> result = this.sourceSinkElementList.stream().filter(obj -> obj.nr == nr).findAny();
        return result.orElse(null);
    }

    public Zone findZone(Object room) {
        return this.getUsingRefObj(this.zoneList, obj -> obj.refObj, room);
    }

    public Level findLevel(Object floor) {
        return this.getUsingRefObj(this.levelList, obj -> obj.refObj, floor);
    }

    public AirFlowElem findAirFlowElem(Object flowElement) {
        return this.getUsingRefObj(this.airFlowList, obj -> obj.refObj, flowElement);
    }

    public AHS findAHS(Object ahs) {
        return this.getUsingRefObj(this.ahsList, obj -> obj.refObj, ahs);
    }

    public SourceSinkElem findSourceSinkElem(Object sourceSinkElem) {
        return this.getUsingRefObj(this.sourceSinkElementList, obj -> obj.refObj, sourceSinkElem);
    }

    public WindProfile findWindProfile(Object windProf) {
        return this.getUsingRefObj(this.windProfileList, obj -> obj.refObj, windProf);
    }

    public Species findSpecies(Object species) {
        return this.getUsingRefObj(this.speciesList, obj -> obj.refObj, species);
    }

    public DuctFlowElem findDuctFlowElement(Object element) {
        return this.getUsingRefObj(this.ductFlowList, obj -> obj.refObj, element);
    }

    public Junction findJunction(Object junction) {
        return this.getUsingRefObj(this.junctionList, obj -> obj.refObj, junction);
    }

    private <T, R> T getUsingRefObj(List<T> vals, Function<T, R> extracter, R refObj) {
        for (T val : vals) {
            if (extracter.apply(val) != refObj) continue;
            return val;
        }
        assert (false);
        return null;
    }

    public static class WeatherData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double Ta = 293.15;
        public double Pb = 101325.0;
        public double Ws;
        public double Wd;
        public double rh;
        public int day = 1;
        public int[] unitsCollection = new int[]{0, 0, 3, 0};

        public WeatherData() {
        }

        public WeatherData(double ws, double wd) {
            this.Ws = ws;
            this.Wd = wd;
        }
    }

    public static class LinearSolverContam
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Integer sim_mf;
        public Integer slae;
        public Integer rs;
        public int maxi;
        public double relcnvg;
        public double abscnvg;
        public double relax;
        public Double gamma;
        public int ucc;

        public LinearSolverContam() {
        }

        public LinearSolverContam(Integer simMf, Integer slae, Integer rs, int maxi, double rel, double abs, double relax, Double gamma, int ucc) {
            this.sim_mf = simMf;
            this.slae = slae;
            this.rs = rs;
            this.maxi = maxi;
            this.relcnvg = rel;
            this.abscnvg = abs;
            this.relax = relax;
            this.gamma = gamma;
            this.ucc = ucc;
        }
    }

    public static class Zone
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public int flags;
        public int ps;
        public int pc;
        public int pk;
        public int pl;
        public double relHt;
        public double vol;
        public double T0;
        public int P0;
        public String name;
        public int color;
        public int u_Ht;
        public int uT;
        public int uP;
        public int uV;
        public int cdaxis;
        public int cdvf;
        public int cfd;
        public final Object refObj;

        public Zone(Object refObj) {
            this.refObj = refObj;
        }
    }

    public static class AirFlowPath
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public String vntsDesc;
        public int flags;
        public int pzn;
        public int pzm;
        public int pe;
        public int pf;
        public int pw;
        public int pa;
        public int ps;
        public int pc;
        public int pld;
        public double X;
        public double Y;
        public double relHt;
        public double mult;
        public double wPset;
        public double wPmod;
        public double wazm;
        public double Fahs;
        public int xmax;
        public int xmin;
        public int icon;
        public int dir;
        public int color;
        public int u_Ht;
        public int u_XY;
        public int u_dp;
        public int u_F;
        public int cdvf;
        public int cfd;
        public final Object refObj;

        public AirFlowPath(Object refObj) {
            this.refObj = refObj;
            this.vntsDesc = "";
        }
    }

    public static class Species
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public int sflag;
        public int ntflag;
        public double molwt;
        public double mdiam;
        public double edens;
        public double decay;
        public double Dm;
        public double ccdef;
        public double Cp;
        public double Kuv;
        public int ucc;
        public int umd;
        public int ued;
        public int udm;
        public int ucp;
        public String name;
        public String description;
        public final Object refObj;

        public Species(Object refObj) {
            this.refObj = refObj;
        }
    }

    public static class SourceSinkElem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public String spcs;
        public String ctype;
        public String name;
        public String desc;
        public final Object refObj;

        public SourceSinkElem(Object refObj) {
            this.refObj = refObj;
        }
    }

    public static class Level
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public double refHt;
        public double delHt;
        public int ni = 0;
        public int u_rfht;
        public int u_dlht;
        public String levelName;
        public Icon[] icons;
        public final Object refObj;

        public Level(Object refObj) {
            this.refObj = refObj;
        }
    }

    public static class AirFlowElem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public int icon;
        public String type;
        public String name;
        public String desc;
        public final Object refObj;

        public AirFlowElem(Object refObj) {
            this.refObj = refObj;
        }
    }

    public static class AHS
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public int zoneR;
        public int zoneS;
        public int pathR;
        public int pathS;
        public int pathX;
        public int color;
        public String name;
        public String desc;
        public final Object refObj;

        public AHS(Object refObj) {
            this.refObj = refObj;
        }
    }

    public static class WindProfile
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public int npts;
        public int graphLineType = 1;
        public String name;
        public String description;
        public ArrayList<Double> degrees;
        public ArrayList<Double> coefficient;
        public final Object refObj;

        public WindProfile(Object refObj) {
            this.refObj = refObj;
            this.degrees = new ArrayList();
            this.coefficient = new ArrayList();
        }
    }

    public static class DuctFlowElem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public int icon;
        public String dtype;
        public String name;
        public String desc;
        public final Object refObj;

        public DuctFlowElem(Object refObj) {
            this.refObj = refObj;
        }
    }

    public static class Junction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public int flags;
        public int jtype;
        public int pzn;
        public int dnr;
        public int pk;
        public int ps;
        public int pc;
        public int pld;
        public double X;
        public double Y;
        public double relHt;
        public double T0;
        public double P0;
        public int icon;
        public int color;
        public int u_Ht;
        public int u_XY;
        public int u_T;
        public int u_dP;
        public int vf_type;
        public String vf_node_name;
        public String T;
        public int pf;
        public int pw;
        public double wPset;
        public double wPmod;
        public double wazm;
        public int bal;
        public double Ad;
        public double Af;
        public double Fdes;
        public double Ct;
        public double Cb;
        public double Cbmax;
        public int u_A;
        public int u_F;
        public int ddir;
        public int fdir;
        public final Object refObj;

        public Junction(Object refObj) {
            this.refObj = refObj;
        }
    }

    public static class Icon
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int iconType;
        public int rowPos;
        public int colPos;
        public int nrNum;
    }

    public static class Segment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public int flags;
        public int pjn;
        public int pjm;
        public int pe;
        public int pf;
        public int ps;
        public int pc;
        public int dir;
        public double length;
        public double Ain;
        public double Aout;
        public double sllc;
        public int color;
        public int u_L;
        public int u_A;
        public int vf_type;
        public String vf_node_name;
        public final Object refObj;

        public Segment(Object refObj) {
            this.refObj = refObj;
        }
    }

    public static class JunctionConcentration
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public List<Double> concentrations = new ArrayList<Double>();
    }

    public static class DuctFlowTypeDarceyColebrook
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double roughness;
        public double lam;
        public int u_r;
    }

    public static class DuctGeometry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double hdia;
        public double perim;
        public double area;
        public double major;
        public double minor;
        public double As;
        public double Qr;
        public double Pr;
        public int shape;
        public int u_d;
        public int u_p;
        public int u_a;
        public int u_mj;
        public int u_mn;
        public int u_qr;
        public int u_pr;
    }

    public static class DuctFlowTypeConstantVolumeFan
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double flow;
        public int uF;
    }

    public static class DuctFlowTypeConstantMassFan
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double flow;
        public int uF;
    }

    public static class DuctFlowPlrElem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double lam;
        public double turb;
        public double expt;
        public double area;
        public double dia;
        public double coef;
        public int uA;
        public int uD;
    }

    public static class DuctFlowTypePerformanceCurve
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double lam;
        public double turb;
        public double expt;
        public double cutOffRatio;
        public double area;
        public double refFluidDensity = 1.2041;
        public int uA;
        public double freeDeliveryFlow;
        public double shutOffPressure;
        public double[] coefficients = new double[4];
        public int npts;
        public int u_x;
        public int u_y;
        public ArrayList<Pair<Double, Double>> points = new ArrayList();
    }

    public static class AirFlowTypePerformanceCurve
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double lam;
        public double turb;
        public double expt;
        public double cutOffRatio;
        public double area;
        public double refFluidDensity = 1.2041;
        public int uA;
        public double freeDeliveryFlow;
        public double shutOffPressure;
        public double[] coefficients = new double[4];
        public int npts;
        public int u_x;
        public int u_y;
        public ArrayList<Pair<Double, Double>> points = new ArrayList();
    }

    public static class AirFlowTypeConstantVolumeFlowFan
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double maxFlowRate;
        public int uF;
    }

    public static class AirFlowTypeConstantMassFlowFan
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double maxFlowRate;
        public int uF;
    }

    public static class AirFlowTypeCrackDescription
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double lam;
        public double turb;
        public double expt;
        public double length;
        public double width;
        public int u_L;
        public int u_W;
    }

    public static class AirFlowTypeTestData2Point
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double lam;
        public double turb;
        public double expt;
        public double dP1;
        public double F1;
        public double dP2;
        public double F2;
        public int u_P1;
        public int u_F1;
        public int u_P2;
        public int u_F2;
    }

    public static class AirFlowTypeTestData1Point
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double lam;
        public double turb;
        public double expt;
        public double dP;
        public double flow;
        public int u_P;
        public int u_F;
    }

    public static class AirFlowTypeTwoWayTwoOpening
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double lam;
        public double turb;
        public double expt;
        public double dH;
        public double ht;
        public double wd;
        public double cd;
        public int u_H;
        public int u_W;
    }

    public static class AirFlowTypeTwoWayOneOpening
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double lam;
        public double turb;
        public double expt;
        public double dTmin;
        public double ht;
        public double wd;
        public double cd;
        public int u_T;
        public int u_H;
        public int u_W;
    }

    public static class AirFlowTypeQvP
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int npts;
        public int u_x;
        public int u_y;
        public ArrayList<Pair<Double, Double>> points;
    }

    public static class AirFlowTypeSelfRegulatingVent
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double maxFlowRate;
        public double regulatingPressure;
        public double reverseFlowFraction;
        public int uF;
        public int uP;
    }

    public static class AirFlowTypePlrLeakArea
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double lam;
        public double turb;
        public double expt;
        public double coef;
        public double pres;
        public double area1;
        public double area2;
        public double area3;
        public int uA1;
        public int uA2;
        public int uA3;
        public int udP;
    }

    public static class AirFlowTypePlrOrf
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double lam;
        public double turb;
        public double expt;
        public double area;
        public double dia;
        public double coef;
        public double Re;
        public int uA;
        public int uD;
    }

    public static class AirFlowTypePlrStair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double lam;
        public double turb;
        public double expt;
        public double Ht;
        public double area;
        public int peo;
        public int tread;
        public int uA;
        public int uD;
    }

    public static class AirFlowTypePlrShaft
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double lam;
        public double turb;
        public double expt;
        public double Ht;
        public double area;
        public double perim;
        public double rough;
        public int uA;
        public int uD;
        public int uP;
        public int uR;
    }

    public static class SourceSinkTypeCsCcf
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double G;
        public double D;
        public int u_G;
        public int u_D;
    }

    public static class ZoneConcentration
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public List<Double> concentrations = new ArrayList<Double>();
    }

    public static class SourceSink
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public int pz;
        public int pe;
        public int ps;
        public int pc;
        public double mult;
        public double CC0;
        public double Xmin;
        public double Ymin;
        public double Hmin;
        public double Xmax;
        public double Ymax;
        public double Hmax;
        public int u_XYZ;
        public int vf_type;
        public String vf_node_name;
        public int cfd;
        public String name;
        public final Object refObj;

        public SourceSink(Object refObj) {
            this.refObj = refObj;
        }
    }

    public static class WeekSchedule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public int utyp;
        public int ucnv;
        public String name;
        public String desc;
        public int[] j = new int[12];
    }

    public static class DaySchedule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int nr;
        public int npts;
        public int shape;
        public int utyp;
        public int ucnv;
        public String name = "";
        public String desc = "";
        public List<SchedulePoint> pts = new ArrayList<SchedulePoint>();
    }

    public static class SchedulePoint
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String time;
        public double ctrl;

        public SchedulePoint(String time, double ctrl) {
            this.time = time;
            this.ctrl = ctrl;
        }
    }
}

