/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui.value;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.ObservableProxy;
import ventus.Intl;
import ventus.VentusApp;
import ventus.data.value.Schedule;
import ventus.gui.UnitUpdator;
import ventus.gui.value.ScheduleEditorPnl;
import ventus.unitsystem.UnitSystem;
import ventus.unitsystem.UnitUpdatableComponent;

public class ScheduleField
extends guiPanel
implements UnitUpdatableComponent {
    private static final long serialVersionUID = 1L;
    public static final String VALUE = "value";
    private final String d_propName;
    private Unit d_unit;
    private final ScheduleUnitSource d_unitSource;
    private Schedule d_currVal;
    private final guiComboBox<RequireEntries> d_modeCB;
    private final ValueField<UnitDouble> d_constFld;
    private final HTMLBtn d_scheduleBtn;

    public ScheduleField(String propName, int unit, UnitDoubleVR range) {
        this.d_propName = propName;
        this.d_unit = VentusApp.getApp().getUnitSystem().getUnit(unit);
        this.d_unitSource = new ScheduleUnitSource(this);
        this.d_constFld = ValueFields.udFld(this.d_unitSource, range);
        this.d_constFld.addValueListener(ValueField.VAL_COMMIT, e -> {
            Schedule newVal = Schedule.newConstant((UnitDouble)this.d_constFld.getValue());
            if (!Objects.equals(this.d_currVal, newVal)) {
                Schedule oldVal = this.d_currVal;
                this.d_currVal = newVal;
                this.firePropertyChange(VALUE, oldVal, newVal);
                this.sync();
            }
        });
        this.d_scheduleBtn = new HTMLBtn("");
        this.d_scheduleBtn.addActionListener(e -> {
            Schedule newVal;
            ScheduleEditorPnl editorPnl = new ScheduleEditorPnl(propName, UnitSystem.getType(1, true), ValueFields.udFld(this.d_unitSource, range));
            editorPnl.load(this.d_currVal);
            Window parent = SwingUtilities.getWindowAncestor(this);
            String title = String.format(Intl.intl("Edit %s"), propName);
            guiDialog dlg = new guiDialog(parent, title, 9);
            dlg.setResizable(true);
            guiPanel c = dlg.getDialogPane();
            c.setLayout(new BorderLayout());
            c.add((Component)editorPnl, "Center");
            if (dlg.doModal() == 1 && dlg.isModified() && (newVal = editorPnl.save()) != null && !Objects.equals(this.d_currVal, newVal)) {
                Schedule oldVal = this.d_currVal;
                this.d_currVal = newVal;
                this.firePropertyChange(VALUE, oldVal, newVal);
                this.sync();
            }
            editorPnl.close();
        });
        this.d_modeCB = new guiComboBox<RequireEntries>(RequireEntries.values());
        this.d_modeCB.addActionListener(e -> {
            RequireEntries selector0$temp = this.d_modeCB.getSelectedItem();
            int index$1 = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NO_ENTRIES", "ENTRIES"}, (RequireEntries)selector0$temp, index$1)) {
                default: {
                    throw new MatchException(null, null);
                }
                case -1: 
                case 0: {
                    this.d_constFld.setVisible(true);
                    this.d_scheduleBtn.setVisible(false);
                    if (this.d_currVal == null || !this.d_currVal.type.hasEntries) break;
                    Schedule oldVal = this.d_currVal;
                    this.d_currVal = Schedule.newConstant(oldVal.initVal);
                    this.firePropertyChange(VALUE, oldVal, this.d_currVal);
                    this.sync();
                    break;
                }
                case 1: {
                    this.d_constFld.setVisible(false);
                    this.d_scheduleBtn.setVisible(true);
                    if (this.d_currVal == null || this.d_currVal.type.hasEntries) break;
                    Schedule oldVal = this.d_currVal;
                    this.d_currVal = Schedule.newRectangular(oldVal.initVal, new Schedule.Entry[0]);
                    this.firePropertyChange(VALUE, oldVal, this.d_currVal);
                    this.sync();
                }
            }
        });
        this.d_modeCB.setSelectedItem((Object)RequireEntries.NO_ENTRIES);
        this.setLayout(new MigLayout("insets 0"));
        this.add(this.d_modeCB);
        this.add(this.d_constFld, "hidemode 1, wmin 90");
        this.add((Component)this.d_scheduleBtn, "hidemode 1, wmin 90");
        this.sync();
        UnitUpdator.addComp(this);
    }

    @Override
    public void update(Unit newUnit) {
        if (this.d_unit != newUnit) {
            this.d_unit = newUnit;
            this.d_unitSource.setChanged();
            this.sync();
        }
    }

    @Override
    public Unit getDisplayUnit() {
        return this.d_unit;
    }

    public String getPropName() {
        return this.d_propName;
    }

    public void setValue(Schedule value) {
        this.d_currVal = value;
        this.sync();
    }

    public Schedule getValue() {
        return this.d_currVal;
    }

    private String describe(Schedule schedule) {
        return schedule.format(this.d_unit);
    }

    private void sync() {
        if (this.d_currVal != null) {
            this.d_scheduleBtn.setText(this.describe(this.d_currVal));
            this.d_modeCB.setSelectedItem((Object)(this.d_currVal.type.hasEntries ? RequireEntries.ENTRIES : RequireEntries.NO_ENTRIES));
            this.d_constFld.setValue(this.d_currVal.initVal);
        } else {
            this.d_scheduleBtn.setText("&lt;" + Intl.intl("varies") + "&gt;");
            this.d_modeCB.setSelectedItem(null);
            this.d_constFld.setValue(null);
        }
    }

    private static class ScheduleUnitSource
    implements IUnitSrc {
        private final ObservableProxy d_observable = new ObservableProxy(this);
        private final ScheduleField d_scheduleField;

        public ScheduleUnitSource(ScheduleField field) {
            this.d_scheduleField = field;
        }

        @Override
        public Unit getUnit() {
            return this.d_scheduleField.getDisplayUnit();
        }

        @Override
        public void addObserver(IObserver observer, boolean weakRef) {
            this.d_observable.addObserver(observer, weakRef);
        }

        @Override
        public void deleteObserver(IObserver observer) {
            this.d_observable.deleteObserver(observer);
        }

        public void setChanged() {
            this.d_observable.setChanged(true);
        }
    }

    private static enum RequireEntries {
        NO_ENTRIES(Intl.intl("Constant")),
        ENTRIES(Intl.intl("Schedule"));

        public final String name;

        private RequireEntries(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

