/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui.value;

import java.util.Collections;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import ventus.Intl;
import ventus.data.value.ConstVariant;
import ventus.data.value.DiscreteVariant;
import ventus.data.value.IVariant;
import ventus.gui.value.DefaultVarEditorPnl;
import ventus.gui.value.IVariantEditor;

public class NumberVarEditor<T extends Number>
implements IVariantEditor<T> {
    private final Class<T> d_type;
    private final ValueField<T> d_protoField;

    public NumberVarEditor(Class<T> type, ValueField<T> protoField) {
        this.d_type = type;
        this.d_protoField = protoField;
        this.getFormatter().setNullAllowed(true);
    }

    private guiFormattedFld.Formatter<T> getFormatter() {
        return (guiFormattedFld.Formatter)this.d_protoField.getFormatter();
    }

    @Override
    public String describe(IVariant<T> variant) {
        guiFormattedFld.Formatter<T> format = this.getFormatter();
        if (variant instanceof ConstVariant) {
            return String.format(Intl.intl("Always %s"), format.valueToString(((ConstVariant)variant).value));
        }
        if (variant instanceof DiscreteVariant) {
            DiscreteVariant dvar = (DiscreteVariant)variant;
            return String.format(Intl.intl("t(0) = %s, ..."), format.valueToString(dvar.initVal));
        }
        return "";
    }

    @Override
    public guiPanel getEditorPanel(IUnitSrc timeUnit) {
        return DefaultVarEditorPnl.newPnl(timeUnit, this.d_type, this.d_protoField, Collections.emptyList());
    }

    @Override
    public void load(guiPanel editorPanel, IVariant<T> variant) {
        DefaultVarEditorPnl epnl = (DefaultVarEditorPnl)editorPanel;
        epnl.load(variant);
    }

    @Override
    public IVariant<T> save(guiPanel editorPanel) {
        DefaultVarEditorPnl epnl = (DefaultVarEditorPnl)editorPanel;
        return epnl.save();
    }
}

