/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import thunderheadeng.gui.AObjsList;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import ventus.VentusApp;
import ventus.actions.MerlinOpImpl;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.gui.guiUtil;
import ventus.util.MerlinUtil;

public class VentusObjsList
extends AObjsList<IMerlinObj> {
    public VentusObjsList(VentusData vd, String undoDesc, boolean linkSelection, boolean autoSort, Collection<? extends IMerlinObj> objs) {
        super(VentusObjsList.getCallback(vd, undoDesc), linkSelection, autoSort, objs);
    }

    private static AObjsList.ICallback<IMerlinObj> getCallback(final VentusData vd, final String undoDesc) {
        return new AObjsList.ICallback<IMerlinObj>(){

            @Override
            public Collection<? extends IMerlinObj> finalizeObjs(Collection<? extends IMerlinObj> objs, boolean autoSort) {
                if (!autoSort) {
                    return objs;
                }
                ArrayList<? extends IMerlinObj> sortedReplacements = new ArrayList<IMerlinObj>(objs);
                Comparator<? extends IMerlinObj> baseSorter = MerlinUtil.getSorter(vd, objs);
                sortedReplacements.sort((o1, o2) -> {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return baseSorter.compare((IMerlinObj)o1, (IMerlinObj)o2);
                });
                return sortedReplacements;
            }

            @Override
            public Events getEvents() {
                return vd.getEvents();
            }

            @Override
            public boolean isSelectionEvent(IEventRecord<?> events) {
                return events.containsChange(VentusData.SELECTION_CHANGED);
            }

            @Override
            public boolean isDecorationEvent(IEventRecord<?> events) {
                return events.containsChange(NamedMerlinObj.NAME);
            }

            @Override
            public boolean isSelected(IMerlinObj obj) {
                return vd.selection.isSelected(obj);
            }

            @Override
            public void setSelection(AObjsList<IMerlinObj> dlg, Collection<? extends IMerlinObj> objs) {
                MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                    try (VentusData.WriteLock lock = md.lockWrite();){
                        Undo.begin(undoDesc);
                        Undo.insertUndoEntry_restoreSelection(md);
                        md.selection.clear();
                        md.selection.selectAll(objs);
                        Undo.end(md);
                    }
                });
                UIHook.run(dlg, "VentusObjsList.updateSelAction.valueChanged", op, 0);
            }

            @Override
            public void decorateCells(DefaultListCellRenderer r, JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                guiUtil.decorateCellRenderer(vd, list::repaint, value, r, isSelected, cellHasFocus);
                r.setText(MerlinUtil.getName(value));
            }

            @Override
            public JPopupMenu getContextMenu(MouseEvent e) {
                return VentusApp.getApp().getContextMenu();
            }
        };
    }
}

