/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javafx.stage.FileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import thunderheadeng.gui.ALibraryDlg;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.io.FilenameManager;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.AddObject;
import ventus.actions.Delete;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.INamed;
import ventus.data.INamedMerlinObj;
import ventus.data.VentusData;
import ventus.gui.guiUtil;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.MerlinOOS;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;

public class LibraryDlg<T extends INamedMerlinObj>
extends ALibraryDlg<T> {
    private static final long serialVersionUID = 4159924215120436555L;
    private static final String libExtension = "vlib";
    private static final String vntsExtension = "vnts";
    private VentusData d_dataFromFile;
    private List<T> d_libModel;
    private final VentusData d_vd;
    private final List<T> d_curModel;
    private final VentusApp d_app;
    private final Runnable d_updateMgr;
    private final LibraryInfo<T> d_libInfo;
    public final Function<VentusData, Composite<T>> d_getRoot;
    public final Function<Composite<T>, Collection<T>> d_getMembers;

    public LibraryDlg(JFrame owner, VentusApp app, Runnable updateMgr, Function<VentusData, Composite<T>> getRoot, Function<Composite<T>, Collection<T>> getMembers, LibraryInfo libInfo) {
        super(owner, app, Intl.intl(libInfo.d_name + " Libraries"), libExtension);
        this.d_app = app;
        this.d_vd = this.d_app.getData();
        this.d_getRoot = getRoot;
        this.d_getMembers = getMembers;
        this.d_updateMgr = updateMgr;
        this.d_curModel = new ArrayList<T>();
        this.d_curModel.addAll(getMembers.apply(getRoot.apply(this.d_vd)));
        this.d_libModel = new ArrayList<T>();
        this.d_libInfo = libInfo;
        this.loadList(this.d_curModel, this.d_modelObjs, libInfo.d_class);
        this.init(MerlinPrefs.LIB_DLG_LAST_LIB, MerlinPrefs.LIB_DLG_OPEN_DIR_PREF, this.d_libInfo.d_class);
    }

    @Override
    protected File serialize(List<T> objs) {
        guiJFXFileChooser chooser = new guiJFXFileChooser(String.format("%s.%s", FilenameManager.splitFilename(this.d_currentLib)[0], libExtension), MerlinPrefs.get(MerlinPrefs.LIB_DLG_OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, new FileChooser.ExtensionFilter(Intl.intl("Ventus Library"), "*.vlib"));
        File f = chooser.showSaveDialog();
        if (f == null) {
            return null;
        }
        MerlinPrefs.set(MerlinPrefs.LIB_DLG_OPEN_DIR_PREF, f.getParent());
        VentusData tempData = this.d_dataFromFile == null ? new VentusData(false) : this.d_dataFromFile;
        Composite<T> root = this.d_getRoot.apply(tempData);
        root.clear();
        root.addAll(objs);
        tempData.setUnitSystem(this.d_app.getUnitSystem());
        try (MerlinOOS oos = new MerlinOOS(new FileOutputStream(f));){
            oos.writeObject(tempData);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.getParent(), e.getLocalizedMessage(), Intl.intl("Error"), 2);
            e.printStackTrace();
        }
        return f;
    }

    @Override
    protected Mediator getDomain() {
        return this.d_vd;
    }

    @Override
    protected FileChooser.ExtensionFilter[] getFileFilter() {
        return new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(Intl.intl("Ventus Library"), "*.vlib"), new FileChooser.ExtensionFilter(Intl.intl("Ventus Model File (Read-only)"), "*.vnts")};
    }

    @Override
    protected String getPredefinedPath() {
        return this.d_libInfo.d_predefinedLibInstallPath;
    }

    @Override
    protected String getAppDataPath() {
        return this.d_libInfo.d_predefinedLibAppDataPath;
    }

    @Override
    protected List<T> deserialize(String filename, boolean showWarnings) {
        VentusIO io = new VentusIO();
        try {
            VentusIO.OpenResult result = io.openModel(this, filename, (progress, runnable) -> progress.cancel(), VentusOIS.DM_DEFAULT, this.d_app.getComponents(IInputStreamFeatureHandler.class));
            this.d_dataFromFile = result.data;
            this.d_libModel = new ArrayList<T>(this.d_getMembers.apply(this.d_getRoot.apply(this.d_dataFromFile)));
            return this.d_libModel;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            if (showWarnings) {
                JOptionPane.showMessageDialog(this.getParent(), String.format(Intl.intl("The file \"%s\" could not be read."), filename));
            }
            return null;
        }
    }

    @Override
    protected void saveToLibrary() {
        this.d_app.beginWaitCursor();
        if (!this.copyListSelection(this.d_modelObjs, this.d_libObjs, this.d_libModel).isEmpty()) {
            this.d_libUnsaved = true;
        }
        this.d_app.endWaitCursor();
    }

    @Override
    protected void loadFromLibrary() {
        this.d_app.beginWaitCursor();
        List<T> added = this.copyListSelection(this.d_libObjs, this.d_modelObjs, this.d_curModel);
        if (!added.isEmpty()) {
            this.d_vd.pauseUpdates();
            Undo.begin(String.format(Intl.intl("New %s"), this.d_libInfo.d_name));
            Composite<T> root = this.d_getRoot.apply(this.d_vd);
            Collection<T> objs = this.d_getMembers.apply(root);
            AddObject.add(this.d_vd, root, objs.size(), added);
            Undo.end(this.d_vd);
            this.d_vd.resumeUpdates();
        }
        this.d_app.endWaitCursor();
    }

    public List<T> copyListSelection(JList<T> jlistBeingCopied, JList<T> jlistCopiedTo, List<T> containerCopiedTo) {
        List<T> objsToCopy = jlistBeingCopied.getSelectedValuesList();
        if (objsToCopy.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<INamedMerlinObj, INamedMerlinObj> replacements = new LinkedHashMap<INamedMerlinObj, INamedMerlinObj>();
        for (INamedMerlinObj iNamedMerlinObj : objsToCopy) {
            String newName = this.getNewName(iNamedMerlinObj, containerCopiedTo);
            INamedMerlinObj newProf = (INamedMerlinObj)iNamedMerlinObj.clone();
            if (!newName.equals(iNamedMerlinObj.getName())) {
                newProf.setName(newName);
            }
            replacements.put(iNamedMerlinObj, newProf);
        }
        for (Map.Entry entry : replacements.entrySet()) {
            int replIndex = objsToCopy.indexOf(entry.getKey());
            objsToCopy.remove(replIndex);
            objsToCopy.add(replIndex, (INamedMerlinObj)entry.getValue());
        }
        containerCopiedTo.addAll(objsToCopy);
        this.loadList(containerCopiedTo, jlistCopiedTo, this.d_libInfo.d_class);
        return objsToCopy;
    }

    private String getNewName(INamed namedObj, Collection<? extends INamed> containerCopiedTo) {
        boolean alreadyExists;
        String baseName = namedObj.getName();
        Object newName = baseName;
        int i = 1;
        do {
            alreadyExists = false;
            for (INamed iNamed : containerCopiedTo) {
                if (!iNamed.getName().equals(newName)) continue;
                alreadyExists = true;
                break;
            }
            if (!alreadyExists) continue;
            newName = baseName + " (" + i++ + ")";
        } while (alreadyExists);
        return newName;
    }

    @Override
    protected void deleteModObjs() {
        final List objs = this.d_modelObjs.getSelectedValuesList();
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(VentusApp app, VentusData md) {
                Delete.uiDelete(LibraryDlg.this.d_app, md, new HashSet(objs), true);
                LibraryDlg.this.d_curModel.clear();
                VentusData.ReadLock readLock = LibraryDlg.this.d_vd.lockRead();
                LibraryDlg.this.d_curModel.addAll(LibraryDlg.this.d_getMembers.apply(LibraryDlg.this.d_getRoot.apply(LibraryDlg.this.d_vd)));
                readLock.close();
                LibraryDlg.this.loadList(LibraryDlg.this.d_curModel, LibraryDlg.this.d_modelObjs, LibraryDlg.this.d_libInfo.d_class);
                if (LibraryDlg.this.d_updateMgr != null) {
                    LibraryDlg.this.d_updateMgr.run();
                }
            }
        };
        UIHook.run((Component)this, "LibraryDlg.DeleteAction.actionPerformed", op, 0);
    }

    @Override
    protected void deleteLibObjs() {
        if (this.deleteObjs(this.d_libObjs, this.d_libModel)) {
            this.d_libUnsaved = true;
        }
    }

    private boolean deleteObjs(JList<T> jlist, List<T> domain) {
        List<T> objs = jlist.getSelectedValuesList();
        if (objs.isEmpty()) {
            return false;
        }
        domain.removeAll(objs);
        this.loadList(domain, jlist, this.d_libInfo.d_class);
        return true;
    }

    @Override
    protected List<T> getLibModel() {
        return this.d_libModel;
    }

    @Override
    protected void resetLibModel() {
        this.d_libModel = new ArrayList<T>();
    }

    @Override
    protected void decorateCells(ALibraryDlg.ManagerRenderer r, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        guiUtil.decorateCellRenderer(this.d_vd, list::repaint, value, r, isSelected, cellHasFocus);
        INamedMerlinObj obj = (INamedMerlinObj)value;
        r.setText(obj.getName());
    }

    public static class LibraryInfo<E extends INamedMerlinObj> {
        private final String d_predefinedLibInstallPath;
        private final String d_predefinedLibAppDataPath;
        private final Class<E> d_class;
        private final String d_name;

        public LibraryInfo(String name, Class<E> clazz, VentusApp app, String installPathTail, String libPathTail) {
            this.d_name = Intl.intl(name);
            this.d_class = clazz;
            this.d_predefinedLibInstallPath = new File(app.getInstallDir(), installPathTail).getPath();
            this.d_predefinedLibAppDataPath = new File(app.getAppDataDir(), libPathTail).getPath();
        }
    }
}

