/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Semaphore;
import javax.swing.ComboBoxModel;
import javax.swing.JSeparator;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import ventus.Intl;
import ventus.actions.NewFloor;
import ventus.actions.SetActiveFloor;
import ventus.actions.ShowAllFloors;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.FloorComposite;
import ventus.gui.FloorListModel;

public class FloorComboModel
extends FloorListModel
implements ComboBoxModel<Object> {
    private static final long serialVersionUID = -3560225259569125957L;
    private WeakReference<Floor> d_selectedFloor;
    private final Semaphore d_lock = new Semaphore(1);
    public static final Object NEW_FLOOR_ITEM = Intl.intl("<Add New...>");
    public static final Object SHOW_ALL_ITEM = Intl.intl("<Show All>");
    public static final Object SEPARATOR = new JSeparator(0);

    public FloorComboModel(VentusData data) {
        super(data);
        this.updateSelectedFloor();
    }

    @Override
    protected Collection<?> getFloors(VentusData md) {
        Collection<?> superFloors = super.getFloors(md);
        ArrayList<Object> floors = new ArrayList<Object>(superFloors.size() + 2);
        floors.add(NEW_FLOOR_ITEM);
        floors.add(SHOW_ALL_ITEM);
        floors.add(SEPARATOR);
        floors.addAll(superFloors);
        return floors;
    }

    @Override
    public Object getSelectedItem() {
        return this.d_selectedFloor.get();
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.setSelectedItem(anItem, true);
    }

    public void setSelectedItem(Object anItem, boolean setActive) {
        if (anItem == NEW_FLOOR_ITEM) {
            NewFloor.UI_HOOK.run(null);
        } else if (anItem == SHOW_ALL_ITEM) {
            ShowAllFloors.UI_HOOK.run(null);
        } else if (anItem != SEPARATOR) {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            this.d_selectedFloor = new WeakReference<Floor>((Floor)anItem);
            int ix = this.indexOf(this.d_selectedFloor.get());
            this.fireContentsChanged(this, ix, ix);
            if (setActive) {
                SetActiveFloor.setActiveFloor(null, (Floor)anItem);
            }
            this.d_lock.release();
        }
    }

    private void updateSelectedFloor() {
        this.setSelectedItem(this.getData().activeFloor(), false);
    }

    @Override
    public void update(Events events) {
        super.update(events);
        for (EventChannel<FloorComposite> channel : events.getAffectedChannels(FloorComposite.class, new Class[0])) {
            if (!channel.hasChangedObjs(FloorComposite.ACTIVE_FLOOR)) continue;
            this.updateSelectedFloor();
            break;
        }
    }
}

