/*
 * Decompiled with CFR 0.152.
 */
package ventus.geom;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import thunderheadeng.geometry.ShapeUtil;

public class ShapeRasterizer {
    public static void rasterize(double error, Shape shape, Matrix4d worldXform, Collector collector) {
        assert (error > 0.0);
        PathIterator path = ShapeUtil.getPathIterator(shape, null, error);
        double[] coords = new double[6];
        Point3d firstPoint = null;
        Tuple3d lastPoint = null;
        boolean filled = shape instanceof Area;
        ArrayList<Point3d> edgePoints = new ArrayList<Point3d>();
        while (!path.isDone()) {
            int type = path.currentSegment(coords);
            switch (type) {
                case 0: {
                    firstPoint = ShapeRasterizer.xform(worldXform, coords, 0);
                    ShapeRasterizer.endPointSeries(collector, false, filled, edgePoints);
                    lastPoint = firstPoint;
                    edgePoints.add(firstPoint);
                    break;
                }
                case 4: {
                    if (lastPoint.equals(firstPoint)) {
                        edgePoints.remove(edgePoints.size() - 1);
                    }
                    ShapeRasterizer.endPointSeries(collector, true, filled, edgePoints);
                    break;
                }
                case 1: {
                    Point3d currPoint = ShapeRasterizer.xform(worldXform, coords, 0);
                    lastPoint = ShapeRasterizer.advanceLineSeg(edgePoints, (Point3d)lastPoint, currPoint);
                    break;
                }
            }
            path.next();
        }
        ShapeRasterizer.endPointSeries(collector, filled, edgePoints);
    }

    private static void endPointSeries(Collector collector, boolean filled, List<Point3d> edgePoints) {
        boolean closed = false;
        if (edgePoints.size() > 2 && edgePoints.get(0).equals(edgePoints.get(edgePoints.size() - 1))) {
            edgePoints.remove(edgePoints.size() - 1);
            closed = true;
        }
        ShapeRasterizer.endPointSeries(collector, closed, filled, edgePoints);
    }

    private static void endPointSeries(Collector collector, boolean closed, boolean filled, List<Point3d> edgePoints) {
        if (edgePoints.size() == 1) {
            collector.addPoint(edgePoints.get(0));
        } else if (edgePoints.size() > 1) {
            if (closed && filled) {
                collector.addPoly(ShapeRasterizer.toArray(edgePoints));
            } else {
                collector.addLineStrip(closed, ShapeRasterizer.toArray(edgePoints));
            }
        }
        edgePoints.clear();
    }

    private static Point3d[] toArray(Collection<Point3d> points) {
        return points.toArray(new Point3d[points.size()]);
    }

    private static Point3d advanceLineSeg(List<Point3d> edgePoints, Point3d p1, Point3d p2) {
        if (!p1.equals(p2)) {
            edgePoints.add(p2);
        }
        return p2;
    }

    private static Point3d xform(Matrix4d xform, double[] coords, int offset) {
        Point3d p = new Point3d(coords[offset], coords[offset + 1], 0.0);
        xform.transform(p);
        return p;
    }

    public static interface Collector {
        public void addPoint(Point3d var1);

        public void addLineStrip(boolean var1, Point3d ... var2);

        public void addPoly(Point3d ... var1);
    }
}

