/*
 * Decompiled with CFR 0.152.
 */
package ventus.geom;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CancellationException;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.RayAABoxTest;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.elem.IPrimElements;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ColorPool;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Sets;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.theUtil;
import ventus.VentusApp;
import ventus.data.IMerlinObj;
import ventus.data.IOpacity;
import ventus.data.Opacity;
import ventus.data.VentusData;
import ventus.data.material.TexMappers;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.RoomUtil;
import ventus.feature.props.PropertyDefs;
import ventus.geom.Geometry;
import ventus.geom.IMerlinGeomSrc;
import ventus.geom.Inter2D;
import ventus.geom.PointGeomFinder;
import ventus.util.Dependencies;
import ventus.util.MerlinUtil;

public class GeomUtil {
    public static final IElemSource<Point2d> DEFUV = TexMappers.newPlanarCoordMapper(new Point3d(0.0, 0.0, 0.0));
    public static final UnitDouble GEOM_LEN_ZERO = new UnitDouble(0.0, Geometry.LENGTH_UNIT);

    public static double dist(Tuple3d a, Tuple3d b) {
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        double dz = b.z - a.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double dist(Tuple3f a, Tuple3f b) {
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        double dz = b.z - a.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static boolean samePt(Tuple3d pt1, Tuple3d pt2, double tol) {
        return GeomUtil.dist(pt1, pt2) <= tol;
    }

    public static boolean samePt(Tuple3f pt1, Tuple3f pt2, double tol) {
        return GeomUtil.dist(pt1, pt2) <= tol;
    }

    public static Vector2d randomVec(Random rand) {
        double x = 0.0;
        double y = 0.0;
        while (x == 0.0 && y == 0.0) {
            x = rand.nextDouble() - 0.5;
            y = rand.nextDouble() - 0.5;
        }
        return new Vector2d(x, y);
    }

    public static Point2d findPointInPoly(List<? extends IParametric2D> poly, double tol) {
        if (poly.isEmpty()) {
            return null;
        }
        Point2d startPoint = poly.get(0).get(0.5);
        Random rand = new Random(0L);
        for (int m = 0; m < 10; ++m) {
            Vector2d rvec = GeomUtil.randomVec(rand);
            List<double[]> trimmed = Inter2D.trimLineToPoly(poly, startPoint, rvec, tol);
            for (double[] seg : trimmed) {
                if (theUtil.eq(seg[0], seg[1], tol)) continue;
                double midt = (seg[0] + seg[1]) * 0.5;
                return Util2D.linePoint(startPoint, rvec, midt);
            }
        }
        return startPoint;
    }

    public static boolean addToModel(Model model, int groupid, Mesh mesh) {
        boolean result = true;
        switch (mesh.primtype) {
            case 1: {
                int m = 0;
                while (m < mesh.indices.length) {
                    Point3d p1 = mesh.vertices[mesh.indices[m++]];
                    Point3d p2 = mesh.vertices[mesh.indices[m++]];
                    model.addEdge(groupid, new LineSeg3D(p1, p2));
                }
                break;
            }
            case 2: {
                int m = 0;
                while (m < mesh.indices.length) {
                    Point3d p1 = mesh.vertices[mesh.indices[m++]];
                    Point3d p2 = mesh.vertices[mesh.indices[m++]];
                    Point3d p3 = mesh.vertices[mesh.indices[m++]];
                    result &= model.addPolygonFace(groupid, new Plane3d(true, p1, p2, p3), p1, p2, p3);
                }
                break;
            }
            case 3: {
                int m = 0;
                while (m < mesh.indices.length) {
                    Point3d p1 = mesh.vertices[mesh.indices[m++]];
                    Point3d p2 = mesh.vertices[mesh.indices[m++]];
                    Point3d p3 = mesh.vertices[mesh.indices[m++]];
                    Point3d p4 = mesh.vertices[mesh.indices[m++]];
                    result &= model.addPolygonFace(groupid, new Plane3d(true, p1, p2, p3, p4), p1, p2, p3, p4);
                }
                break;
            }
            default: {
                return false;
            }
        }
        return result;
    }

    public static boolean addFaceToModel(Model model, int groupid, Plane3d plane, Collection<? extends IParametric3D> boundary) {
        return model.addFace(groupid, plane, boundary);
    }

    public static boolean addFaceToModel(IFace face, Model model, int groupid, double edgeError, double faceError) {
        return GeomUtil.addFaceToModel(face, true, model, groupid, edgeError, faceError);
    }

    public static boolean addFaceToModel(IFace face, boolean ccw, Model model, int groupid, double edgeError, double faceError) {
        if (face instanceof Triangle) {
            Triangle tri = (Triangle)face;
            Plane3d plane = new Plane3d(ccw, tri.p1, tri.p2, tri.p3);
            if (ccw) {
                return model.addPolygonFace(groupid, plane, tri.p1, tri.p2, tri.p3);
            }
            return model.addPolygonFace(groupid, plane, tri.p3, tri.p2, tri.p1);
        }
        if (face instanceof IPlanarFace) {
            IPolygon poly = ((IPlanarFace)face).toPoly(edgeError);
            Plane3d plane = poly.getPlane(ccw);
            Point3d[][] loops = PolyUtil.getLoops(poly, false);
            ArrayList<LineSeg3D> curves = new ArrayList<LineSeg3D>();
            for (Point3d[] loop : loops) {
                Point3d p22;
                if (loop.length == 0) continue;
                if (ccw) {
                    for (int m = 0; m < loop.length; ++m) {
                        Point3d p12 = loop[m];
                        p22 = loop[(m + 1) % loop.length];
                        if (p12.equals(p22)) continue;
                        curves.add(new LineSeg3D(p12, p22));
                    }
                    continue;
                }
                Point3d p13 = loop[0];
                for (int m = loop.length - 1; m >= 0; --m) {
                    p22 = loop[m];
                    if (!p13.equals(p22)) {
                        curves.add(new LineSeg3D(p13, p22));
                    }
                    p13 = p22;
                }
            }
            return model.addFace(groupid, plane, curves);
        }
        boolean result = true;
        Pair<Mesh, Boolean> triResult = face.triangulate(faceError, ccw);
        Mesh triangles = (Mesh)triResult.v1;
        boolean tccw = (Boolean)triResult.v2;
        TriFunction<Point3d, Point3d, Point3d, Boolean> addTri = tccw ? (p1, p2, p3) -> {
            Plane3d plane = new Plane3d(true, (Point3d)p1, (Point3d)p2, (Point3d)p3);
            return model.addPolygonFace(groupid, plane, (Point3d)p1, (Point3d)p2, (Point3d)p3);
        } : (p3, p2, p1) -> {
            Plane3d plane = new Plane3d(true, (Point3d)p1, (Point3d)p2, (Point3d)p3);
            return model.addPolygonFace(groupid, plane, (Point3d)p1, (Point3d)p2, (Point3d)p3);
        };
        int m = 0;
        while (m < triangles.indices.length) {
            Point3d p14 = triangles.vertices[triangles.indices[m++]];
            Point3d p23 = triangles.vertices[triangles.indices[m++]];
            Point3d p32 = triangles.vertices[triangles.indices[m++]];
            result &= addTri.apply(p14, p23, p32).booleanValue();
        }
        return result;
    }

    public static void addCurveToModel(ICurve curve, Model model, int groupid, double edgeError) {
        if (curve instanceof LineSeg) {
            LineSeg ls = (LineSeg)curve;
            model.addEdge(groupid, new LineSeg3D(ls.p1, ls.p2));
        } else {
            Mesh mesh = curve.getSegments(edgeError);
            int m = 0;
            while (m < mesh.indices.length) {
                Point3d p1 = mesh.vertices[mesh.indices[m++]];
                Point3d p2 = mesh.vertices[mesh.indices[m++]];
                model.addEdge(groupid, new LineSeg3D(p1, p2));
            }
        }
    }

    public static List<IFace> extractFaces(Model model, Integer groupid) {
        ArrayList<IFace> faces = new ArrayList<IFace>();
        for (Face face : model.getFaces()) {
            IFace gface;
            if (groupid != null && !face.partOfGroup(groupid) || (gface = GeomUtil.toGeomFace(face)) == null) continue;
            faces.add(gface);
        }
        return faces;
    }

    public static IFace toGeomFace(Face face) {
        ArrayList<Point3d[]> loops = new ArrayList<Point3d[]>(face.edgeLoops.size());
        for (FaceLoop loop : face.edgeLoops) {
            if (loop.edges.size() < 3) continue;
            Point3d[] points = new Point3d[loop.edges.size()];
            for (int m = 0; m < loop.edges.size(); ++m) {
                EdgeUse eu = loop.edges.get(m);
                points[m] = eu.v1().loc;
            }
            loops.add(points);
        }
        if (loops.isEmpty()) {
            return null;
        }
        return PolyUtil.newPoly((Point3d[][])loops.toArray((T[])new Point3d[loops.size()][]));
    }

    public static ICurve toGeomCurve(EdgeUse eu) {
        return GeomUtil.toGeomCurve(eu.curve());
    }

    public static ICurve toGeomCurve(IParametric3D curve) {
        if (curve.isLinear()) {
            return new LineSeg(curve.get(0.0), curve.get(1.0));
        }
        assert (false);
        return null;
    }

    public static Model transform(Model model, ITransform xform, Matrix4d matrix) {
        Model mclone = model.clone();
        mclone.transform(xform, matrix);
        RoomUtil.ensureProperFaceOrient(mclone);
        return mclone;
    }

    public static List<? extends IPolygon> toPolys(IFace face, double error) {
        if (face instanceof IPolygon) {
            return Arrays.asList((IPolygon)face);
        }
        return thunderheadeng.geometry.objs.GeomUtil.convertToTriangles(error, face);
    }

    public static Area toArea(Face face) {
        return GeomUtil.toArea(face, face.plane);
    }

    public static Area toArea(Face face, Plane3d projPlane) {
        Matrix4d wlXform = Util.getWorldToLocalXform(projPlane);
        Path2D.Double path = new Path2D.Double(0);
        for (FaceLoop loop : face.edgeLoops) {
            ArrayList<IParametric2D> subPath = new ArrayList<IParametric2D>();
            for (EdgeUse eu : loop.edges) {
                subPath.add(eu.curve().projectToPlane(projPlane, wlXform));
            }
            ShapeUtil.appendAsSubPath(path, subPath);
        }
        return new Area(path);
    }

    public static Vector3d to3d(Vector2d v, boolean normalize) {
        double lsq;
        Vector3d result = new Vector3d(v.x, v.y, 0.0);
        if (normalize && (lsq = result.lengthSquared()) > 0.0) {
            result.scale(1.0 / Math.sqrt(lsq));
        }
        return result;
    }

    public static Vector2d to2d(Vector3d v, boolean normalize) {
        double lsq;
        Vector2d result = new Vector2d(v.x, v.y);
        if (normalize && (lsq = result.lengthSquared()) > 0.0) {
            result.scale(1.0 / Math.sqrt(lsq));
        }
        return result;
    }

    public static FindResult findRoom(VentusData md, Point3d loc, int options, Runnable validateProgress) {
        FindResult[] closestResult = new FindResult[]{null};
        double[] closestDistSq = new double[]{Double.MAX_VALUE};
        GeomUtil.findRooms(md, loc, options, validateProgress, isect -> {
            double distsq = isect.p.distanceSquared(loc);
            if (distsq < closestDistSq[0]) {
                closestDistSq[0] = distsq;
                closestResult[0] = isect;
            }
        });
        return closestResult[0];
    }

    public static void findRooms(VentusData md, Point3d loc, int options, Runnable validateProgress, Consumer<FindResult> result) {
        double tol = 1.0E-6;
        PointGeomFinder<ISchematicRoom> finder = new PointGeomFinder<ISchematicRoom>(loc, tol, ISchematicRoom.class);
        md.geomLocation.getLocator().find(finder.test, finder.result, options);
        for (Map.Entry<ISchematicRoom, IsectInfo> entry : finder.getResults().entrySet()) {
            ISchematicRoom room = entry.getKey();
            DisplayGeom pickGeom = room.getPickGeom(IMerlinGeomSrc.NO_DISP_PROPS, validateProgress);
            pickGeom.node.find(finder.test, (fprim, ctmt) -> {
                if (!(fprim.prim instanceof IFace)) {
                    return;
                }
                IFace face = (IFace)fprim.prim;
                if (!finder.test.test((AABox)face.getBoundingBox((AABox)new AABox())).positive) {
                    return;
                }
                double minDistSq = tol * tol;
                FindResult nearest = null;
                for (IPolygon iPolygon : GeomUtil.getPolys(face, 0.0)) {
                    Point3d nearp = iPolygon.project(loc);
                    double distsq = nearp.distance(loc);
                    if (!(distsq < minDistSq) || !iPolygon.classify((Point3d)nearp, (double)1.0E-6).positive) continue;
                    minDistSq = distsq;
                    nearest = new FindResult(room, iPolygon.getNormal(true), nearp, fprim.elements);
                }
                if (nearest != null) {
                    result.accept(nearest);
                }
            });
        }
    }

    public static void findRooms(VentusData vd, Runnable validate, Point3d p, double dist, int searchOptions, Predicate<? super ISchematicRoom> zoneFilter, Predicate<? super ISchematicRoom.IComponent> compFilter, Consumer<? super FindResult> result) {
        double distSq = dist * dist;
        BoundingSphere sphereSearch = new BoundingSphere(p, dist);
        Collection<? super ISchematicRoom> nearbyZones = vd.geomLocation.getLocator().find((ITest<AABox>)sphereSearch, ISchematicRoom.class, zoneFilter, searchOptions);
        nearbyZones.forEach(zone -> {
            validate.run();
            IGeomNode geom = zone.getGeom();
            geom.find(sphereSearch, (prim, ctmt) -> {
                validate.run();
                IPrimitive patt0$temp = prim.prim;
                if (!(patt0$temp instanceof IFace)) {
                    return;
                }
                IFace face = (IFace)patt0$temp;
                ISchematicRoom.IComponent comp = prim.elements.getElement(ISchematicRoom.COMPONENT_ELEMENT).orElse(null);
                if (comp == null) {
                    return;
                }
                if (!compFilter.test(comp)) {
                    return;
                }
                IFace.IPointProjection projected = face.project(validate, p, 1.0E-9);
                if (projected == null || projected.get().distanceSquared(p) > distSq || !projected.isWithinBounds(1.0E-9)) {
                    return;
                }
                Vector3d normal = projected.getNormal(true);
                if (normal == null) {
                    return;
                }
                result.accept(new FindResult((ISchematicRoom)zone, normal, projected.get(), prim.elements));
            });
        });
    }

    public static FindResult findRoom(VentusData md, Point3d rayBegin, Point3d rayEnd, int options, BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> roomFilter) {
        return GeomUtil.findRoom(md, () -> {}, rayBegin, rayEnd, options, roomFilter);
    }

    public static FindResult findRoom(VentusData md, Runnable validateProgress, Point3d rayBegin, Point3d rayEnd, int options, BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> roomFilter) {
        Collection<FindResult> result = GeomUtil.findRooms(md, validateProgress, rayBegin, rayEnd, options, roomFilter);
        return result.isEmpty() ? null : result.iterator().next();
    }

    public static Collection<FindResult> findRooms(VentusData md, Runnable validateProgress, Point3d rayBegin, Point3d rayEnd, int options, BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> roomFilter) {
        Vector3d dir = Util3D.vector(rayBegin, rayEnd);
        return GeomUtil.findRooms(md, validateProgress, rayBegin, dir, 1.0, options, roomFilter);
    }

    public static Collection<FindResult> findRooms(VentusData md, Runnable validateProgress, Point3d rayBegin, Point3d rayEnd, double tolerance, int options, BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> roomFilter) {
        Vector3d dir = Util3D.vector(rayBegin, rayEnd);
        return GeomUtil.findRooms(md, validateProgress, rayBegin, dir, tolerance, options, roomFilter);
    }

    public static Collection<FindResult> findRooms(VentusData md, Runnable validateProgress, Point3d rayBegin, Vector3d rayDir, double maxT, int options, BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> roomFilter) {
        ITest<AABox> test = rayDir.lengthSquared() == 0.0 || maxT == 0.0 ? new AABoxTest(new AABox(rayBegin), 1.0E-6) : new RayAABoxTest(rayBegin, rayDir, maxT, 1.0E-6);
        Collection<ISchematicRoom> rooms = md.geomLocation.getLocator().find(test, ISchematicRoom.class, Predicates.alwaysTrue(), options);
        if (rooms.isEmpty()) {
            return Collections.emptyList();
        }
        return GeomUtil.findRoomIsects(rooms, validateProgress, rayBegin, rayDir, maxT, roomFilter);
    }

    public static Collection<FindResult> findRoomIsects(Collection<? extends ISchematicRoom> rooms, final Runnable validateProgress, Point3d rayBegin, Vector3d rayDir, double maxT, final BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> roomFilter) {
        ITest<AABox> test;
        if (rayDir.lengthSquared() == 0.0 || maxT == 0.0) {
            test = new AABoxTest(new AABox(rayBegin), 1.0E-6);
            double tol = 1.0E-6;
            rayBegin = new Point3d(rayBegin);
            rayBegin.z += tol;
            rayDir = GeomConstants.VEC3D_ZNEG;
            maxT = 2.0 * tol;
        } else {
            test = new RayAABoxTest(rayBegin, rayDir, maxT, 1.0E-6);
            rayDir = new Vector3d(rayDir);
            double rayLen = Util3D.safeNormalize(rayDir, 0.0);
            maxT *= rayLen;
        }
        final ArrayList<FindResult> closestResult = new ArrayList<FindResult>();
        final double[] closestDistSq = new double[]{Double.MAX_VALUE};
        final Point3d rayOrigin = rayBegin;
        IIsectCollector isectCollector = new IIsectCollector(){

            @Override
            public void validate() throws CancellationException {
                validateProgress.run();
            }

            @Override
            public void addNonFace(Object obj, Point3d p, GeomType type, int primIx, IPrimElements primElements) {
            }

            @Override
            public void addInfinite(Object obj, Point3d p, GeomType type, IPrimitive prim) {
            }

            @Override
            public void addFace(Object obj, Point3d p, int primIx, Supplier<IFace> getPrim, Supplier<Vector3d> getNormal, IPrimElements faceElements, IPrimProps faceProps) {
                if (getNormal == null) {
                    return;
                }
                validateProgress.run();
                ISchematicRoom room = (ISchematicRoom)obj;
                if (!roomFilter.test(room, faceElements.getElement(ISchematicRoom.COMPONENT_ELEMENT).orElse(null))) {
                    return;
                }
                double distSq = p.distanceSquared(rayOrigin);
                int compare = theUtil.compare(distSq, closestDistSq[0], 1.0E-12);
                if (compare < 0) {
                    closestResult.clear();
                    closestDistSq[0] = distSq;
                }
                if (compare <= 0) {
                    closestResult.add(new FindResult(room, getNormal.get(), p, faceElements));
                }
            }
        };
        DefaultFilter isectFilter = new DefaultFilter(ISchematicRoom.class, GeomType.FACE);
        for (ISchematicRoom iSchematicRoom : rooms) {
            validateProgress.run();
            iSchematicRoom.pickPoints(isectCollector, isectFilter, rayBegin, rayDir, maxT, test);
        }
        return closestResult;
    }

    private static Collection<? extends IPolygon> getPolys(IFace face, double faceError) {
        if (face instanceof IPolygon) {
            return Collections.singleton((IPolygon)face);
        }
        return thunderheadeng.geometry.objs.GeomUtil.getTriangles(faceError, face);
    }

    public static <ObjT extends IMerlinObj> DisplayProp<IMaterial[]> defineMaterialProp(PropertyDefs<ObjT> defs, Function<? super ObjT, IGeomNode> getGeom, Function<? super ObjT, IPropsSrc> getPropsSrc, TriConsumer<? super ObjT, ? super IGeomNode, IPropsSrc> setDisplayGeom, PropertyDefsFramework.IRestoreProp<VentusData, ObjT, IMaterial[], DisplayProp<IMaterial[]>> restoreDisplayGeom) {
        return defs.storeAsPlainOldData(VentusData.MATERIAL).attrGetter((prop, src) -> {
            IGeomNode geom = (IGeomNode)getGeom.apply((Object)src);
            IPropsSrc propsSrc = (IPropsSrc)getPropsSrc.apply((Object)src);
            return GeomUtil.extractMaterials(geom, propsSrc);
        }, Stream.empty()).attrSetter((prop, src, mats) -> {
            IGeomNode geom = (IGeomNode)getGeom.apply((Object)src);
            IPropsSrc propsSrc = (IPropsSrc)getPropsSrc.apply((Object)src);
            IPropsSrc finalProps = GeomUtil.applyMaterials(geom, propsSrc, mats);
            IGeomNode finalGeom = GeomUtil.finalizeTexCoords(geom, finalProps);
            setDisplayGeom.accept((Object)src, finalGeom, finalProps);
            src.changedEvt(prop);
        }, null).attrDependency(prop -> GeomUtil.newMatDependency()).attrUndoPropRestore(restoreDisplayGeom).attrSurrogateEquals(null).attrFinish();
    }

    public static IMaterial[] extractMaterials(IGeomNode geom, IPropsSrc propsSrc) {
        int ucount;
        int numPrims = geom.getNumPrims(7);
        Object[] mats = new IMaterial[numPrims];
        for (int offset = 0; offset < numPrims; offset += ucount) {
            IMaterial pmat = propsSrc.get(offset).getMaterial();
            ucount = propsSrc.getUniformCount(offset, numPrims - offset);
            Arrays.fill(mats, offset, offset + ucount, pmat);
        }
        return mats;
    }

    public static IPropsSrc applyMaterials(IGeomNode geom, IPropsSrc propsSrc, IMaterial[] mats) {
        int ucount;
        int numPrims;
        PropsBuilder propsBuilder = new PropsBuilder();
        int n = numPrims = mats.length != 1 ? mats.length : geom.getNumPrims(7);
        assert (numPrims == geom.getNumPrims(7));
        for (int offset = 0; offset < numPrims; offset += ucount) {
            IPrimProps pprops = propsSrc.get(offset);
            ucount = propsSrc.getUniformCount(offset, numPrims - offset);
            if (mats.length == 1) {
                if (pprops.getMaterial() != mats[0]) {
                    pprops = pprops.setMaterial(mats[0]);
                }
                propsBuilder.add(pprops, ucount);
                continue;
            }
            int end = offset + ucount;
            for (int m = offset; m < end; ++m) {
                IPrimProps newPProps = pprops.getMaterial() != mats[m] ? pprops.setMaterial(mats[m]) : pprops;
                propsBuilder.add(newPProps);
            }
        }
        assert (propsBuilder.size() == numPrims);
        return propsBuilder.finalizeProps();
    }

    public static <ObjT extends IMerlinObj> DisplayProp<Color> defineColorProp(PropertyDefs<ObjT> defs, Function<? super ObjT, IGeomNode> getGeom, Function<? super ObjT, IPropsSrc> getPropsSrc, TriConsumer<? super ObjT, ? super IGeomNode, IPropsSrc> setDisplayGeom, PropertyDefsFramework.IRestoreProp<VentusData, ObjT, Color, DisplayProp<Color>> restoreDisplayProps) {
        DisplayProp<Color> colorProp = defs.storeAsPlainOldData(VentusData.COLOR).attrGetter((prop, src) -> {
            IGeomNode geom = (IGeomNode)getGeom.apply((Object)src);
            IPropsSrc propsSrc = (IPropsSrc)getPropsSrc.apply((Object)src);
            int numPrims = geom.getNumPrims(7);
            if (numPrims == 0) {
                return Color.WHITE;
            }
            Color c = null;
            for (int offset = 0; offset < numPrims; offset += propsSrc.getUniformCount(offset, numPrims - offset)) {
                Color pc = propsSrc.get(offset).getColor();
                pc = new Color(pc.getRed(), pc.getGreen(), pc.getBlue(), 255);
                if (c == null) {
                    c = pc;
                    continue;
                }
                if (c.equals(pc)) continue;
                return new NonUniformColor(c, propsSrc);
            }
            return c;
        }, Stream.empty()).attrSetter((prop, src, c) -> {
            int uniformCount;
            IGeomNode geom = (IGeomNode)getGeom.apply((Object)src);
            IPropsSrc propsSrc = (IPropsSrc)getPropsSrc.apply((Object)src);
            if (c instanceof NonUniformColor) {
                NonUniformColor nc = (NonUniformColor)c;
                setDisplayGeom.accept((Object)src, geom, nc.originalProps);
                return;
            }
            PropsBuilder props = new PropsBuilder();
            int numPrims = geom.getNumPrims(7);
            for (int offset = 0; offset < numPrims; offset += uniformCount) {
                Color newColor;
                IPrimProps pprops = propsSrc.get(offset);
                uniformCount = propsSrc.getUniformCount(offset, numPrims - offset);
                Color oldColor = pprops.getColor();
                int alpha = oldColor.getAlpha();
                Color color = newColor = c == null ? new Color(255, 255, 255, alpha) : new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
                if (!newColor.equals(oldColor)) {
                    pprops = pprops.setColor(ColorPool.get(newColor));
                }
                props.add(pprops, uniformCount);
            }
            setDisplayGeom.accept((Object)src, geom, props.finalizeProps());
            src.changedEvt(prop);
        }, null).attrSurrogateEquals(null).attrUndoPropRestore(restoreDisplayProps).attrFinish();
        defs.storeAsReadOnly(VentusData.SEARCH_COLOR).attrGetter(obj -> obj.get(VentusData.COLOR), VentusData.COLOR).attrFinish();
        return colorProp;
    }

    public static <ObjT extends IMerlinObj> DisplayProp<IOpacity> defineOpacityProp(PropertyDefs<ObjT> defs, Function<? super ObjT, IGeomNode> getGeom, Function<? super ObjT, IPropsSrc> getPropsSrc, TriConsumer<? super ObjT, ? super IGeomNode, IPropsSrc> setDisplayGeom, PropertyDefsFramework.IRestoreProp<VentusData, ObjT, IOpacity, DisplayProp<IOpacity>> restoreDisplayProps) {
        return defs.storeAsPlainOldData(VentusData.OPACITY).attrGetter((prop, src) -> {
            IGeomNode geom = (IGeomNode)getGeom.apply((Object)src);
            IPropsSrc propsSrc = (IPropsSrc)getPropsSrc.apply((Object)src);
            int numPrims = geom.getNumPrims(7);
            if (numPrims == 0) {
                return new Opacity(0.0f);
            }
            Float alpha = null;
            for (int offset = 0; offset < numPrims; offset += propsSrc.getUniformCount(offset, numPrims - offset)) {
                Color c = propsSrc.get(offset).getColor();
                float pAlpha = (float)c.getAlpha() / 255.0f;
                if (alpha == null) {
                    alpha = Float.valueOf(pAlpha);
                    continue;
                }
                if (theUtil.eq(alpha.floatValue(), pAlpha, 0.0)) continue;
                return new NonUniformOpacity(propsSrc);
            }
            return new Opacity(alpha.floatValue());
        }, Stream.empty()).attrSetter((prop, src, value) -> {
            IGeomNode geom = (IGeomNode)getGeom.apply((Object)src);
            IPropsSrc propsSrc = (IPropsSrc)getPropsSrc.apply((Object)src);
            if (value instanceof NonUniformOpacity) {
                NonUniformOpacity nuo = (NonUniformOpacity)value;
                setDisplayGeom.accept((Object)src, geom, nuo.originalProps);
            } else {
                int uniformCount;
                float val = value.getValue();
                int alpha = (int)(val * 255.0f);
                PropsBuilder props = new PropsBuilder();
                int numPrims = geom.getNumPrims(7);
                for (int offset = 0; offset < numPrims; offset += uniformCount) {
                    IPrimProps pprops = propsSrc.get(offset);
                    uniformCount = propsSrc.getUniformCount(offset, numPrims - offset);
                    Color c = pprops.getColor();
                    if (alpha != c.getAlpha()) {
                        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
                        pprops = pprops.setColor(ColorPool.get(c));
                    }
                    props.add(pprops, uniformCount);
                }
                setDisplayGeom.accept((Object)src, geom, props.finalizeProps());
                src.changedEvt(prop);
            }
        }, null).attrUndoPropRestore(restoreDisplayProps).attrSurrogateEquals(null).attrFinish();
    }

    public static IGeomNode finalizeTexCoords(IGeomNode geom, IPropsSrc props) {
        int numPrims = geom.getNumPrims(7);
        boolean needsTexCoords = IntStream.range(0, numPrims).mapToObj(i -> props.get(i).getMaterial()).filter(m -> m != null).anyMatch(m -> m.getAttributes().hasTexture());
        return GeomUtil.finalizeTexCoords(geom, needsTexCoords);
    }

    public static IGeomNode finalizeTexCoords(IGeomNode geom, IMaterial mat) {
        return GeomUtil.finalizeTexCoords(geom, mat != null && mat.getAttributes().hasTexture());
    }

    public static IGeomNode finalizeTexCoords(IGeomNode geom, boolean needsTexCoords) {
        if (!needsTexCoords) {
            return geom;
        }
        geom = geom.applyUVElements((uvset, ix, oldEl) -> oldEl == Elements.NO_UV ? DEFUV : oldEl);
        geom = geom.applyDefaultUVElements(DEFUV);
        return geom;
    }

    public static <SrcT extends IMerlinObj> DepCallback<VentusData, SrcT, IMaterial[], IMaterial> newMatDependency() {
        return Dependencies.newDependency(VentusData.MATERIAL, DLink.WEAK, IMaterial.class, (md, src, mats) -> Stream.of(mats), Predicates.alwaysTrue(), (md, src, mats, old, repl) -> {
            if (mats == null) {
                assert (false);
                return null;
            }
            assert (Sets.fromArrayIHS(mats).contains(old));
            mats = Arrays.copyOf(mats, ((IMaterial[])mats).length);
            Arrays.asList(mats).replaceAll(m -> m == old ? repl : m);
            if (((IMaterial[])mats).length > 1 && MerlinUtil.isUniform(mats, (m1, m2) -> m1 == m2)) {
                mats = Arrays.copyOf(mats, 1);
            }
            return mats;
        });
    }

    public static class FindResult {
        public final ISchematicRoom room;
        public final Vector3d faceNormal;
        public final Point3d p;
        public final IPrimElements elements;

        public FindResult(ISchematicRoom room, Vector3d faceNormal, Point3d p, IPrimElements elements) {
            this.room = room;
            this.faceNormal = faceNormal;
            this.p = p;
            this.elements = elements;
        }

        public Optional<ISchematicRoom.IWallComponent> getWall() {
            return RoomUtil.getWall(this.elements);
        }

        public Plane3d getPlane() {
            return new Plane3d(this.faceNormal, this.p);
        }
    }

    private static class NonUniformOpacity
    implements IOpacity {
        public final IPropsSrc originalProps;

        public NonUniformOpacity(IPropsSrc originalProps) {
            this.originalProps = originalProps;
        }

        @Override
        public float getValue() {
            return (float)this.originalProps.get(0).getColor().getAlpha() / 255.0f;
        }
    }

    private static class NonUniformColor
    extends Color {
        private static final long serialVersionUID = -4143879041991746149L;
        public final IPropsSrc originalProps;

        public NonUniformColor(Color subColor, IPropsSrc originalProps) {
            super(subColor.getRed(), subColor.getGreen(), subColor.getBlue(), subColor.getAlpha());
            this.originalProps = originalProps;
        }
    }

    public static class LocationHandle
    implements IHandle {
        private ACircleGeometry d_geom;
        private final GEOM_TYPE d_geomType;

        public LocationHandle(ACircleGeometry geom) {
            this(geom, GEOM_TYPE.POINT);
        }

        public LocationHandle(ACircleGeometry geom, GEOM_TYPE type) {
            this.d_geom = geom;
            this.d_geomType = type;
        }

        public boolean equals(Object obj) {
            return obj instanceof LocationHandle;
        }

        @Override
        public IGeomNode getGeom() {
            if (this.d_geomType.equals((Object)GEOM_TYPE.POINT)) {
                return GeomNodeUtil.newNode(new Point(this.d_geom.location));
            }
            if (this.d_geomType.equals((Object)GEOM_TYPE.AREA)) {
                return GeomNodeUtil.newNode(this.d_geom);
            }
            assert (false);
            return null;
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(ISchematicRoom.class, GeomType.FACE));
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public ACircleGeometry modify(IsectInfo constraintInfo, Point3d newLoc) throws ManipException {
            FindResult result = GeomUtil.findRoom(VentusApp.getApp().getData(), newLoc, 0, () -> {});
            if (result == null) {
                throw new ManipException();
            }
            this.d_geom = this.d_geom.getConstructedTransform(result.room, result.faceNormal, result.p, this.d_geom.radius);
            return this.d_geom;
        }

        @Override
        public ACircleGeometry end() {
            return this.d_geom;
        }

        public static enum GEOM_TYPE {
            POINT,
            AREA;

        }
    }

    public static class RadiusHandle
    implements IHandle {
        private ACircleGeometry d_geom;

        public RadiusHandle(ACircleGeometry geom) {
            this.d_geom = geom;
        }

        public boolean equals(Object obj) {
            return obj instanceof RadiusHandle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(ACircleGeometry.generateCircle(this.d_geom.location, this.d_geom.radius, this.d_geom.normal));
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return new PlanarConstraint(new Plane3d(this.d_geom.normal, this.d_geom.location));
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public ACircleGeometry modify(IsectInfo constraintInfo, Point3d newLoc) {
            double newRadius = newLoc.distance(this.d_geom.location);
            this.d_geom = this.d_geom.getConstructedTransform(this.d_geom.room, this.d_geom.normal, this.d_geom.location, newRadius);
            return this.d_geom;
        }

        @Override
        public ACircleGeometry end() {
            return this.d_geom;
        }
    }

    public static abstract class ACircleGeometry
    extends GeomGroup {
        private static final long serialVersionUID = 6462995199370786383L;
        public final ISchematicRoom room;
        public final Vector3d normal;
        public final Point3d location;
        public final double radius;

        public ACircleGeometry(ISchematicRoom room, Vector3d normal, Point3d location, double radius, IGeom ... additionalGeoms) {
            this(room, normal, location, radius, true, additionalGeoms);
        }

        public ACircleGeometry(ISchematicRoom room, Vector3d normal, Point3d location, double radius, boolean solid, IGeom ... additionalGeoms) {
            super(ACircleGeometry.generateGeoms(location, radius, normal, solid, additionalGeoms));
            this.room = room;
            this.location = location;
            this.normal = normal;
            this.radius = radius;
        }

        private static List<IGeom> generateGeoms(Point3d location, double radius, Vector3d normal, boolean solid, IGeom ... additionalGeom) {
            ArrayList<IGeom> geoms = new ArrayList<IGeom>();
            ShapeGeom cgeom = ACircleGeometry.generateCircle(location, radius, normal);
            geoms.add(cgeom);
            if (solid) {
                Area area = new Area(cgeom.shape);
                ShapeGeom ageom = new ShapeGeom((Shape)area, cgeom.lwXform);
                geoms.add(ageom);
            }
            Point pgeom = new Point(location);
            geoms.add(pgeom);
            geoms.addAll(Arrays.asList(additionalGeom));
            return geoms;
        }

        public static ShapeGeom generateCircle(Point3d location, double arriveRadius, Vector3d normal) {
            Plane3d plane = new Plane3d(normal, new Point3d(0.0, 0.0, 0.0));
            Ellipse2D.Double circle = ShapeUtil.newCircle(arriveRadius);
            Matrix4d xform = Util.translateMat(location.x, location.y, location.z);
            xform.mul(Util.getLocalToWorldXform(plane));
            return new ShapeGeom((Shape)circle, xform);
        }

        public static ShapeGeom generateOutline(Point3d location, double arriveRadius, Vector3d normal) {
            Plane3d plane = new Plane3d(normal, new Point3d(0.0, 0.0, 0.0));
            Arc2D.Double circle = ShapeUtil.newCircularArc(0.0, 0.0, arriveRadius, 0.0, Math.PI * 2, true);
            Matrix4d xform = Util.translateMat(location.x, location.y, location.z);
            xform.mul(Util.getLocalToWorldXform(plane));
            return new ShapeGeom((Shape)circle, xform);
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            Vector3d scaleVec = Util3D.xform(xform, new Vector3d(this.radius, 0.0, 0.0));
            double newRadius = scaleVec.length();
            Point3d newLoc = Util3D.xform(xform, this.location);
            FindResult result = GeomUtil.findRoom(VentusApp.getApp().getData(), newLoc, 1, () -> {});
            return this.constructTransformedGeom(result, newLoc, newRadius);
        }

        protected abstract IGeom constructTransformedGeom(FindResult var1, Point3d var2, double var3);

        @Override
        public abstract void generateManipHandles(Consumer<? super IHandle> var1);

        public abstract ACircleGeometry getConstructedTransform(ISchematicRoom var1, Vector3d var2, Point3d var3, double var4);
    }
}

