/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.zone;

import java.util.HashMap;
import java.util.Map;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.feature.comps.IPrjDataWriter;
import ventus.io.contamx.PrjData;

class ZoneConcentrationPrjDataWriterComp
implements IPrjDataWriter {
    ZoneConcentrationPrjDataWriterComp() {
    }

    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.AFTER_NORMAL;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        HashMap<Integer, PrjData.Species> contaminants = new HashMap<Integer, PrjData.Species>();
        for (Integer contaminant : prjData.contaminantsList) {
            contaminants.put(contaminant, prjData.findSpeciesNr(contaminant));
        }
        for (Integer contaminant : prjData.contaminantsList) {
            prjData.zoneConcentrationHeaders.add(((PrjData.Species)contaminants.get((Object)contaminant)).name);
        }
        for (PrjData.Zone zone : prjData.zoneList) {
            PrjData.ZoneConcentration concentration = new PrjData.ZoneConcentration();
            concentration.nr = zone.nr;
            for (Integer contaminant : prjData.contaminantsList) {
                concentration.concentrations.add(((PrjData.Species)contaminants.get((Object)contaminant)).ccdef);
            }
            prjData.zoneConcentrationList.add(concentration);
        }
        prjData.nn = prjData.nzone * prjData.nctm;
    }
}

