/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.windprofiles;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Observer;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.VentusData;
import ventus.data.value.APiecewiseFunction1d;
import ventus.feature.windprofiles.WindProfile;
import ventus.feature.windprofiles.WindProfileFunction1dEditor;
import ventus.gui.guiUtil;
import ventus.util.MerlinUtil;

public class WindProfileEditor
implements IEditor<WindProfile> {
    private final guiPanel d_panel;
    private final guiTextField d_nameField = new guiTextField();
    private final guiTextField d_descriptionField = new guiTextField();
    private final guiComboBox<WindProfile.CurveType> d_graphTypeCombo = guiUtil.newCombo(type -> type != null ? guiUtil.encodeToHtmlLabels(type.name, type.desc) : new Pair<String, String>(Intl.intl("<mixed>"), null), WindProfile.CurveType.values());
    private final WindProfileFunction1dEditor editor = new WindProfileFunction1dEditor(WindProfile.PROP_FUNDAMENTAL);

    public WindProfileEditor() {
        this.d_panel = new guiPanel(new MigLayout("fill, insets 0")){

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                int numRows = WindProfileEditor.this.editor.getRowCount();
                WindProfile.CurveType cur = WindProfileEditor.this.d_graphTypeCombo.getSelectedItem();
                if (numRows < cur.minPointsReq) {
                    String msg = String.format(Intl.intl("%1$s curve requires %2$s points."), cur.desc, cur.minPointsReq);
                    JOptionPane.showMessageDialog(this, msg, Intl.intl("Incomplete Entries"), 0);
                    return false;
                }
                ArrayList<Double> degreeList = WindProfileEditor.this.getDegreeList();
                if (cur == WindProfile.CurveType.TRIG && !MerlinUtil.containsAll(degreeList, 1.0E-6, 0.0, 90.0, 180.0, 270.0, 360.0)) {
                    JOptionPane.showMessageDialog(this, Intl.intl("Table must include all required angles: [0, 90, 180, 270, 360]"), Intl.intl("Incomplete Entries"), 0);
                    return false;
                }
                if (!MerlinUtil.containsAll(degreeList, 1.0E-6, 0.0, 360.0)) {
                    JOptionPane.showMessageDialog(this, Intl.intl("The data points should start with angle 0 and end with angle 360."), Intl.intl("Incomplete Entries"), 0);
                    return false;
                }
                if (!WindProfileEditor.this.checkForPeriodic()) {
                    JOptionPane.showMessageDialog(this, Intl.intl("Wind Profile data is not periodic."), Intl.intl("Errors in Table"), 0);
                    return false;
                }
                return true;
            }
        };
        guiPanel topSection = new guiPanel(new MigLayout("insets 0"));
        topSection.add((Component)new guiLabel(Intl.intl("Name:")), "growx");
        topSection.add((Component)this.d_nameField, "growx, wrap");
        topSection.add(new guiLabel(Intl.intl("Description:")));
        topSection.add(this.d_descriptionField);
        topSection.add((Component)new guiLabel(Intl.intl("Curve Fit:")), "gap 195");
        topSection.add(this.d_graphTypeCombo);
        this.d_panel.add((Component)topSection, "growx, wrap");
        guiPanel bottomSection = new guiPanel(new MigLayout("fill, insets 0"));
        bottomSection.add((Component)this.editor, "grow, span 2");
        this.d_panel.add((Component)bottomSection, "grow, push, span 2");
    }

    @Override
    public void init(WindProfile dataObj) {
        if (dataObj == null) {
            this.d_panel.setEnabled(false);
            this.d_panel.setModified(false);
            return;
        }
        this.d_graphTypeCombo.addActionListener(evt -> this.updateType((APiecewiseFunction1d)this.editor.getValue(), this.d_graphTypeCombo.getSelectedItem()));
        this.load(dataObj);
    }

    private void load(WindProfile dataObj) {
        this.d_nameField.setText(dataObj.getName());
        this.d_descriptionField.setText(dataObj.get(WindProfile.DESC));
        this.updateType(dataObj.get(WindProfile.FUNC).toPiecewise(Unit.ONE), dataObj.get(WindProfile.GRAPH_TYPE));
        this.d_graphTypeCombo.setSelectedItem(dataObj.get(WindProfile.GRAPH_TYPE));
        this.editor.resetSeries();
        this.d_panel.setEnabled(dataObj.get(WindProfile.IS_DEFAULT) == false);
        this.d_panel.setModified(false);
    }

    private void updateType(APiecewiseFunction1d func, WindProfile.CurveType cur) {
        if (cur == WindProfile.CurveType.LINEAR) {
            this.editor.loadValueLinear(func);
        } else if (cur == WindProfile.CurveType.CUBIC) {
            this.editor.loadValueCubicSpline(func);
        } else if (cur == WindProfile.CurveType.TRIG) {
            this.editor.loadValueTrigonometric(func);
        } else assert (false) : "Unknown curve type: " + String.valueOf(cur);
    }

    @Override
    public boolean isModified() {
        return this.d_panel.isModified();
    }

    @Override
    public WindProfile commit(final WindProfile dataObj) {
        this.d_panel.setModified(false);
        if (dataObj == null) {
            return null;
        }
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(VentusApp app, VentusData md) {
                Undo.begin(Intl.intl("Edit Wind Profiles"));
                try (VentusData.WriteLock lock = md.lockWrite();){
                    Undo.insertUndoEntry_restore(md, dataObj);
                    dataObj.setName(WindProfileEditor.this.d_nameField.getText());
                    dataObj.set(WindProfile.DESC, WindProfileEditor.this.d_descriptionField.getText());
                    dataObj.set(WindProfile.GRAPH_TYPE, WindProfileEditor.this.d_graphTypeCombo.getSelectedItem());
                    dataObj.set(WindProfile.FUNC, WindProfileEditor.this.editor.saveValue(null));
                    Undo.end(md);
                    WindProfileEditor.this.load(dataObj);
                }
            }
        };
        UIHook.run((Component)this.d_panel, "WindProfileEditor.commit", op, 0);
        return dataObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this.d_panel;
    }

    @Override
    public void addObserver(Observer o) {
        this.d_panel.addObserver(o);
    }

    @Override
    public void removeObserver(Observer o) {
        this.d_panel.removeObserver(o);
    }

    private ArrayList<Double> getDegreeList() {
        APiecewiseFunction1d func = this.editor.saveValue(null);
        ArrayList<Double> degreeList = new ArrayList<Double>(func.getInput().length);
        for (int i = 0; i < func.getInput().length; ++i) {
            degreeList.add(func.getInput()[i].x.getValue(Unit.ONE));
        }
        return degreeList;
    }

    private boolean checkForPeriodic() {
        double deg360Value;
        APiecewiseFunction1d func = this.editor.saveValue(null);
        int length = func.getInput().length;
        assert (length > 0);
        double degZeroValue = func.getInput()[0].y.getValue(Unit.ONE);
        return Math.abs(degZeroValue - (deg360Value = func.getInput()[length - 1].y.getValue(Unit.ONE))) < 1.0E-6;
    }
}

