/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.tags;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.framework.UndoFramework;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.actions.Undo;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.feature.props.PropertyDefs;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagFeature;
import ventus.feature.tags.TagsRoot;
import ventus.util.Dependencies;

public class TagsUtil {
    private static final RejectReservedPrefixes REJECT_RESERVED = new RejectReservedPrefixes("vt_");
    private static final DepCallback TAG_CALLBACK = TagsUtil.newTagCallback(VentusData.TAGS);

    public static Set<String> tagsAsStrings(Set<Tag> tags) {
        return tags.stream().map(tag -> tag.getName()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Tag> getExistingTags(Set<String> tagIds, VentusData vd, Consumer<String> unconverted) {
        return TagsUtil.getTagsCustom(tagIds, vd, (existingTags, lowTagStr) -> {
            Tag existing = (Tag)existingTags.get(lowTagStr);
            if (existing == null) {
                unconverted.accept((String)lowTagStr);
            }
            return existing;
        });
    }

    public static LinkedHashSet<Tag> parse(String text, boolean allowEmpty, boolean allowPredefined, Set<String> predefinedTags) throws ParseException {
        List tags = Stream.of(text.split("[ ,;]+")).filter(Predicate.not(String::isBlank)).map(s -> new Tag(s.toLowerCase(Locale.ROOT))).collect(Collectors.toCollection(ArrayList::new));
        if (!allowEmpty && tags.isEmpty()) {
            throw new ParseException(Intl.intl("At least one tag must be specified."), 0);
        }
        return new LinkedHashSet<Tag>(tags);
    }

    public static String formatTags(Set<Tag> tags) {
        return TagsUtil.joinTags(" ", tags);
    }

    public static String joinTags(String delimeter, Set<Tag> tags) {
        return tags.stream().map(NamedMerlinObj::getName).collect(Collectors.joining(delimeter));
    }

    public static Set<Tag> getOrCreateTags(Set<String> tagIds, VentusData vd) {
        LinkedIdentityHashSet newTags = new LinkedIdentityHashSet();
        Set<Tag> result = TagsUtil.getTagsCustom(tagIds, vd, (existingTags, lowTagStr) -> {
            if (existingTags.containsKey(lowTagStr)) {
                return (Tag)existingTags.get(lowTagStr);
            }
            Tag newTag = new Tag((String)lowTagStr);
            newTags.add(newTag);
            return newTag;
        });
        if (!newTags.isEmpty()) {
            TagsRoot root = (TagsRoot)vd.getComponentData(TagFeature.GUID);
            Undo undo = Undo.global();
            Objects.requireNonNull(undo);
            UndoFramework.InsertOp op = new UndoFramework.InsertOp((UndoFramework)undo, (IDomainObject)root, newTags, root.getMembers().size());
            Undo.insertEntry(vd, op.perform());
        }
        return result;
    }

    private static Set<Tag> getTagsCustom(Set<String> tagIds, VentusData vd, BiFunction<Map<String, Tag>, String, Tag> convertTag) {
        TagsRoot root = (TagsRoot)vd.getComponentData(TagFeature.GUID);
        Map<String, Tag> existingTags = root.flatten(Tag.class).stream().collect(Collectors.toMap(tag -> tag.getName().toLowerCase(), tag -> tag));
        LinkedHashSet tags = tagIds.stream().map(String::toLowerCase).map(stag -> (Tag)convertTag.apply(existingTags, (String)stag)).filter(tag -> tag != null).collect(Collectors.toCollection(LinkedHashSet::new));
        return tags;
    }

    public static <T extends IMerlinObj> DepCallback<VentusData, T, Set<Tag>, Tag> newTagCallback(TypedProp<Set<Tag>> tagsProp) {
        return Dependencies.newDependencyInSet(tagsProp, DLink.WEAK, Tag.class, Predicates.alwaysTrue());
    }

    public static <T extends IMerlinObj> DepCallback<VentusData, T, Set<Tag>, Tag> newTagCallback() {
        return TAG_CALLBACK;
    }

    public static <SrcT extends IMerlinObj> DisplayProp<Set<Tag>> newTagsProp(PropertyDefs<SrcT> set) {
        return set.storeAsPlainOldData(VentusData.TAGS).attrDependency(prop -> TagsUtil.newTagCallback(prop)).attrFinish();
    }

    private static final class RejectReservedPrefixes
    implements Predicate<Tag> {
        private final HashSet<String> reservedPrefixes = new HashSet();

        public RejectReservedPrefixes(String ... reservedPrefixes) {
            this.reservedPrefixes.addAll(Arrays.asList(reservedPrefixes));
        }

        @Override
        public boolean test(Tag tag) {
            String lower = tag.toString().toLowerCase(Locale.ROOT);
            return this.reservedPrefixes.stream().noneMatch(lower::startsWith);
        }

        public String toString() {
            return String.format(Intl.intl("Tags must not start with \"%s\"."), String.join((CharSequence)",", this.reservedPrefixes));
        }
    }
}

