/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.species;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropComparisons;
import ventus.feature.props.PropertyDefs;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;

public class Species
extends NamedMerlinObj
implements Serializable,
ISurrogate,
IDirectDependent<VentusData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<Species> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(Species.class, PropertyDefs.serializedOnly(obj -> obj.d_properties, obj -> {
        obj.d_properties = new PropertySet();
    }), NamedMerlinObj.PROP_TYPES);
    public static final DisplayProp<String> DESC = (DisplayProp)DisplayProps.build((Object)"Species.DESC", "", Intl.intl("Description"), Intl.intl("Species description.")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<String> DESCRIPTION = PROP_TYPES.storeDirectWrapper(VentusData.DESCRIPTION, DESC).attrFinish();
    public static final DisplayProp<Color> COLOR = (DisplayProp)DisplayProps.build((Object)"Species.COLOR", Color.class, Color.BLACK, Intl.intl("Color"), Intl.intl("Species color.")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Color> SEARCH_COLOR = PROP_TYPES.storeAsReadOnly(VentusData.SEARCH_COLOR).attrGetter(elem -> elem.get(COLOR), COLOR).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(PROP_TYPES);
    public static final DisplayProp<UnitDouble> MOLAR_MASS = (DisplayProp)DisplayProps.build((Object)"Species.MOLAR_MASS", new UnitDouble(1.0, SI.KILOGRAM.divide(SI.KILO(SI.MOLE))), Intl.intl("Molar Mass"), Intl.intl("Molar mass of the species."), 18).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(18)).attrFinish();
    public static final DisplayProp<UnitDouble> DIFFUSION_COEFFICIENT = (DisplayProp)DisplayProps.build((Object)"Species.DIFFUSION_COEFFICIENT", new UnitDouble(2.0E-5, SI.METER.pow(2).divide(SI.SECOND)), Intl.intl("Diffusion Coefficient"), Intl.intl("Diffusion coefficient of this species used in duct segments."), 19).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> SPECIFIC_HEAT = (DisplayProp)DisplayProps.build((Object)"Species.SPECIFIC_HEAT", new UnitDouble(1000.0, SI.JOULE.divide(SI.KILOGRAM.multiply(SI.KELVIN))), Intl.intl("Specific Heat"), Intl.intl("Specific heat of the species."), 20).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> MEAN_DIAMETER = (DisplayProp)DisplayProps.build((Object)"Species.MEAN_DIAMETER", new UnitDouble(0.0, SI.METER), Intl.intl("Mean Diameter"), Intl.intl("Mean particle diameter if this is a particulate species."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> EFFECTIVE_DENSITY = (DisplayProp)DisplayProps.build((Object)"Species.EFFECTIVE_DENSITY", new UnitDouble(0.0, SI.KILOGRAM.divide(SI.METER.pow(3))), Intl.intl("Effective Density"), Intl.intl("Effective density if this is a particulate species."), 22).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> DECAY_RATE = (DisplayProp)DisplayProps.build((Object)"Species.DECAY_RATE", new UnitDouble(0.0, Unit.ONE.divide(SI.SECOND)), Intl.intl("Decay Rate"), Intl.intl("Exponential decay rate, based on half-life of a radioactive species."), 23).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> UVGI_SUSCEPTIBILITY_CONSTANT = (DisplayProp)DisplayProps.build((Object)"Species.UVGI_SUSCEPTIBILITY_CONSTANT", new UnitDouble(0.0, SI.METER.pow(2).divide(SI.JOULE)), Intl.intl("UVGI Susceptibility Constant"), Intl.intl("Rate used to determine UVGI filter effectiveness."), 24).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> DEFAULT_CONCENTRATION = (DisplayProp)DisplayProps.build((Object)"Species.DEFAULT_CONCENTRATION", new UnitDouble(0.0, SI.KILOGRAM.divide(SI.KILOGRAM)), Intl.intl("Default Concentration"), Intl.intl("Default initial concentration in each zone in the model."), 25).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(25)).attrFinish();
    public static final DisplayProp<TraceContaminant> TRACE_CONTAMINANT = (DisplayProp)DisplayProps.build((Object)"Species.TRACE_CONTAMINANT", TraceContaminant.class, TraceContaminant.TRACE, Intl.intl("Trace Contaminant"), Intl.intl("Determines whether this species is considered a component of the air.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(TraceContaminant.values())).attrFinish();
    private PropertySet d_properties = new PropertySet();

    public Species(String name) {
        this(name, theUtil.newRandomSatColor());
    }

    public Species(String name, Color color) {
        super(name);
        this.d_properties.set(COLOR, color);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
    }

    public PropertyDefs<Species> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public Species clone() {
        return (Species)super.clone();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public static enum TraceContaminant implements ILabeled
    {
        NON_TRACE(Intl.intl("Non-Trace"), Intl.intl("The species is considered a component of the air.")),
        TRACE(Intl.intl("Trace"), Intl.intl("The species is considered separate from the air."));

        public final String name;
        public final String desc;

        private TraceContaminant(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        public String toString() {
            return this.name;
        }
    }
}

