/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.Box;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.ComponentSizeFixer;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.sourcesink.SourceSinkElement;
import ventus.feature.species.Species;
import ventus.gui.ManagerDlg;
import ventus.gui.MerlinComboBox;
import ventus.gui.guiUtil;
import ventus.unitsystem.UnitSystem;

public class SourceSinkElementEditor
extends guiPanel
implements IEditor<SourceSinkElement> {
    private static final long serialVersionUID = 1L;
    private final Bindings d_bindings = new Bindings();
    private final List<Consumer<SourceSinkElement>> d_onInit = new ArrayList<Consumer<SourceSinkElement>>();

    public SourceSinkElementEditor(VentusData vd, UnitSystem us) {
        super(new MigLayout("insets 0", "[left][grow][right]"));
        guiTextField name = this.d_bindings.bind(SourceSinkElement.NAME, new guiTextField());
        guiTextField desc = this.d_bindings.bind(SourceSinkElement.DESC, new guiTextField());
        ColorButton color = this.d_bindings.bind(SourceSinkElement.COLOR, guiUtil.newColorButton());
        guiComboBox<SourceSinkElement.SourceSinkModel> model = guiUtil.newCombo(m -> new Pair<String, String>(m.name, m.desc), SourceSinkElement.SourceSinkModel.values());
        this.d_bindings.bind(model, new Binding<SourceSinkElement>(data -> model.setSelectedItem(data.get(SourceSinkElement.MODEL)), data -> data.set(SourceSinkElement.MODEL, (SourceSinkElement.SourceSinkModel)model.getSelectedItem())));
        SourceSinkElementEditor.addRow((guiPanel)this, SourceSinkElement.NAME.name, Intl.intl("Unique source/sink element name."), name, "growx, wrap");
        SourceSinkElementEditor.addRow((guiPanel)this, SourceSinkElement.DESC, desc, "width pref*2.5, growx, wrap");
        SourceSinkElementEditor.addRow((guiPanel)this, SourceSinkElement.COLOR, color, "sg 1, wrap");
        SourceSinkElementEditor.addRow((guiPanel)this, SourceSinkElement.MODEL, model, "sg 1, wrap");
        this.add((Component)new guiSeparator(), "growx, span, wrap");
        MerlinComboBox species = new MerlinComboBox(vd, Species.class, (IMerlinObj[])new Species[0]);
        this.d_bindings.bind(model, new Binding<SourceSinkElement>(data -> species.setSelectedItem(data.get(SourceSinkElement.SPECIES)), data -> data.set(SourceSinkElement.SPECIES, (Species)species.getSelectedItem())));
        SourceSinkElementEditor.addRow((guiPanel)this, SourceSinkElement.SPECIES, species, "sg 1, wrap");
        guiPanel cardsPanel = new guiPanel(new CardLayout());
        cardsPanel.add((Component)this.createCardConstantCoefficient(us), SourceSinkElement.SourceSinkModel.CONSTANT_COEFFICIENT.toString());
        this.add((Component)cardsPanel, "grow, span, wrap");
        model.addItemListener(evt -> {
            if (evt.getStateChange() == 1) {
                CardLayout cards = (CardLayout)cardsPanel.getLayout();
                cards.show(cardsPanel, evt.getItem().toString());
            }
        });
        ComponentSizeFixer.fromExistingContainer(this).setAllPreferredWidthToMax();
    }

    private guiPanel createCardConstantCoefficient(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        guiComboBox<SourceSinkElement.GenRateUnit> rateUnit = guiUtil.newCombo(unit -> new Pair<String, String>(unit.name, unit.desc), SourceSinkElement.GenRateUnit.values());
        ValueField<UnitDouble> generationRateMass = ValueFields.udFld(DoubleVR.ge(0.0), us.getMassRate());
        ValueField<UnitDouble> removalRateMass = ValueFields.udFld(DoubleVR.ge(0.0), us.getMassRate());
        ValueField<UnitDouble> generationRateVolume = ValueFields.udFld(DoubleVR.ge(0.0), us.getVolume().divide(us.getTime()));
        ValueField<UnitDouble> removalRateVolume = ValueFields.udFld(DoubleVR.ge(0.0), us.getVolume().divide(us.getTime()));
        guiPanel unitCardsPanel = new guiPanel(new CardLayout());
        guiPanel massCard = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        SourceSinkElementEditor.addRow(massCard, SourceSinkElement.GENERATION_RATE_MASS, generationRateMass, new String[0]);
        SourceSinkElementEditor.addRow(massCard, SourceSinkElement.REMOVAL_RATE_MASS, removalRateMass, new String[0]);
        guiPanel volumeCard = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        SourceSinkElementEditor.addRow(volumeCard, SourceSinkElement.GENERATION_RATE_VOLUME, generationRateVolume, new String[0]);
        SourceSinkElementEditor.addRow(volumeCard, SourceSinkElement.REMOVAL_RATE_VOLUME, removalRateVolume, new String[0]);
        unitCardsPanel.add((Component)massCard, SourceSinkElement.GenRateUnit.MASS_RATE.toString());
        unitCardsPanel.add((Component)volumeCard, SourceSinkElement.GenRateUnit.VOLUME_RATE.toString());
        rateUnit.addItemListener(evt -> {
            if (evt.getStateChange() == 1) {
                CardLayout cards = (CardLayout)unitCardsPanel.getLayout();
                cards.show(unitCardsPanel, evt.getItem().toString());
            }
        });
        this.d_bindings.bind(rateUnit, new Binding<SourceSinkElement>(data -> {
            SourceSinkElement.GenRateUnit unit = data.get(SourceSinkElement.GEN_RATE_UNIT);
            rateUnit.setSelectedItem(unit);
            switch (unit) {
                case MASS_RATE: {
                    generationRateMass.setValue(data.get(SourceSinkElement.GENERATION_RATE_MASS));
                    removalRateMass.setValue(data.get(SourceSinkElement.REMOVAL_RATE_MASS));
                    generationRateVolume.setValue(new UnitDouble(0.0, SourceSinkElement.GenRateUnit.VOLUME_RATE.defaultUnit));
                    removalRateVolume.setValue(new UnitDouble(0.0, SourceSinkElement.GenRateUnit.VOLUME_RATE.defaultUnit));
                    break;
                }
                case VOLUME_RATE: {
                    generationRateMass.setValue(new UnitDouble(0.0, SourceSinkElement.GenRateUnit.MASS_RATE.defaultUnit));
                    removalRateMass.setValue(new UnitDouble(0.0, SourceSinkElement.GenRateUnit.MASS_RATE.defaultUnit));
                    generationRateVolume.setValue(data.get(SourceSinkElement.GENERATION_RATE_VOLUME));
                    removalRateVolume.setValue(data.get(SourceSinkElement.REMOVAL_RATE_VOLUME));
                }
            }
        }, data -> {
            SourceSinkElement.GenRateUnit unit = (SourceSinkElement.GenRateUnit)rateUnit.getSelectedItem();
            data.set(SourceSinkElement.GEN_RATE_UNIT, unit);
            switch (unit) {
                case MASS_RATE: {
                    data.set(SourceSinkElement.GENERATION_RATE_MASS, (UnitDouble)generationRateMass.getValue());
                    data.set(SourceSinkElement.REMOVAL_RATE_MASS, (UnitDouble)removalRateMass.getValue());
                    break;
                }
                case VOLUME_RATE: {
                    data.set(SourceSinkElement.GENERATION_RATE_VOLUME, (UnitDouble)generationRateVolume.getValue());
                    data.set(SourceSinkElement.REMOVAL_RATE_VOLUME, (UnitDouble)removalRateVolume.getValue());
                }
            }
        }));
        SourceSinkElementEditor.addRow(card, SourceSinkElement.GEN_RATE_UNIT, rateUnit, new String[0]);
        card.add((Component)unitCardsPanel, "grow, span, wrap");
        return card;
    }

    private static List<Component> addRow(guiPanel migPanel, IDisplayProp<?> prop, Component comp, String ... compConstraints) {
        return SourceSinkElementEditor.addRow(migPanel, prop.getDisplayName(), prop.getDisplayDesc(), comp, compConstraints);
    }

    private static List<Component> addRow(guiPanel migPanel, String intl, String tooltip, Component comp, String ... compConstraints) {
        ArrayList<Component> comps = new ArrayList<Component>();
        guiLabel label = guiUtil.lblPropHtml(intl, tooltip);
        comps.add(label);
        migPanel.add(label);
        Component glue = Box.createGlue();
        comps.add(glue);
        migPanel.add(glue, "");
        comps.add(comp);
        if (compConstraints.length > 0) {
            migPanel.add(comp, String.join((CharSequence)", ", compConstraints));
        } else {
            migPanel.add(comp, "wrap");
        }
        return comps;
    }

    @Override
    public void init(SourceSinkElement dataObj) {
        ManagerDlg.defaultInit(this, dataObj, obj -> {
            this.d_bindings.load(dataObj);
            this.d_onInit.forEach(handler -> handler.accept(dataObj));
            this.setEnabled(dataObj != null);
        });
    }

    @Override
    public SourceSinkElement commit(SourceSinkElement dataObj) {
        return ManagerDlg.defaultCommit(this, dataObj, Intl.intl("Edit Source/Sink Element"), "SourceSinkElementEditor.commit", obj -> this.d_bindings.store(dataObj));
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    private static class Bindings {
        private final Map<Component, Binding<SourceSinkElement>> d_bindings = new HashMap<Component, Binding<SourceSinkElement>>();

        public void load(SourceSinkElement dataObj) {
            for (Binding<SourceSinkElement> binding : this.d_bindings.values()) {
                binding.updateComp.accept(dataObj);
            }
        }

        public void store(SourceSinkElement dataObj) {
            for (Map.Entry<Component, Binding<SourceSinkElement>> entry : this.d_bindings.entrySet()) {
                Component comp = entry.getKey();
                if (!comp.isShowing() || !comp.isEnabled()) continue;
                entry.getValue().updateData.accept(dataObj);
            }
        }

        public <F extends Component> F bind(F comp, Binding binding) {
            this.d_bindings.put(comp, binding);
            return comp;
        }

        public <T, F extends Component> F bind(TypedProp<T> prop, F fld) {
            F f = fld;
            Objects.requireNonNull(f);
            F f2 = f;
            int n = 0;
            Binding<SourceSinkElement> bindObj = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{guiTextField.class, ValueField.class, ColorButton.class}, f2, n)) {
                case 0 -> {
                    guiTextField textField = (guiTextField)f2;
                    yield new Binding<SourceSinkElement>(data -> textField.setValue((String)data.get(prop)), data -> data.set(prop, textField.getValue()));
                }
                case 1 -> {
                    ValueField valField = (ValueField)f2;
                    yield new Binding<SourceSinkElement>(data -> valField.setValue((UnitDouble)data.get(prop)), data -> data.set(prop, valField.getValue()));
                }
                case 2 -> {
                    ColorButton colorButton = (ColorButton)f2;
                    yield new Binding<SourceSinkElement>(data -> colorButton.setColor((Color)data.get(prop)), data -> data.set(prop, colorButton.getColor()));
                }
                default -> throw new IllegalArgumentException(fld.getClass().getName() + " not supported");
            };
            return this.bind(fld, bindObj);
        }
    }

    private static class Binding<T> {
        public final Consumer<T> updateComp;
        public final Consumer<T> updateData;

        public Binding(Consumer<T> updateComp, Consumer<T> updateData) {
            this.updateComp = updateComp;
            this.updateData = updateData;
        }
    }
}

