/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import thunderheadeng.animate.DefaultFrameSrc;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.IAnimator;
import thunderheadeng.animate.IFrameSrc;
import thunderheadeng.animate.InterpInfo;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.VentusApp;
import ventus.feature.comps.IFeatureAnimator;
import ventus.feature.results.DataNode;
import ventus.feature.results.ResultsDataComp;

public class SegmentDataNodeAnimator
implements IFeatureAnimator,
IEventObserver,
IAnimator {
    private IFrameSrc<DataNodeFrame> d_frameSrc = new DefaultFrameSrc<DataNodeFrame>();
    private final Set<DataNode.SegmentVisLeaf> d_dataLeaves = new LinkedIdentityHashSet<DataNode.SegmentVisLeaf>();

    @Override
    public void update(Events events) {
        IEventRecord<DataNode.SegmentVisLeaf> leafRecords = events.getEvents(DataNode.SegmentVisLeaf.class, new Class[0]);
        if (leafRecords.hasAddedObjs()) {
            Collection<DataNode.SegmentVisLeaf> visLeaves = ((DataNode.ResultsRoot)VentusApp.getAppData().getComponentData(ResultsDataComp.GUID)).flatten(DataNode.SegmentVisLeaf.class);
            this.d_dataLeaves.addAll(visLeaves);
            this.d_frameSrc = this.createFrameSrc(visLeaves);
            EventQueue.invokeLater(() -> events.changed(VentusApp.getAppData(), ANIMATION_CHANGED));
        }
        if (events.getEvents(DataNode.SegmentVisLeaf.class, new Class[0]).hasRemovedObjs()) {
            this.d_dataLeaves.removeAll(leafRecords.getRemovedObjs());
            EventQueue.invokeLater(() -> events.changed(VentusApp.getAppData(), ANIMATION_CHANGED));
        }
    }

    private IFrameSrc<DataNodeFrame> createFrameSrc(Collection<DataNode.SegmentVisLeaf> leaves) {
        DefaultFrameSrc<DataNodeFrame> frameSrc = new DefaultFrameSrc<DataNodeFrame>();
        for (DataNode.SegmentVisLeaf leaf : leaves) {
            int i = 0;
            while (i < leaf.getTimes().length) {
                int currFrame = i++;
                frameSrc.computeFrame(leaf.getTimes()[currFrame], (time, oldFrame) -> {
                    DataNodeFrame frame = oldFrame == null ? new DataNodeFrame() : oldFrame;
                    frame.add(leaf, new FrameData(leaf.getPressures()[currFrame], leaf.getFlows()[currFrame], leaf.getFlowDensities()[currFrame]));
                    return frame;
                });
            }
        }
        return frameSrc;
    }

    @Override
    public boolean update(IAnimSession session) {
        VentusApp.getAppData().pauseUpdates();
        double time = session.get(IAnimSession.TIME);
        InterpInfo<DataNodeFrame> ii = this.d_frameSrc.getFrames(time);
        for (DataNode.SegmentVisLeaf leaf : this.d_dataLeaves) {
            FrameData frame1Data = ii.frame1().getData(leaf);
            FrameData frame2Data = ii.frame2().getData(leaf);
            leaf.setAnimationData(frame1Data.dp, theUtil.lerp(frame1Data.dp, frame2Data.dp, ii.interpT()), frame1Data.flow, theUtil.lerp(frame1Data.flow, frame2Data.flow, ii.interpT()), frame1Data.flowDensity);
        }
        VentusApp.getAppData().resumeUpdates();
        return true;
    }

    @Override
    public Pair<Double, Double> getTimeRange() {
        if (this.d_dataLeaves.isEmpty()) {
            return new Pair<Double, Double>(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        }
        return this.d_frameSrc.getTimeRange();
    }

    private static class DataNodeFrame {
        private final Map<DataNode.SegmentVisLeaf, FrameData> d_vals = new IdentityHashMap<DataNode.SegmentVisLeaf, FrameData>();

        private DataNodeFrame() {
        }

        public FrameData getData(DataNode.SegmentVisLeaf leaf) {
            return this.d_vals.get(leaf);
        }

        public void add(DataNode.SegmentVisLeaf leaf, FrameData val) {
            this.d_vals.put(leaf, val);
        }
    }

    private record FrameData(double dp, double flow, double flowDensity) {
    }
}

