/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.units.UnitDouble;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.feature.comps.ItemStatusInfoProvider;
import ventus.feature.results.DataNode;
import ventus.feature.results.ResultsDataComp;

class ResultsItemStatusInfoProvider
implements ItemStatusInfoProvider {
    ResultsItemStatusInfoProvider() {
    }

    @Override
    public Map<Object, String> getInfo(VentusData data, Collection<IMerlinObj> objs) {
        DataNode.ResultsRoot results = (DataNode.ResultsRoot)data.getComponentData(ResultsDataComp.GUID);
        List<DisplayProp<UnitDouble>> testProps = List.of(DataNode.VisLeaf.FLOW0, DataNode.ZoneVisLeaf.TEMPERATURE);
        Collection mappedObjs = objs.stream().map(obj -> {
            boolean hasResultsData = testProps.stream().anyMatch(testProp -> obj.getWithDetails(testProp).isSupported());
            if (hasResultsData) {
                return List.of(obj);
            }
            Collection<DataNode.VisLeaf> fpInput = results.getLeavesForFlowpath(obj);
            if (!fpInput.isEmpty()) {
                return fpInput;
            }
            Collection<DataNode.ZoneVisLeaf> zoneInput = results.getLeavesForZone(obj);
            if (!zoneInput.isEmpty()) {
                return zoneInput;
            }
            return Collections.emptyList();
        }).flatMap(coll -> coll.stream()).filter(obj -> obj != null).map(obj -> (IMerlinObj)obj).collect(Collectors.toList());
        String name = ItemStatusInfoProvider.getPropValue(NamedMerlinObj.NAME, mappedObjs);
        String rslt = ItemStatusInfoProvider.getMulti(List.of(DataNode.VisLeaf.DP, DataNode.VisLeaf.FLOW0, DataNode.VisLeaf.FLOW1, DataNode.JunctionVisLeaf.VELOCITY, DataNode.ZoneVisLeaf.TEMPERATURE, DataNode.ZoneVisLeaf.PRESSURE, DataNode.ZoneVisLeaf.DENSITY), mappedObjs);
        return Map.of(ItemStatusInfoProvider.NAME, name, ItemStatusInfoProvider.RESULTS, rslt);
    }
}

