/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.awt.Font;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.UIManager;
import thunderheadeng.util.GroupedSequence;
import ventus.EntryPoint;
import ventus.EntryPointHelper;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.VentusData;
import ventus.feature.CompositeFeatureGuid;
import ventus.feature.comps.IDataModel;
import ventus.feature.results.DataNode;
import ventus.gui.guiUtil;

public class ResultsDataComp
implements IDataModel {
    static final Icon icon_wind = guiUtil.loadIconSvg(ResultsDataComp.class.getResource("icons/wind.svg"), 16);
    static final Icon icon_vectorBezier2 = guiUtil.loadIconSvg(ResultsDataComp.class.getResource("icons/vector-bezier-2.svg"), 16);
    static final Icon icon_chartInfographic = guiUtil.loadIconSvg(ResultsDataComp.class.getResource("icons/chart-infographic.svg"), 16);
    static final Icon icon_fileAnalytics = guiUtil.loadIconSvg(ResultsDataComp.class.getResource("icons/file-analytics.svg"), 16);
    static final Icon icon_fileText = guiUtil.loadIconSvg(ResultsDataComp.class.getResource("icons/file-text.svg"), 16);
    public static final CompositeFeatureGuid<DataNode.ResultsRoot, DataNode> GUID = new CompositeFeatureGuid<DataNode.ResultsRoot, DataNode>("results.data", DataNode.ResultsRoot.class, DataNode.class);
    static final int SEQ_IX = 103;

    @Override
    public void init(VentusData md) {
        md.setComponentData(GUID, new DataNode.ResultsRoot());
    }

    @Override
    public void reset(VentusData md) {
        ((DataNode.ResultsRoot)md.getComponentData(GUID)).clear();
    }

    @Override
    public void loadFrom(VentusData src, VentusData dest) {
        DataNode.ResultsRoot srcComp = (DataNode.ResultsRoot)src.getComponentData(GUID);
        DataNode.ResultsRoot destComp = (DataNode.ResultsRoot)dest.getComponentData(GUID);
        destComp.restoreFrom(srcComp);
        dest.replaceInSel(srcComp, destComp);
        assert (destComp == dest.getComponentData(GUID));
    }

    @Override
    public void addTreeRoots(VentusData md, GroupedSequence roots) {
        roots.add(103, md.getComponentData(GUID));
    }

    @Override
    public void registerEntryPointData() {
        EntryPointHelper.groupEP(GUID, DataNode.ResultsRoot.class, DataNode.ResultsRoot.PROP_TYPES, icon_chartInfographic, Intl.intl("Results")).register();
        EntryPointHelper.objectEP(GUID, DataNode.MergedData.class, DataNode.MergedData.PROP_TYPES, icon_fileAnalytics, Intl.intl("Results - Merged Data")).register();
        EntryPointHelper<DataNode.SimulationRoot> simRootEp = EntryPointHelper.groupEP(GUID, DataNode.SimulationRoot.class, DataNode.SimulationRoot.PROP_TYPES, null, Intl.intl("Results - Simulation"));
        simRootEp.getBaseFont = ResultsDataComp.getRootBaseFont();
        simRootEp.register();
        EntryPointHelper.objectEP(GUID, DataNode.XLogData.class, DataNode.XLogData.PROP_TYPES, icon_fileText, Intl.intl("Results - Log Data")).register();
        EntryPointHelper.objectEP(GUID, DataNode.TextData.class, DataNode.TextData.PROP_TYPES, icon_fileText, Intl.intl("Results - Raw Data")).register();
        EntryPointHelper<DataNode.VisRoot> visRootEp = EntryPointHelper.groupEP(GUID, DataNode.VisRoot.class, DataNode.VisRoot.PROP_TYPES, null, Intl.intl("Results - Path Data Group"));
        visRootEp.getBaseFont = ResultsDataComp.getRootBaseFont();
        visRootEp.register();
        EntryPointHelper.objectEP(GUID, DataNode.VisLeaf.class, DataNode.VisLeaf.PROP_TYPES, null, Intl.intl("Results - Path Data")).register();
        EntryPointHelper.groupEP(GUID, DataNode.ZoneVisRoot.class, DataNode.ZoneVisRoot.PROP_TYPES, null, Intl.intl("Results - Zone Data Group")).register();
        EntryPointHelper.objectEP(GUID, DataNode.ZoneVisLeaf.class, DataNode.ZoneVisLeaf.PROP_TYPES, null, Intl.intl("Results - Zone Data")).register();
        EntryPointHelper.groupEP(GUID, DataNode.DuctVisRoot.class, DataNode.DuctVisRoot.PROP_TYPES, null, Intl.intl("Results - Duct Data Group")).register();
        EntryPointHelper.objectEP(GUID, DataNode.JunctionVisLeaf.class, DataNode.JunctionVisLeaf.PROP_TYPES, null, Intl.intl("Results - Duct Junction Data")).register();
        EntryPointHelper.objectEP(GUID, DataNode.SegmentVisLeaf.class, DataNode.SegmentVisLeaf.PROP_TYPES, null, Intl.intl("Results - Duct Segment Data")).register();
    }

    private static <T extends Composite<?>> EntryPoint.Getter<T, Font> getRootBaseFont() {
        return (md, node) -> {
            Font plain = UIManager.getFont("Tree.font");
            Collection<DataNode.VisLeaf> visLeafNodes = node.flatten(DataNode.VisLeaf.class);
            if (visLeafNodes.stream().anyMatch(DataNode.VisLeaf::isVisible)) {
                return plain.deriveFont(3);
            }
            return plain;
        };
    }
}

