/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.ColorIcon;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import ventus.actions.CompElementActions;
import ventus.data.CompositePropertyUtil;
import ventus.data.IMerlinObj;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.results.DataNode;
import ventus.feature.results.NodeProps;
import ventus.gui.MerlinUDF;
import ventus.gui.guiUtil;
import ventus.mv.gui.PropConnections;
import ventus.mv.gui.SelectionEditorPanel;

public class JunctionSelectionRibbon
implements ISelectionRibbon {
    @Override
    public boolean isEnabled(Set<TypedProp<?>> shared, Set<TypedProp<?>> unshared) {
        return shared.contains(NodeProps.FLOW0) && shared.contains(NodeProps.VELOCITY) && !shared.contains(NodeProps.DP);
    }

    @Override
    public Collection<SelectionEditorPanel.EditorPanel> getSections() {
        int squareIconDim = 16;
        MerlinUDF flow0 = new MerlinUDF(17);
        flow0.setEditable(false);
        MerlinUDF velocity = new MerlinUDF(3);
        velocity.setEditable(false);
        Dimension prefSize = new Dimension((int)((double)flow0.getPreferredSize().width * 1.25), flow0.getPreferredSize().height);
        flow0.setPreferredSize(prefSize);
        velocity.setPreferredSize(prefSize);
        SelectionEditorPanel.EditorPanel panel = new SelectionEditorPanel.EditorPanel();
        this.bind(panel, NodeProps.FLOW0, flow0);
        this.bind(panel, NodeProps.VELOCITY, velocity);
        panel.setLayout(new MigLayout(""));
        ColorIcon flow0Icon = new ColorIcon(Color.GREEN, squareIconDim, squareIconDim, 1);
        ColorIcon velocityIcon = new ColorIcon(Color.ORANGE, squareIconDim, squareIconDim, 1);
        guiLabel flow0Label = guiUtil.lblProp(NodeProps.FLOW0);
        guiLabel velocityLabel = guiUtil.lblProp(NodeProps.VELOCITY);
        flow0Label.setIcon(flow0Icon);
        velocityLabel.setIcon(velocityIcon);
        panel.add((Component)flow0Label, "growy");
        panel.add((Component)flow0, "grow");
        panel.add((Component)velocityLabel, "growy, newline");
        panel.add((Component)velocity, "grow");
        panel.addConnection(new EditingTerminalConnection(DataNode.JunctionVisLeaf.IS_TERMINAL, panel));
        MerlinUDF temp = new MerlinUDF(14);
        temp.setEditable(false);
        MerlinUDF pres = new MerlinUDF(15);
        pres.setEditable(false);
        MerlinUDF dens = new MerlinUDF(22);
        dens.setEditable(false);
        prefSize = new Dimension((int)((double)temp.getPreferredSize().width * 1.25), temp.getPreferredSize().height);
        temp.setPreferredSize(prefSize);
        pres.setPreferredSize(prefSize);
        dens.setPreferredSize(prefSize);
        SelectionEditorPanel.EditorPanel panel2 = new SelectionEditorPanel.EditorPanel();
        this.bind(panel2, NodeProps.TEMPERATURE, temp);
        this.bind(panel2, NodeProps.PRESSURE, pres);
        this.bind(panel2, NodeProps.DENSITY, dens);
        panel2.setLayout(new MigLayout(""));
        ColorIcon tempIcon = new ColorIcon(Color.RED, squareIconDim, squareIconDim, 1);
        ColorIcon presIcon = new ColorIcon(Color.CYAN, squareIconDim, squareIconDim, 1);
        ColorIcon densIcon = new ColorIcon(Color.GRAY, squareIconDim, squareIconDim, 1);
        guiLabel tempLabel = guiUtil.lblProp(NodeProps.TEMPERATURE);
        guiLabel presLabel = guiUtil.lblProp(NodeProps.PRESSURE);
        guiLabel densLabel = guiUtil.lblProp(NodeProps.DENSITY);
        tempLabel.setIcon(tempIcon);
        presLabel.setIcon(presIcon);
        densLabel.setIcon(densIcon);
        panel2.add((Component)tempLabel, "growy");
        panel2.add((Component)temp, "grow");
        panel2.add((Component)presLabel, "growy, newline");
        panel2.add((Component)pres, "grow");
        panel2.add((Component)densLabel, "growy");
        panel2.add((Component)dens, "grow");
        return List.of(panel, panel2);
    }

    private void bind(SelectionEditorPanel.EditorPanel editor, TypedProp<UnitDouble> prop, guiUnitDoubleField control) {
        PropConnections.UDPropConnection binding = new PropConnections.UDPropConnection((CompElementActions.IObjectProp<IMerlinObj, UnitDouble>)new CompElementActions.DefProp<IMerlinObj, UnitDouble>(prop), control);
        editor.addConnection(binding);
    }

    private static class EditingTerminalConnection
    extends PropConnections.ASinglePropConnection<SelectionEditorPanel.EditorPanel, TypedProp<Boolean>> {
        public EditingTerminalConnection(TypedProp<Boolean> prop, SelectionEditorPanel.EditorPanel panel) {
            super(prop, panel);
            panel.addFocusListener(this);
            panel.addKeyListener(this);
        }

        @Override
        public void setProp(TypedProp<Boolean> prop, Collection<? extends IMerlinObj> objs, SelectionEditorPanel.EditorPanel comp) {
        }

        @Override
        public void initFromProp(TypedProp<Boolean> prop, Collection<? extends IMerlinObj> objs, SelectionEditorPanel.EditorPanel comp) {
            PropValue<Boolean> val = CompositePropertyUtil.getValue(prop, objs);
            if (val.isUniform()) {
                comp.setVisible(val.get());
            }
        }
    }
}

