/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.Unit;
import thunderheadeng.util.Global;

public class DataTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final DataTable EMPTY = new DataTable(new String[0], new String[0][]);
    public final String[] headers;
    public final String[][] data;

    public DataTable(String[] headers, String[][] data) {
        this.headers = headers;
        this.data = data;
    }

    public DataTable(DataTable obj) {
        this.headers = Arrays.copyOf(obj.headers, obj.headers.length);
        this.data = new String[obj.data.length][];
        for (int row = 0; row < obj.data.length; ++row) {
            this.data[row] = Arrays.copyOf(obj.data[row], obj.data[row].length);
        }
    }

    public DataTable addColumn(int index, String header, String fillValue) {
        Object[] rowVals = new String[this.data.length];
        Arrays.fill(rowVals, fillValue);
        return this.addColumn(index, header, (String[])rowVals);
    }

    public DataTable addColumn(int index, String header, String[] rowValues) {
        assert (rowValues.length == this.data.length);
        ArrayList<String> headers = new ArrayList<String>(Arrays.asList(this.headers));
        headers.add(index, header);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (int i = 0; i < this.data.length; ++i) {
            ArrayList<String> dataRow = new ArrayList<String>(Arrays.asList(this.data[i]));
            dataRow.add(index, rowValues[i]);
            rows.add(dataRow.toArray(new String[dataRow.size()]));
        }
        return DataTable.fromLists(headers, rows);
    }

    public DataTable filterColumns(Predicate<String> keepColumn) {
        HashSet<Integer> colsToRemove = new HashSet<Integer>();
        for (int i = 0; i < this.headers.length; ++i) {
            if (keepColumn.test(this.headers[i])) continue;
            colsToRemove.add(i);
        }
        ArrayList<String> headers = new ArrayList<String>(Arrays.asList(this.headers));
        for (int i = headers.size() - 1; i >= 0; --i) {
            if (!colsToRemove.contains(i)) continue;
            headers.remove(i);
        }
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (String[] row : this.data) {
            ArrayList<String> dataRow = new ArrayList<String>(Arrays.asList(row));
            for (int i = dataRow.size() - 1; i >= 0; --i) {
                if (!colsToRemove.contains(i)) continue;
                dataRow.remove(i);
            }
            rows.add(dataRow.toArray(new String[0]));
        }
        return DataTable.fromLists(headers, rows);
    }

    public DataTable append(DataTable other) {
        int i;
        ArrayList<String> headers;
        if (this.headers.length == 0) {
            headers = new ArrayList<String>(Arrays.asList(other.headers));
        } else if (other.headers.length == 0) {
            headers = new ArrayList<String>(Arrays.asList(other.headers));
        } else if (Arrays.equals(this.headers, other.headers)) {
            headers = new ArrayList<String>(Arrays.asList(this.headers));
        } else {
            throw new IllegalArgumentException("Headers must match.");
        }
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (i = 0; i < this.data.length; ++i) {
            rows.add(this.data[i]);
        }
        for (i = 0; i < other.data.length; ++i) {
            rows.add(other.data[i]);
        }
        return DataTable.fromLists(headers, rows);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String toCsvString() {
        try (StringWriter str = new StringWriter();){
            String string;
            block14: {
                ICSVWriter writer = new CSVWriterBuilder(str).withSeparator(',').build();
                try {
                    writer.writeNext(this.headers);
                    for (int row = 0; row < this.data.length; ++row) {
                        writer.writeNext(this.data[row]);
                    }
                    string = str.toString();
                    if (writer == null) break block14;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return string;
        }
        catch (IOException e) {
            return "";
        }
    }

    public static DataTable fromSqlResultSet(ResultSet rs) throws SQLException {
        ArrayList<String> colNames = new ArrayList<String>();
        ResultSetMetaData rsMetaData = rs.getMetaData();
        for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
            colNames.add(rsMetaData.getColumnLabel(i));
        }
        ArrayList<String[]> rows = new ArrayList<String[]>();
        while (rs.next()) {
            String[] row = new String[colNames.size()];
            for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                String obj = rs.getString(i);
                row[i - 1] = obj != null ? obj : "";
            }
            rows.add(row);
        }
        return DataTable.fromLists(colNames, rows);
    }

    public static DataTable fromLists(List<String> colNames, List<String[]> rows) {
        String[] headers = colNames.toArray(new String[colNames.size()]);
        String[][] data = new String[rows.size()][headers.length];
        for (int i = 0; i < rows.size(); ++i) {
            System.arraycopy(rows.get(i), 0, data[i], 0, headers.length);
        }
        return new DataTable(headers, data);
    }

    public static DataTable convertColUnits(DataTable src, ColTransform ... xforms) {
        DataTable output = new DataTable(src);
        for (ColTransform xform : xforms) {
            int col = Arrays.asList(output.headers).indexOf(xform.headerBefore);
            if (0 > col) continue;
            output.headers[col] = xform.headerAfter;
            for (int row = 0; row < output.data.length; ++row) {
                output.data[row][col] = xform.func.apply(output.data[row][col]);
            }
        }
        return output;
    }

    public static class ColTransform {
        public final String headerBefore;
        public final String headerAfter;
        public final Function<String, String> func;

        public ColTransform(String headerBefore, String headerAfter, Function<String, String> func) {
            this.headerBefore = headerBefore;
            this.headerAfter = headerAfter;
            this.func = func;
        }

        public ColTransform(String headerBefore, String headerAfter, Unit beforeUnit, Unit afterUnit) {
            this.headerBefore = headerBefore;
            this.headerAfter = headerAfter;
            this.func = val -> {
                double dval = Double.parseDouble(val);
                Converter cvt = beforeUnit.getConverterTo(afterUnit);
                double cvtVal = cvt.convert(dval);
                return Global.format(cvtVal, 6);
            };
        }
    }
}

