/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import ventus.EntryPointFactory;
import ventus.EntryPointHelper;
import ventus.Intl;
import ventus.actions.copypaste.DefaultPasteHandler;
import ventus.data.schematics.SimError;
import ventus.feature.CompositeFeatureGuid;
import ventus.feature.Feature;
import ventus.feature.comps.DefaultCompositeDataModel;
import ventus.feature.comps.FeatureUtil;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.flowpaths.DebugOp;
import ventus.feature.flowpaths.EditFlowElementOp;
import ventus.feature.flowpaths.EditFlowElementsMgrOp;
import ventus.feature.flowpaths.FindFlowpathForLevelAction;
import ventus.feature.flowpaths.FindFlowpathForZoneAction;
import ventus.feature.flowpaths.FindShaftOp;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowElementData;
import ventus.feature.flowpaths.FlowElementOISHandler;
import ventus.feature.flowpaths.FlowElementPrjWriter;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathLabel;
import ventus.feature.flowpaths.FlowPathOISHandler;
import ventus.feature.flowpaths.FlowPathPrjWriter;
import ventus.feature.flowpaths.FlowPathRibbon;
import ventus.feature.flowpaths.FlowPathRoot;
import ventus.feature.flowpaths.FlowPathSceneItem;
import ventus.feature.flowpaths.FlowPathValidation;
import ventus.feature.flowpaths.NewFlowPath1Pt;
import ventus.feature.flowpaths.NewFlowPath2Pt;
import ventus.feature.flowpaths.ShowFlowPaths;
import ventus.feature.flowpaths.ValidateConnectionOp;
import ventus.gui.guiUtil;

public class FlowPathsFeature {
    public static final CompositeFeatureGuid<FlowPathRoot, FlowPath> GUID = new CompositeFeatureGuid<FlowPathRoot, FlowPath>("flowpaths.data", FlowPathRoot.class, FlowPath.class);
    public static final int SEQ_IX = 47;
    public static final ImageIcon ICON = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(FlowPath.class, "icons/route.svg"), 16);
    public static final ImageIcon ICON_AMBIENT = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(FlowPath.class, "icons/route-a.svg"), new Color(80, 80, 80), 16);

    public static Feature create() {
        DefaultCompositeDataModel<FlowPathRoot, FlowPath> pathData = new DefaultCompositeDataModel<FlowPathRoot, FlowPath>(() -> new FlowPathRoot(), GUID, 47);
        pathData.addEntryPoint(EntryPointHelper.rootEP(FlowPathRoot.class, ICON, Intl.intl("Flow Path Root")));
        pathData.addEntryPoint(EntryPointHelper.groupEP(GUID, FlowPathRoot.FlowPathNode.class, FlowPathRoot.FlowPathNode.PROP_TYPES, ICON, Intl.intl("Flow Path Group")));
        EntryPointHelper<FlowPath> flowpathEp = pathData.addEntryPoint(EntryPointHelper.objectEP(GUID, FlowPath.class, FlowPath.PROP_TYPES, ICON, Intl.intl("Flow Path")));
        flowpathEp.getNameGroup = EntryPointFactory.nameGroup(vd -> ((FlowPathRoot)vd.getComponentData(GUID)).flatten(FlowPath.class));
        flowpathEp.getIcon = (data, fp, unused) -> fp.isExterior() ? ICON_AMBIENT : ICON;
        flowpathEp.getErrors = (vd, fp) -> {
            ArrayList<? extends SimError> errors = new ArrayList<SimError>(FlowPathValidation.nonParallelErr.get(vd, (FlowPath)fp));
            errors.addAll(FlowPathValidation.connTypeErr.get(vd, (FlowPath)fp));
            errors.addAll(FlowPathValidation.invalidErr.get(vd, (FlowPath)fp));
            errors.addAll(FlowPathValidation.fpConflictErr.get(vd, (FlowPath)fp));
            return errors;
        };
        FlowElementData elementData = new FlowElementData();
        FlowPathPrjWriter pathWriter = new FlowPathPrjWriter();
        FlowElementPrjWriter elementWriter = new FlowElementPrjWriter();
        EditFlowElementOp editFlowElemOp = new EditFlowElementOp();
        FindShaftOp shaftSearchOp = new FindShaftOp();
        ISelectionRibbon elemRibbon = ISelectionRibbon.newDefaultSelectionRibbon(FlowElement.class, editFlowElemOp.uiHook);
        FlowPathRibbon ribbonItem = new FlowPathRibbon();
        FlowPathSceneItem sceneItem = new FlowPathSceneItem();
        FlowPathLabel labelItem = new FlowPathLabel();
        NewFlowPath1Pt tool1Pt = new NewFlowPath1Pt();
        NewFlowPath2Pt tool2Pt = new NewFlowPath2Pt();
        DefaultPasteHandler pathsPasteHandler = new DefaultPasteHandler(FlowPathRoot.class);
        DefaultPasteHandler elementsPasteHandler = new DefaultPasteHandler(FlowElementRoot.class);
        ShowFlowPaths sfpComp = new ShowFlowPaths();
        return new Feature(pathData, elementData, pathWriter, elementWriter, ribbonItem, elemRibbon, sceneItem, labelItem, tool1Pt, tool2Pt, pathsPasteHandler, elementsPasteHandler, editFlowElemOp, shaftSearchOp, new FindFlowpathForZoneAction(), new FindFlowpathForLevelAction(), new EditFlowElementsMgrOp(), new DebugOp(), new FlowElementOISHandler(), new FlowPathOISHandler(), new ValidateConnectionOp(), sfpComp.appMenuItems, sfpComp.hkShowAmbient, sfpComp.hkShowInternal);
    }
}

