/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.util.ArrayList;
import java.util.Collection;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;
import ventus.EntryPoint;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.schematics.SimError;
import ventus.feature.flowpaths.FlowPath;

class FlowPathValidation {
    private static final double WALL_NORMAL_TOLERANCE = Util3D.toParallelTol(Math.toRadians(1.0));
    public static EntryPoint.Getter<FlowPath, Collection<? extends SimError>> invalidErr = (vd, fp) -> {
        ArrayList<SimError> errors = new ArrayList<SimError>();
        if (fp.isInvalid()) {
            String error = String.format(Intl.intl("%s is not connected to any zones."), fp.getName());
            String fix = Intl.intl("Delete Flow Path or re-attach to a surface.");
            errors.add(new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)fp));
        }
        return errors;
    };
    public static EntryPoint.Getter<FlowPath, Collection<? extends SimError>> nonParallelErr = (vd, fp) -> {
        Vector3d norm2;
        Vector3d norm1;
        ArrayList<SimError> errors = new ArrayList<SimError>();
        if (!fp.get(FlowPath.OVERWRITE_MULTIPLIER).booleanValue() && fp.get(FlowPath.START_COMP) != null && fp.get(FlowPath.END_COMP) != null && fp.get(FlowPath.START_COMP) != fp.get(FlowPath.END_COMP) && fp.get(FlowPath.START_WALL) != null && fp.get(FlowPath.END_WALL) != null && !Util3D.testParallel(norm1 = fp.get(FlowPath.START_NORMAL), norm2 = fp.get(FlowPath.END_NORMAL), WALL_NORMAL_TOLERANCE)) {
            errors.add(new SimError(SimError.Level.MODERATE, "<html>" + Intl.intl("<p>The flow path connects non-parallel walls. The calculated flow area might not match the desired value.</p><p>Manually adjust the <b>Leakage Area</b> in the property panel.</p>") + "</html>", "<html>" + Intl.intl("<p>Manually adjust the <b>Leakage Area</b> in the property panel.</</p>") + "</html>", (IMerlinObj)fp));
        }
        return errors;
    };
    public static EntryPoint.Getter<FlowPath, Collection<? extends SimError>> connTypeErr = (vd, fp) -> {
        ArrayList<SimError> errors = new ArrayList<SimError>();
        if (fp.getShouldWarnForConnectionTypeChange()) {
            errors.add(FlowPath.getConnectionTypeError(fp));
        }
        return errors;
    };
    public static EntryPoint.Getter<FlowPath, Collection<? extends SimError>> fpConflictErr = (vd, fp) -> {
        ArrayList<SimError> errors = new ArrayList<SimError>();
        Collection<FlowPath> conflicts = fp.getTypeConflicts();
        if (!conflicts.isEmpty()) {
            ArrayList<FlowPath> objs = new ArrayList<FlowPath>(conflicts.size() + 1);
            objs.add((FlowPath)fp);
            objs.addAll(conflicts);
            String error = String.format(Intl.intl("%s has possible conflicts with Flow Paths of the same type."), fp.getName());
            String fix = Intl.intl("Delete or move the conflicting Flow Paths.");
            errors.add(new SimError(SimError.Level.MODERATE, error, fix, objs));
        }
        return errors;
    };

    FlowPathValidation() {
    }
}

