/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiValueField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CompElementActions;
import ventus.actions.MerlinOpImpl;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.CompositePropertyUtil;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.value.Schedule;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.comps.SelectionRibbonHelper;
import ventus.feature.dependencies.powerlaw.LeakageAreaType;
import ventus.feature.dependencies.powerlaw.LeakageAreaTypeInfo;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.flowpaths.EditFlowElementsMgrOp;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathMarkerDlg;
import ventus.feature.windprofiles.WindProfile;
import ventus.gui.MerlinComboBox;
import ventus.gui.MerlinUDF;
import ventus.gui.UnitUpdator;
import ventus.gui.guiUtil;
import ventus.gui.value.ScheduleEditorPnl;
import ventus.mv.gui.PropConnections;
import ventus.mv.gui.SelectionEditorPanel;
import ventus.unitsystem.UnitSystem;
import ventus.util.MerlinUtil;

public class FlowPathRibbon
implements ISelectionRibbon {
    private guiComboBox<FlowElement> d_flowElementComboBox;
    private HTMLBtn d_flowElementEditBtn;
    private guiComboBox<WindProfile> d_windProfileComboBox;
    private final List<SelectionEditorPanel.EditorPanel> d_sections = new ArrayList<SelectionEditorPanel.EditorPanel>();

    private void createSections() {
        this.d_flowElementComboBox = new MerlinComboBox(VentusApp.getAppData(), FlowElement.class, (IMerlinObj[])new FlowElement[0]);
        PropConnections.ComboPropConn<FlowElement> elementConn = new PropConnections.ComboPropConn<FlowElement>(new CompElementActions.DefProp(FlowPath.FLOW_ELEMENT), this.d_flowElementComboBox);
        this.d_flowElementEditBtn = new HTMLBtn(Intl.intl("Edit..."));
        EditPropFlowElement editElementConn = new EditPropFlowElement(FlowPath.FLOW_ELEMENT, this.d_flowElementEditBtn);
        HTMLBtn markerButton = new HTMLBtn(Intl.intl("Edit..."));
        MarkerPropConn markerConn = new MarkerPropConn(markerButton);
        HTMLBtn zone1Button = new HTMLBtn("");
        ZonePropConn zone1Conn = new ZonePropConn(FlowPath.START_ZONE, zone1Button);
        HTMLBtn zone2Button = new HTMLBtn("");
        ZonePropConn zone2Conn = new ZonePropConn(FlowPath.END_ZONE, zone2Button);
        HTMLBtn directionButton = new HTMLBtn("&larr;");
        DirectionPropConn directionConn = new DirectionPropConn(FlowPath.DIRECTION, directionButton);
        PropConnections.BoolPropConnection overwriteMultConn = SelectionRibbonHelper.boolConn(FlowPath.OVERWRITE_MULTIPLIER, Intl.intl("Multiplier:"));
        guiMultiStateCheckBox overwriteMultCheck = (guiMultiStateCheckBox)overwriteMultConn.getControl();
        PropConnections.UDPropConnection multiplierConn = FlowPathRibbon.multiplierConn();
        MerlinUDF multiplierField = (MerlinUDF)multiplierConn.getControl();
        guiLabel baseAreaLabel = new guiLabel("");
        MerlinUDF baseAreaValue = new MerlinUDF(Unit.ONE);
        UnitUpdator.addComp(baseAreaValue);
        baseAreaValue.setEditable(false);
        guiRadioButton constantWindPressureRadio = new guiRadioButton(Intl.intl("Constant:"));
        constantWindPressureRadio.setToolTipText(Intl.intl("Constant wind pressure conditions for this flow path."));
        PropConnections.UDPropConnection windPressureConn = SelectionRibbonHelper.udConn(FlowPath.WIND_PRESSURE, 15);
        MerlinUDF windPressureField = (MerlinUDF)windPressureConn.getControl();
        guiRadioButton variableWindPressureRadio = new guiRadioButton(Intl.intl("Variable:"));
        variableWindPressureRadio.setToolTipText(Intl.intl("A variable wind pressure for this flow path defined using a wind profile."));
        this.d_windProfileComboBox = new MerlinComboBox(VentusApp.getAppData(), WindProfile.class, (IMerlinObj[])new WindProfile[0]);
        PropConnections.ComboPropConn<WindProfile> windProfileConn = new PropConnections.ComboPropConn<WindProfile>(new CompElementActions.DefProp(FlowPath.WIND_PROFILE), this.d_windProfileComboBox);
        PropConnections.UDPropConnection forcedRelHtConn = SelectionRibbonHelper.udConn(FlowPath.FORCED_RELATIVE_ELEVATION, 0);
        PropConnections.UDPropConnection calcRelHtConn = SelectionRibbonHelper.udConn(FlowPath.CALCULATED_RELATIVE_ELEVATION, 0);
        guiComboBox relHtTypeCombo = guiUtil.newCombo((ILabeled[])RelHtType.values());
        CompElementActions.MappedProp<IMerlinObj, RelHtType, UnitDouble> relHtTypeProp = new CompElementActions.MappedProp<IMerlinObj, RelHtType, UnitDouble>(new CompElementActions.DefProp(FlowPath.FORCED_RELATIVE_ELEVATION), (obj, relHt) -> relHt != null ? RelHtType.CUSTOM : RelHtType.FROM_GEOM, (obj, type) -> type == RelHtType.FROM_GEOM ? null : obj.get(FlowPath.CALCULATED_RELATIVE_ELEVATION));
        PropConnections.ComboPropConn relHtTypeConn = new PropConnections.ComboPropConn(relHtTypeProp, relHtTypeCombo);
        guiLabel relHtLbl = new guiLabel(String.format(Intl.intl("%s:"), FlowPath.RELATIVE_ELEVATION.name));
        relHtLbl.setToolTipText(FlowPath.RELATIVE_ELEVATION.desc);
        Runnable updateRelHtControls = () -> {
            RelHtType type = (RelHtType)relHtTypeCombo.getSelectedItem();
            boolean custom = type == RelHtType.CUSTOM;
            ((guiValueField)forcedRelHtConn.getControl()).setVisible(custom);
            ((guiValueField)calcRelHtConn.getControl()).setVisible(!custom);
            ((guiValueField)calcRelHtConn.getControl()).setEnabled(type != null);
            ((guiValueField)forcedRelHtConn.getControl()).setEnabled(type != null);
        };
        updateRelHtControls.run();
        relHtTypeCombo.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                updateRelHtControls.run();
            }
        });
        new guiButtonGroup(constantWindPressureRadio, variableWindPressureRadio);
        LinkStatus.link((AbstractButton)overwriteMultCheck, multiplierField);
        LinkStatus.link((AbstractButton)constantWindPressureRadio, windPressureField);
        LinkStatus.link((AbstractButton)variableWindPressureRadio, this.d_windProfileComboBox);
        PropConnections.BoolPropConnection overwriteScheduleMultConn = SelectionRibbonHelper.boolConn(FlowPath.OVERWRITE_SCHEDULE_MULTIPLIER, Intl.intl("Schedule Multiplier:"));
        guiMultiStateCheckBox overwriteScheduleMultCheck = (guiMultiStateCheckBox)overwriteScheduleMultConn.getControl();
        HTMLBtn multiScheButton = new HTMLBtn("Edit");
        MultiplierScheduleConn scheduleMultiplierConn = new MultiplierScheduleConn(FlowPath.SCHEDULE_MULTIPLIER_WRAPPER, Intl.intl("Schedule Multiplier:"), 10, UnitDoubleVR.between(0.0, 1.0, Unit.ONE, true, true), multiScheButton);
        LinkStatus.link((AbstractButton)overwriteScheduleMultCheck, new Component[]{scheduleMultiplierConn.getControl()});
        SelectionEditorPanel.EditorPanel section1 = this.newSection(this.d_sections);
        section1.addConnection(elementConn);
        section1.addConnection(editElementConn);
        section1.addConnection(markerConn);
        section1.add((Component)this.createTitleLabel(Intl.intl("Properties")), "wrap");
        SelectionEditorPanel.EditorPanel flowCalcSect = this.newSection();
        flowCalcSect.add(new guiLabel(Intl.intl("Element:")));
        flowCalcSect.add(this.d_flowElementComboBox, "wmax 180px");
        flowCalcSect.add((Component)this.d_flowElementEditBtn, "wrap");
        flowCalcSect.add(new guiLabel(Intl.intl("Marker:")));
        flowCalcSect.add((Component)markerConn.getControl());
        section1.add((Component)flowCalcSect, "gapbefore 20px, span");
        SelectionEditorPanel.EditorPanel section2 = this.newSection(this.d_sections);
        section2.addConnection(overwriteMultConn);
        section2.addConnection(multiplierConn);
        section2.add((Component)this.createTitleLabel(Intl.intl("Leakage Area")), "wrap");
        SelectionEditorPanel.EditorPanel leakageAreaSect = this.newSection();
        leakageAreaSect.add(baseAreaLabel);
        leakageAreaSect.add((Component)baseAreaValue, "wrap");
        leakageAreaSect.add(overwriteMultCheck);
        leakageAreaSect.add(multiplierField);
        section2.add((Component)leakageAreaSect, "gapbefore 20px");
        SelectionEditorPanel.EditorPanel section3 = this.newSection(this.d_sections);
        section3.addConnection(new WindPanelPropConn(section3));
        section3.addConnection(new PropConnections.BoolRadioPropConn(FlowPath.CONSTANT_WIND_PRESSURE, constantWindPressureRadio, true));
        section3.addConnection(new PropConnections.BoolRadioPropConn(FlowPath.CONSTANT_WIND_PRESSURE, variableWindPressureRadio, false));
        section3.addConnection(windPressureConn);
        section3.addConnection(windProfileConn);
        guiLabel windPressureTitle = new guiLabel(Intl.intl("Wind Pressure"));
        windPressureTitle.setFont(windPressureTitle.getFont().deriveFont(1));
        SelectionEditorPanel.EditorPanel windPressureSect = this.newSection();
        section3.add((Component)this.createTitleLabel(Intl.intl("Wind Pressure")), "wrap");
        windPressureSect.add(constantWindPressureRadio);
        windPressureSect.add((Component)windPressureField, "wrap");
        windPressureSect.add(variableWindPressureRadio);
        windPressureSect.add(this.d_windProfileComboBox, "growx");
        section3.add((Component)windPressureSect, "gapbefore 20px");
        SelectionEditorPanel.EditorPanel section4 = this.newSection(this.d_sections);
        section4.addConnection(forcedRelHtConn);
        section4.addConnection(relHtTypeConn);
        section4.addConnection(calcRelHtConn);
        section4.addConnection(zone1Conn);
        section4.addConnection(zone2Conn);
        section4.addConnection(directionConn);
        section4.addConnection(SelectionRibbonHelper.getPropConnListener(evt -> updateRelHtControls.run()));
        guiLabel powFlowDirLabel = new guiLabel(Intl.intl("Direction:"));
        powFlowDirLabel.setToolTipText(Intl.intl("Direction of positive flow in results."));
        guiPanel relHtPnl = new guiPanel(new FlowLayout(0, 0, 0));
        relHtPnl.add((Component)forcedRelHtConn.getControl());
        relHtPnl.add((Component)calcRelHtConn.getControl());
        section4.add((Component)this.createTitleLabel(Intl.intl("Geometry")), "wrap");
        section4.add((Component)relHtLbl, "gapbefore 20px");
        section4.add(relHtTypeCombo);
        section4.add((Component)relHtPnl, "wrap");
        section4.add((Component)powFlowDirLabel, "gapbefore 20px");
        guiPanel zoneSect = new guiPanel(new MigLayout("insets 0, align center"));
        zoneSect.add(zone1Button);
        zoneSect.add(directionButton);
        zoneSect.add(zone2Button);
        section4.add((Component)zoneSect, "span");
        SelectionEditorPanel.EditorPanel section5 = this.newSection(this.d_sections);
        section5.addConnection(overwriteScheduleMultConn);
        section5.addConnection(scheduleMultiplierConn);
        section5.add((Component)this.createTitleLabel(Intl.intl("Schedule")), "wrap");
        section5.add(overwriteScheduleMultCheck);
        section5.add((Component)multiScheButton, "wrap");
        Consumer<FlowElement> onFeChange = fe -> {
            String overwriteCtrlText;
            String baseAreaLabelText;
            UnitDouble baseAreaValueValue;
            Unit baseAreaValueUnit;
            if (fe == null) {
                return;
            }
            PowerlawModel model = (PowerlawModel)fe.get(FlowElement.POWERLAW_MODEL);
            UnitSystem us = VentusApp.getApp().getUnitSystem();
            if (model == PowerlawModel.LEAKAGE_AREA) {
                LeakageAreaType laType = (LeakageAreaType)fe.get(FlowElement.LEAKAGE_AREA_TYPE);
                LeakageAreaTypeInfo laTypeInfo = new LeakageAreaTypeInfo(laType);
                baseAreaValueUnit = us.getUnit(laTypeInfo.unit);
                baseAreaValueValue = fe.get(laTypeInfo.prop);
                baseAreaLabelText = laTypeInfo.get(() -> Intl.intl("Area:"), () -> Intl.intl("Height:"), () -> Intl.intl("Item:"));
                overwriteCtrlText = laTypeInfo.get(() -> Intl.intl("Items:"), () -> Intl.intl("Length:"), () -> Intl.intl("Area:"));
            } else {
                baseAreaLabelText = Intl.intl("Area:");
                overwriteCtrlText = Intl.intl("Items:");
                baseAreaValueUnit = us.getArea();
                baseAreaValueValue = (UnitDouble)fe.get(FlowElement.CROSS_SECTIONAL_AREA);
            }
            baseAreaLabel.setText(baseAreaLabelText);
            ((guiMultiStateCheckBox)overwriteMultConn.getControl()).setText(overwriteCtrlText);
            baseAreaValue.setDisplayUnit(baseAreaValueUnit);
            baseAreaValue.setValue(baseAreaValueValue);
        };
        section1.addConnection(SelectionRibbonHelper.getPropConnListener(evt -> onFeChange.accept(this.d_flowElementComboBox.getSelectedItem())));
        this.d_flowElementComboBox.addItemListener(evt -> onFeChange.accept(this.d_flowElementComboBox.getSelectedItem()));
    }

    private SelectionEditorPanel.EditorPanel newSection() {
        return new SelectionEditorPanel.EditorPanel(new MigLayout("insets 0, aligny top"));
    }

    private SelectionEditorPanel.EditorPanel newSection(List<SelectionEditorPanel.EditorPanel> sections) {
        SelectionEditorPanel.EditorPanel panel = this.newSection();
        sections.add(panel);
        return panel;
    }

    private guiLabel createTitleLabel(String title) {
        guiLabel label = new guiLabel(title);
        label.setFont(label.getFont().deriveFont(1));
        return label;
    }

    @Override
    public boolean isEnabled(Set<TypedProp<?>> shared, Set<TypedProp<?>> unshared) {
        return shared.contains(FlowPath.START_COMP);
    }

    @Override
    public Collection<SelectionEditorPanel.EditorPanel> getSections() {
        if (this.d_sections.isEmpty()) {
            this.createSections();
        }
        return this.d_sections;
    }

    public static PropConnections.UDPropConnection multiplierConn() {
        final MerlinUDF field = new MerlinUDF(Unit.ONE);
        return new PropConnections.UDPropConnection(new CompElementActions.DefProp(FlowPath.MULTIPLIER), field){

            @Override
            public void initFromVal(PropValue<UnitDouble> val, guiValueField<UnitDouble> comp) {
                if (val.isUniform() && val.get() != null) {
                    UnitDouble udVal = val.get();
                    UnitSystem us = VentusApp.getAppData().getUnitSystem();
                    int unitType = UnitSystem.getType(udVal.getUnit());
                    field.setDisplayUnit(us.getUnit(unitType));
                }
                super.initFromVal(val, comp);
            }
        };
    }

    public static class EditPropFlowElement
    extends PropConnections.ASinglePropConnection<HTMLBtn, TypedProp<FlowElement>> {
        public EditPropFlowElement(TypedProp<FlowElement> prop, HTMLBtn control) {
            super(prop, control);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void setProp(TypedProp<FlowElement> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
        }

        @Override
        public void initFromProp(TypedProp<FlowElement> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            PropValue<FlowElement> val = CompositePropertyUtil.getValue(prop, objs);
            comp.setVisible(false);
            comp.clearListeners();
            if (val.isUniform()) {
                comp.setVisible(true);
                comp.addActionListener(new EditPropFlowElementAction(val.get()));
            }
        }

        private static class EditPropFlowElementAction
        extends AMerlinOp
        implements ActionListener {
            private static FlowElement d_elem;

            public EditPropFlowElementAction(FlowElement elem) {
                d_elem = elem;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                UIHook.run(UIHook.getComponent(e), "EditFlowElementAction", this, 0);
            }

            @Override
            public void run(VentusApp app, VentusData md) {
                EditFlowElementsMgrOp.showDlg(app, md, d_elem);
            }
        }
    }

    public static class MarkerPropConn
    extends PropConnections.AMultiPropConnection<HTMLBtn, TypedProp<?>> {
        private Collection<? extends IMerlinObj> d_objs;

        public MarkerPropConn(HTMLBtn control) {
            super(Set.of(FlowPath.OVERWRITE_COLOR, FlowPath.COLOR, FlowPath.SIZE), control);
            control.clearListeners();
            control.addActionListener(evt -> {
                Window window = SwingUtilities.getWindowAncestor(this.getControl());
                FlowPathMarkerDlg dlg = new FlowPathMarkerDlg(window, this.d_objs);
                if (dlg.doModal() == 1) {
                    dlg.save();
                    ((HTMLBtn)this.getControl()).setText(FlowPathMarkerDlg.getDescription(this.d_objs));
                }
            });
            control.addActionListener(this);
        }

        @Override
        public void setProps(Collection<? extends TypedProp<?>> props, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
        }

        @Override
        protected void initFromProp(Collection<? extends TypedProp<?>> props, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            this.d_objs = objs;
            ((HTMLBtn)this.getControl()).setText(FlowPathMarkerDlg.getDescription(this.d_objs));
        }
    }

    public static class ZonePropConn
    extends PropConnections.ASinglePropConnection<HTMLBtn, CompElementActions.IObjectProp<IMerlinObj, ISchematicRoom>> {
        public ZonePropConn(TypedProp<ISchematicRoom> prop, HTMLBtn control) {
            super(new CompElementActions.DefProp(prop), control);
            control.addActionListener(this);
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, ISchematicRoom> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, ISchematicRoom> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            comp.clearListeners();
            PropValue<ISchematicRoom> value = prop.get(VentusApp.getAppData(), objs);
            if (!value.isUniform()) {
                comp.setText(Intl.intl("&lt;mixed&gt;"));
                return;
            }
            ISchematicRoom zone = value.get();
            comp.setText(MerlinUtil.getName(zone));
            if (zone.equals(FlowPath.AMBIENT_ZONE)) {
                return;
            }
            comp.addActionListener(evt -> {
                MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                    try (VentusData.WriteLock lock = md.lockWrite();){
                        Undo.begin(Intl.intl("Select Zone"));
                        Undo.insertUndoEntry_restoreSelection(md);
                        md.selection.set(zone);
                        Undo.end(md);
                    }
                });
                UIHook.run(UIHook.getComponent(evt), "FlowPathRibbon.ZonePropConn.initFromProp", op, 0);
            });
        }
    }

    public static class DirectionPropConn
    extends PropConnections.ASinglePropConnection<HTMLBtn, CompElementActions.IObjectProp<IMerlinObj, Boolean>> {
        private static final String POSITIVE = "&rarr;";
        private static final String NEGATIVE = "&larr;";
        private boolean d_modified = false;

        public DirectionPropConn(TypedProp<Boolean> prop, HTMLBtn control) {
            super(new CompElementActions.DefProp(prop), control);
            control.clearListeners();
            control.addActionListener(evt -> {
                Boolean direction = DirectionPropConn.parse(control);
                direction = direction == null ? Boolean.valueOf(true) : Boolean.valueOf(direction == false);
                this.d_modified = true;
                control.setText(DirectionPropConn.format(direction));
            });
            control.addActionListener(this);
        }

        private static Boolean parse(HTMLBtn comp) {
            if (comp.getText().contains(POSITIVE)) {
                return true;
            }
            if (comp.getText().contains(NEGATIVE)) {
                return false;
            }
            return null;
        }

        private static String format(Boolean dir) {
            return dir != null ? (dir.booleanValue() ? POSITIVE : NEGATIVE) : "&lt;&gt;";
        }

        @Override
        protected boolean isModified(HTMLBtn comp) {
            return this.d_modified;
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            if (comp.getText() == null || objs.isEmpty()) {
                return;
            }
            Boolean direction = DirectionPropConn.parse(comp);
            if (direction == null) {
                return;
            }
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Flow Direction"), prop, objs, direction);
            this.d_modified = false;
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            if (objs.isEmpty()) {
                return;
            }
            PropValue<Boolean> val = prop.get(VentusApp.getApp().getData(), objs);
            String text = DirectionPropConn.format(val.orElse(null));
            comp.setText(text);
            this.d_modified = false;
        }
    }

    private static enum RelHtType implements ILabeled
    {
        FROM_GEOM(Intl.intl("Geometric"), Intl.intl("Calculates the Relative Height from the geometry of the Flow Path.\nThis option may restrict the Relative Height based on the geometry\nof attached zones.\nRecommended for all but two-way Flow Element types.")),
        CUSTOM(Intl.intl("Custom"), Intl.intl("Specifies a custom Relative Height that is unaffected by Flow Path geometry.\nThis option places no restrictions on the specified Relative Height.\nRecommended for two-way Flow Element types."));

        public String name;
        public String desc;

        private RelHtType(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }

    public static class MultiplierScheduleConn
    extends PropConnections.ASinglePropConnection<HTMLBtn, CompElementActions.IObjectProp<IMerlinObj, Schedule>> {
        private Schedule d_currVal;
        private Unit d_unit;
        private String d_name;

        public MultiplierScheduleConn(TypedProp<Schedule> prop, String name, int unit, UnitDoubleVR range, HTMLBtn control) {
            super(new CompElementActions.DefProp(prop), control);
            this.d_currVal = (Schedule)prop.defVal;
            this.d_unit = VentusApp.getApp().getUnitSystem().getUnit(unit);
            this.d_name = name;
            control.addActionListener(e -> {
                Schedule newVal;
                ScheduleEditorPnl editorPnl = new ScheduleEditorPnl(name, UnitSystem.getType(1, true), ValueFields.udFld(UnitSystem.getType(10, false), range));
                editorPnl.load(this.d_currVal);
                Window parent = SwingUtilities.getWindowAncestor(this.getControl());
                String title = String.format(Intl.intl("Edit %s"), name);
                guiDialog dlg = new guiDialog(parent, title, 9);
                dlg.setResizable(true);
                guiPanel c = dlg.getDialogPane();
                c.setLayout(new BorderLayout());
                c.add((Component)editorPnl, "Center");
                if (dlg.doModal() == 1 && dlg.isModified() && (newVal = editorPnl.save()) != null && !Objects.equals(this.d_currVal, newVal)) {
                    Schedule oldVal = this.d_currVal;
                    this.d_currVal = newVal;
                    control.setText(this.describe(this.d_currVal));
                }
                editorPnl.close();
            });
            control.addActionListener(this);
        }

        private String describe(Schedule schedule) {
            return String.format(Intl.intl("t(0) = %s, ..."), MerlinUtil.format(schedule.getInitialValue(), this.d_unit));
        }

        public void setValue(Schedule value) {
            this.d_currVal = value;
            ((HTMLBtn)this.getControl()).setText(this.describe(this.d_currVal));
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, Schedule> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            SelectionEditorPanel.setPropRecursive(String.format(Intl.intl("Edit %s"), this.d_name), prop, objs, this.d_currVal);
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, Schedule> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            PropValue<Schedule> value = prop.get(VentusApp.getAppData(), objs);
            Schedule sche = value.orElse(null);
            if (sche != null) {
                this.setValue(sche);
            }
        }
    }

    public static class WindPanelPropConn
    extends PropConnections.AMultiPropConnection<SelectionEditorPanel.EditorPanel, TypedProp<ISchematicRoom>> {
        public WindPanelPropConn(SelectionEditorPanel.EditorPanel control) {
            super(Arrays.asList(FlowPath.START_ZONE, FlowPath.END_ZONE), control);
        }

        @Override
        public void setProps(Collection<? extends TypedProp<ISchematicRoom>> props, Collection<? extends IMerlinObj> objs, SelectionEditorPanel.EditorPanel comp) {
        }

        @Override
        public void initFromProp(Collection<? extends TypedProp<ISchematicRoom>> props, Collection<? extends IMerlinObj> objs, SelectionEditorPanel.EditorPanel panel) {
            boolean connectedToAmbient = CompElementActions.flattenToLocallyDefined(FlowPath.START_ZONE, objs).stream().allMatch(obj -> {
                assert (obj.isSupportedLocally(FlowPath.END_ZONE));
                ISchematicRoom start = obj.get(FlowPath.START_ZONE);
                ISchematicRoom end = obj.get(FlowPath.END_ZONE);
                return FlowPath.isExterior(new Pair<ISchematicRoom, ISchematicRoom>(start, end));
            });
            panel.setEnabled(connectedToAmbient);
        }
    }
}

