/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.util.Optional;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.scene3d.nativebuffered.ISceneRenderOptions;
import thunderheadeng.util.Pair;
import ventus.data.VentusData;
import ventus.feature.comps.ILabelItem;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathGeometry;
import ventus.geom.Geometry;
import ventus.mv.ModelView;
import ventus.mv.displays.GlobalDisplayMgr;
import ventus.mv.displays.IMerlinDispMgr;
import ventus.mv.displays.LabelDispMgr;

public class FlowPathLabel
implements ILabelItem {
    public static final GlobalDisplayMgr.IScenePropsProvider PROPS = GlobalDisplayMgr.overrideProps(ISceneRenderOptions.DEPTHTEST_ENABLED, false, new Object[]{ISceneRenderOptions.AUTO_CLIP, false, ISceneRenderOptions.LIGHTMODEL, ISceneRenderOptions.LightModel.DISABLED});

    @Override
    public Pair<GlobalDisplayMgr.SceneInfo, IMerlinDispMgr<?>> createDisplayManager(ModelView mv, VentusData md) {
        GlobalDisplayMgr.SceneInfo info = new GlobalDisplayMgr.SceneInfo(PROPS, new GlobalDisplayMgr.SO[0]);
        return new Pair(info, new LabelDispMgr<FlowPath>(md, mv, FlowPath.class, info.scene, this::calcLblInfo));
    }

    private LabelDispMgr.Label3DInfo calcLblInfo(Object obj) {
        Point3d anchor;
        Point3d offset;
        assert (obj instanceof FlowPath);
        FlowPath fp = (FlowPath)obj;
        double radius = fp.get(FlowPath.SIZE).get(Geometry.LENGTH_UNIT) / 2.0;
        FlowPathGeometry geom = fp.getCustomGeom();
        if (!geom.begin.p().epsilonEquals(geom.end.p(), 0.001)) {
            offset = new Point3d(0.0, 0.0, 0.0);
            anchor = new Point3d(0.5, 0.0, 0.0);
            if (geom.begin.p().distance(geom.end.p()) < radius * 3.1) {
                offset.z += radius;
            }
        } else {
            Optional<Vector3d> fpn = fp.getWallInteriorNormal();
            if (fpn.isPresent()) {
                Vector3d n = fpn.get();
                n.scale(radius * 1.5);
                n.z += radius;
                offset = new Point3d(n);
            } else {
                offset = new Point3d(0.0, 0.0, radius * 1.5);
            }
            anchor = new Point3d(0.5, 0.5, 0.5);
        }
        return new LabelDispMgr.Label3DInfo(offset, anchor);
    }
}

