/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.data.property.Function1dProp;
import ventus.data.schematics.FloorOptions;
import ventus.data.value.APiecewiseFunction1d;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.dependencies.powerlaw.CubicFanPerformanceCurveUtil;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.dependencies.powerlaw.PowerlawUtil;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowElementData;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.geom.Geometry;
import ventus.io.contamx.PrjData;
import ventus.unitsystem.SIUS;

public class FlowElementPrjWriter
implements IPrjDataWriter {
    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.NORMAL;
    }

    public double getLevelHeight(VentusData md) {
        FloorOptions floorSort = Objects.requireNonNull(md.floorOptions);
        return floorSort.get(FloorOptions.MIN_AUTO_FLOOR_DIST).get(Geometry.LENGTH_UNIT);
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        FlowElementRoot root = (FlowElementRoot)md.getComponentData(FlowElementData.GUID);
        for (FlowElement in : root.flatten(FlowElement.class)) {
            APiecewiseFunction1d func;
            Function1dProp prop;
            Serializable outPlrTest;
            PrjData.AirFlowElem out = new PrjData.AirFlowElem(in);
            prjData.airFlowList.add(out);
            out.nr = prjData.nafe = prjData.airFlowList.size();
            out.type = PowerlawUtil.getPowerlawModelType(in, PowerlawModel.Usage.FLOWPATH);
            out.name = in.getName();
            out.desc = "";
            if (in.get(FlowElement.POWERLAW_MODEL) == PowerlawModel.ORIFICE_AREA) {
                PrjData.AirFlowTypePlrOrf outPlrOrf = new PrjData.AirFlowTypePlrOrf();
                prjData.plrOrfMap.put(out.nr, outPlrOrf);
                outPlrOrf.lam = PowerlawUtil.getLaminarFlow(in);
                outPlrOrf.turb = PowerlawUtil.getTurbulentFlow(in);
                outPlrOrf.expt = (Double)in.get(FlowElement.PRESSURE_EXPONENT);
                outPlrOrf.area = ((UnitDouble)in.get(FlowElement.CROSS_SECTIONAL_AREA)).getValue(SI.METER.pow(2));
                outPlrOrf.dia = PowerlawUtil.areaToDiameter((UnitDouble)in.get(FlowElement.CROSS_SECTIONAL_AREA)).getValue(SI.METER);
                outPlrOrf.coef = (Double)in.get(FlowElement.DISCHARGE_COEFFICIENT);
                outPlrOrf.Re = (Double)in.get(FlowElement.REYNOLDS_NUMBER);
                outPlrOrf.uA = 0;
                outPlrOrf.uD = 0;
                continue;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA) {
                PrjData.AirFlowTypePlrLeakArea outLeakArea = new PrjData.AirFlowTypePlrLeakArea();
                prjData.plrLeakAreaMap.put(out.nr, outLeakArea);
                outLeakArea.lam = PowerlawUtil.getLaminarFlow(in);
                outLeakArea.turb = PowerlawUtil.getTurbulentFlow(in);
                outLeakArea.expt = (Double)in.get(FlowElement.PRESSURE_EXPONENT);
                outLeakArea.coef = (Double)in.get(FlowElement.DISCHARGE_COEFFICIENT);
                outLeakArea.pres = ((UnitDouble)in.get(FlowElement.PRESSURE_DIFFERENCE)).get(SI.PASCAL);
                Unit unitArea1 = SI.METER.pow(2);
                outLeakArea.area1 = ((UnitDouble)in.get(FlowElement.LEAKAGE_AREA_PER_ITEM)).get(unitArea1);
                BaseUnit unitArea2 = SI.METER;
                outLeakArea.area2 = ((UnitDouble)in.get(FlowElement.LEAKAGE_AREA_PER_LENGTH)).get(unitArea2);
                Unit unitArea3 = Unit.ONE;
                outLeakArea.area3 = ((UnitDouble)in.get(FlowElement.LEAKAGE_AREA_PER_AREA)).get(unitArea3);
                outLeakArea.uA1 = 0;
                outLeakArea.uA2 = 0;
                outLeakArea.uA3 = 0;
                outLeakArea.udP = 0;
                continue;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == PowerlawModel.TEST_ONE) {
                outPlrTest = new PrjData.AirFlowTypeTestData1Point();
                prjData.plrTest1Map.put(out.nr, (PrjData.AirFlowTypeTestData1Point)outPlrTest);
                outPlrTest.lam = PowerlawUtil.getLaminarFlow(in);
                outPlrTest.turb = PowerlawUtil.getTurbulentFlow(in);
                outPlrTest.expt = (Double)in.get(FlowElement.PRESSURE_EXPONENT);
                outPlrTest.dP = ((UnitDouble)in.get(FlowElement.PRESSURE_DIFFERENCE)).get(SI.PASCAL);
                outPlrTest.flow = ((UnitDouble)in.get(FlowElement.FLOWRATE)).get(SIUS.unit(17));
                outPlrTest.u_P = 0;
                outPlrTest.u_F = 0;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == PowerlawModel.TEST_TWO) {
                outPlrTest = new PrjData.AirFlowTypeTestData2Point();
                prjData.plrTest2Map.put(out.nr, (PrjData.AirFlowTypeTestData2Point)outPlrTest);
                ((PrjData.AirFlowTypeTestData2Point)outPlrTest).lam = PowerlawUtil.getLaminarFlow(in);
                ((PrjData.AirFlowTypeTestData2Point)outPlrTest).turb = PowerlawUtil.getTurbulentFlow(in);
                ((PrjData.AirFlowTypeTestData2Point)outPlrTest).expt = (Double)in.get(FlowElement.PRESSURE_EXPONENT);
                ((PrjData.AirFlowTypeTestData2Point)outPlrTest).dP1 = ((UnitDouble)in.get(FlowElement.PRESSURE_DIFFERENCE1)).get(SI.PASCAL);
                ((PrjData.AirFlowTypeTestData2Point)outPlrTest).F1 = ((UnitDouble)in.get(FlowElement.FLOWRATE1)).get(SIUS.unit(17));
                ((PrjData.AirFlowTypeTestData2Point)outPlrTest).dP2 = ((UnitDouble)in.get(FlowElement.PRESSURE_DIFFERENCE2)).get(SI.PASCAL);
                ((PrjData.AirFlowTypeTestData2Point)outPlrTest).F2 = ((UnitDouble)in.get(FlowElement.FLOWRATE2)).get(SIUS.unit(17));
                ((PrjData.AirFlowTypeTestData2Point)outPlrTest).u_P1 = 0;
                ((PrjData.AirFlowTypeTestData2Point)outPlrTest).u_F1 = 0;
                ((PrjData.AirFlowTypeTestData2Point)outPlrTest).u_P2 = 0;
                ((PrjData.AirFlowTypeTestData2Point)outPlrTest).u_F2 = 0;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == PowerlawModel.CRACK_DESCRIPTION) {
                PrjData.AirFlowTypeCrackDescription outCrack = new PrjData.AirFlowTypeCrackDescription();
                prjData.plrCrackMap.put(out.nr, outCrack);
                outCrack.lam = PowerlawUtil.getLaminarFlow(in);
                outCrack.turb = PowerlawUtil.getTurbulentFlow(in);
                outCrack.expt = PowerlawUtil.getFlowExponent(in);
                outCrack.length = ((UnitDouble)in.get(FlowElement.CRACK_LENGTH)).get(SI.METER);
                outCrack.width = ((UnitDouble)in.get(FlowElement.CRACK_WIDTH)).get(SI.METER);
                outCrack.u_L = 0;
                outCrack.u_W = 0;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == PowerlawModel.STAIRWELL) {
                PrjData.AirFlowTypePlrStair outPlrStair = new PrjData.AirFlowTypePlrStair();
                prjData.plrStairMap.put(out.nr, outPlrStair);
                outPlrStair.lam = PowerlawUtil.getLaminarFlow(in);
                outPlrStair.turb = PowerlawUtil.getTurbulentFlow(in);
                outPlrStair.expt = (Double)in.get(FlowElement.PRESSURE_EXPONENT);
                outPlrStair.Ht = ((UnitDouble)in.get(FlowElement.STAIR_SHAFT_DZ)).get(SI.METER);
                outPlrStair.area = ((UnitDouble)in.get(FlowElement.CROSS_SECTIONAL_AREA)).getValue(SI.METER.pow(2));
                outPlrStair.peo = 0;
                outPlrStair.tread = (Boolean)in.get(FlowElement.STAIR_TREADS_OPEN) != false ? 1 : 0;
                outPlrStair.uA = 0;
                outPlrStair.uD = 0;
                continue;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == PowerlawModel.SHAFT) {
                PrjData.AirFlowTypePlrShaft outPlrShaft = new PrjData.AirFlowTypePlrShaft();
                prjData.plrShaftMap.put(out.nr, outPlrShaft);
                outPlrShaft.lam = PowerlawUtil.getLaminarFlow(in);
                outPlrShaft.turb = PowerlawUtil.getTurbulentFlow(in);
                outPlrShaft.expt = (Double)in.get(FlowElement.PRESSURE_EXPONENT);
                outPlrShaft.Ht = ((UnitDouble)in.get(FlowElement.STAIR_SHAFT_DZ)).get(SI.METER);
                outPlrShaft.area = ((UnitDouble)in.get(FlowElement.CROSS_SECTIONAL_AREA)).getValue(SI.METER.pow(2));
                outPlrShaft.perim = ((UnitDouble)in.get(FlowElement.PERIMETER)).getValue(SI.METER);
                outPlrShaft.rough = ((UnitDouble)in.get(FlowElement.ROUGHNESS)).getValue(SI.METER);
                outPlrShaft.uA = 0;
                outPlrShaft.uD = 0;
                outPlrShaft.uP = 0;
                outPlrShaft.uR = 0;
                continue;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == PowerlawModel.SELF_REG_VENT) {
                PrjData.AirFlowTypeSelfRegulatingVent selfRegulatingVent = new PrjData.AirFlowTypeSelfRegulatingVent();
                prjData.selfRegulatingVentMap.put(out.nr, selfRegulatingVent);
                selfRegulatingVent.maxFlowRate = ((UnitDouble)in.get(FlowElement.MAX_FLOW_RATE)).getValue(SI.METER.pow(3).divide(SI.SECOND));
                selfRegulatingVent.regulatingPressure = ((UnitDouble)in.get(FlowElement.REGULATING_PRESSURE)).getValue(SI.PASCAL);
                selfRegulatingVent.reverseFlowFraction = ((UnitDouble)in.get(FlowElement.REVERSE_FLOW_FRACTION)).getValue(Unit.ONE);
                selfRegulatingVent.uF = 0;
                selfRegulatingVent.uP = 0;
                continue;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == PowerlawModel.TWOWAY_ONE) {
                PrjData.AirFlowTypeTwoWayOneOpening oneOpeningDoor = new PrjData.AirFlowTypeTwoWayOneOpening();
                prjData.twOneOpMap.put(out.nr, oneOpeningDoor);
                oneOpeningDoor.lam = PowerlawUtil.getLaminarFlow(in);
                oneOpeningDoor.turb = PowerlawUtil.getTurbulentFlow(in);
                oneOpeningDoor.expt = 0.5;
                oneOpeningDoor.dTmin = 0.01;
                oneOpeningDoor.ht = ((UnitDouble)in.get(FlowElement.DOOR_HEIGHT)).getValue(SI.METER);
                oneOpeningDoor.wd = ((UnitDouble)in.get(FlowElement.DOOR_WIDTH)).getValue(SI.METER);
                oneOpeningDoor.cd = (Double)in.get(FlowElement.DISCHARGE_COEFFICIENT);
                oneOpeningDoor.u_T = 0;
                oneOpeningDoor.u_H = 0;
                oneOpeningDoor.u_W = 0;
                continue;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == PowerlawModel.TWOWAY_TWO) {
                PrjData.AirFlowTypeTwoWayTwoOpening twoOpeningDoor = new PrjData.AirFlowTypeTwoWayTwoOpening();
                prjData.twTwoOpMap.put(out.nr, twoOpeningDoor);
                twoOpeningDoor.lam = PowerlawUtil.getLaminarFlow(in);
                twoOpeningDoor.turb = PowerlawUtil.getTurbulentFlow(in);
                twoOpeningDoor.expt = 0.5;
                twoOpeningDoor.dH = ((UnitDouble)in.get(FlowElement.DOOR_HEIGHT)).getValue(SI.METER) * 2.0 / 9.0;
                twoOpeningDoor.ht = ((UnitDouble)in.get(FlowElement.DOOR_HEIGHT)).getValue(SI.METER);
                twoOpeningDoor.wd = ((UnitDouble)in.get(FlowElement.DOOR_WIDTH)).getValue(SI.METER);
                twoOpeningDoor.cd = (Double)in.get(FlowElement.DISCHARGE_COEFFICIENT);
                twoOpeningDoor.u_H = 0;
                twoOpeningDoor.u_W = 0;
                continue;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == PowerlawModel.CONSTANT_MASS_FLOW_FAN) {
                PrjData.AirFlowTypeConstantMassFlowFan constantMassFlowFan = new PrjData.AirFlowTypeConstantMassFlowFan();
                prjData.constantMassFlowFanMap.put(out.nr, constantMassFlowFan);
                constantMassFlowFan.maxFlowRate = ((UnitDouble)in.get(FlowElement.CONSTANT_FAN_MAX_FLOW_RATE)).getValue(SI.KILOGRAM.divide(SI.SECOND));
                constantMassFlowFan.uF = 0;
                continue;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == PowerlawModel.CONSTANT_VOLUME_FLOW_FAN) {
                PrjData.AirFlowTypeConstantVolumeFlowFan constantVolumeFlowFan = new PrjData.AirFlowTypeConstantVolumeFlowFan();
                prjData.constantVolumeFlowFanMap.put(out.nr, constantVolumeFlowFan);
                constantVolumeFlowFan.maxFlowRate = ((UnitDouble)in.get(FlowElement.CONSTANT_FAN_VOLUME_FLOW_RATE)).getValue(SI.METER.pow(3).divide(SI.SECOND));
                constantVolumeFlowFan.uF = 0;
                continue;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == PowerlawModel.PERFORMANCE_CURVE) {
                PrjData.AirFlowTypePerformanceCurve fanCurve = new PrjData.AirFlowTypePerformanceCurve();
                prjData.performanceCurveMap.put(out.nr, fanCurve);
                fanCurve.lam = PowerlawUtil.getLaminarFlow(in);
                fanCurve.turb = PowerlawUtil.getTurbulentFlow(in);
                fanCurve.expt = (Double)in.get(FlowElement.PERFORMANCE_CURVE_PRESSURE_EXPONENT);
                fanCurve.cutOffRatio = (Double)in.get(FlowElement.PERFORMANCE_CURVE_CUTOFF_RATIO);
                prop = FlowElement.PERFORMANCE_CURVE;
                func = in.get(prop).toPiecewise(Unit.ONE);
                CubicFanPerformanceCurveUtil.CurveData fanPerfCurve = CubicFanPerformanceCurveUtil.getCurveData(func.getInput(), SI.KILOGRAM.divide(SI.SECOND), SI.PASCAL);
                fanCurve.coefficients = fanPerfCurve.coefficients;
                fanCurve.freeDeliveryFlow = fanPerfCurve.freeDeliveryFlow;
                fanCurve.shutOffPressure = fanCurve.coefficients[0];
                fanCurve.area = ((UnitDouble)in.get(FlowElement.PERFORMANCE_CURVE_ORIFICE_AREA)).getValue(SI.METER.pow(2));
                fanCurve.uA = 0;
                fanCurve.npts = func.getInput().length;
                fanCurve.points = new ArrayList();
                Unit x_unit = SIUS.unit(prop.x.unitType);
                Unit y_unit = SIUS.unit(prop.y.unitType);
                APiecewiseFunction1d.Entry[] entryArray = func.getInput();
                int n = entryArray.length;
                for (int i = 0; i < n; ++i) {
                    APiecewiseFunction1d.Entry e = entryArray[i];
                    fanCurve.points.add(new Pair<Double, Double>(e.x.getValue(x_unit), e.y.getValue(y_unit)));
                }
                continue;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) != PowerlawModel.Q_V_P) continue;
            PrjData.AirFlowTypeQvP qvp = new PrjData.AirFlowTypeQvP();
            prjData.qvpMap.put(out.nr, qvp);
            prop = FlowElement.Q_V_P_CURVE;
            func = in.get(prop).toPiecewise(Unit.ONE);
            qvp.npts = func.getInput().length;
            qvp.u_x = 0;
            qvp.u_y = 0;
            qvp.points = new ArrayList();
            Unit xu = SIUS.unit(prop.x.unitType);
            Unit yu = SIUS.unit(prop.y.unitType);
            for (APiecewiseFunction1d.Entry entry : func.getInput()) {
                qvp.points.add(new Pair<Double, Double>(entry.x.getValue(xu), entry.y.getValue(yu)));
            }
        }
    }
}

