/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.feature.dependencies.powerlaw.IPowerlawObj;
import ventus.feature.dependencies.powerlaw.LeakageAreaType;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropertyDefs;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;

public class FlowElement
extends NamedMerlinObj
implements Serializable,
IPowerlawObj,
ISurrogate,
IDirectDependent<VentusData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<FlowElement> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(FlowElement.class, PropertyDefs.serializedOnly(obj -> obj.d_properties, obj -> {
        obj.d_properties = new PropertySet();
    }), List.of(NamedMerlinObj.PROP_TYPES, IPowerlawObj.PROP_TYPES), Filters.reject(IPowerlawObj.getFlowElementRejectedProps()));
    public static final TypedProp<FlowElementRoot.Default> DEFAULT_TYPE = TypedProps.build((Object)"FlowElement.DEFAULT_TYPE", FlowElementRoot.Default.class).attrStoreAsPlainOldData(PROP_TYPES).attrCloneValue((obj, val) -> null).attrFinish();
    public static final DisplayProp<String> DESC = (DisplayProp)DisplayProps.build((Object)"FlowElement.DESC", "", Intl.intl("Description"), Intl.intl("Flow Element Description")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<String> DESCRIPTION = PROP_TYPES.storeDirectWrapper(VentusData.DESCRIPTION, DESC).attrFinish();
    public static final DisplayProp<Color> COLOR = (DisplayProp)DisplayProps.build((Object)"FlowElement.COLOR", Color.class, Color.BLACK, Intl.intl("Color"), Intl.intl("Flow Element Color")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Color> SEARCH_COLOR = PROP_TYPES.storeAsReadOnly(VentusData.SEARCH_COLOR).attrGetter(elem -> elem.get(COLOR), COLOR).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(PROP_TYPES);
    public static final TypedProp<Boolean> IS_DEFAULT = TypedProps.build((Object)"FlowElement.IS_DEFAULT", false).attrStoreAsReadOnly(PROP_TYPES).attrGetter(FlowElement::isDefault, DEFAULT_TYPE).attrMarkTransient().attrFinish();
    private PropertySet d_properties = new PropertySet();

    public FlowElement(String name) {
        this(name, null, theUtil.newRandomColor(), (PowerlawModel)FlowElement.POWERLAW_MODEL.defVal);
    }

    public FlowElement(String name, FlowElementRoot.Default defaultType, Color color, PowerlawModel law) {
        super(name);
        this.set(DEFAULT_TYPE, defaultType);
        this.set(COLOR, color);
        this.set(POWERLAW_MODEL, law);
        this.d_properties.merge(law.defaultProps);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        int version;
        is.defaultReadObject();
        if (this.d_properties.isDefined(IS_DEFAULT) && this.d_properties.get(IS_DEFAULT).booleanValue()) {
            assert (!this.d_properties.isDefined(DEFAULT_TYPE));
            this.d_properties.remove(IS_DEFAULT);
            String name = this.getName();
            for (FlowElementRoot.Default def : FlowElementRoot.Default.values()) {
                if (!def.create.apply(def).getName().equals(name)) continue;
                this.set(DEFAULT_TYPE, def);
                break;
            }
        }
        if (VentusIO.Version.VER_0201.isLater(version = VentusOIS.getVersion(is)) && this.get(POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA) {
            LeakageAreaType type = (LeakageAreaType)this.get(LEAKAGE_AREA_TYPE);
            UnitDouble oldAreaM2 = ((UnitDouble)this.d_properties.get(LEAKAGE_AREA)).convert(SI.METER.pow(2));
            if (type == LeakageAreaType.ITEM) {
                UnitDouble areaPerItem = oldAreaM2.divide(new UnitDouble(1.0, Unit.ONE));
                this.set(LEAKAGE_AREA_PER_ITEM, areaPerItem);
            } else if (type == LeakageAreaType.LENGTH) {
                UnitDouble areaPerLength = oldAreaM2.divide(new UnitDouble(1.0, SI.METER));
                this.set(LEAKAGE_AREA_PER_LENGTH, areaPerLength);
            } else if (type == LeakageAreaType.AREA) {
                UnitDouble areaPerArea = oldAreaM2.divide(new UnitDouble(1.0, SI.METER.pow(2)));
                this.set(LEAKAGE_AREA_PER_AREA, areaPerArea);
            }
            this.d_properties.remove(LEAKAGE_AREA);
        }
        if (VentusIO.Version.VER_0202.isLater(version) && this.get(POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA && this.get(LEAKAGE_AREA_TYPE) == LeakageAreaType.AREA && !this.d_properties.isDefined(LEAKAGE_AREA_PER_AREA)) {
            this.set(LEAKAGE_AREA_PER_AREA, PRE_202_LEAKAGE_AREA_PER_AREA);
        }
    }

    public boolean isDefault() {
        return this.get(DEFAULT_TYPE) != null;
    }

    public Set<Tag> getTags() {
        return this.get(TAGS);
    }

    public void setTags(Set<Tag> tags) {
        this.set(TAGS, tags);
    }

    public PropertyDefs<FlowElement> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public FlowElement clone() {
        return (FlowElement)super.clone();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isSetNameSupported() {
        return this.get(IS_DEFAULT) == false;
    }
}

