/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.Events;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.comps.IContextMenuItem;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowElementData;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathUtil;
import ventus.gui.ContextMenuUtils;
import ventus.gui.MerlinComboBox;
import ventus.gui.ObjSources;

public class FindShaftOp
extends AMerlinOp
implements IContextMenuItem,
IEventObserver {
    final UIHook uiHook = new UIHook(this, Intl.intl("&Select Flowpath Network..."));

    @Override
    public void update(Events events) {
        IEventRecord<IDomainObject> changelog = events.getEvents(IDomainObject.class, new Class[0]);
        if (changelog.containsChange(VentusData.SELECTION_CHANGED) || changelog.containsChange(VentusData.MODEL_RESET) || changelog.containsChange(VentusData.MODEL_LOADED)) {
            VentusData md = VentusApp.getAppData();
            assert (md != null);
            this.updateEnabled(md);
        }
    }

    private void updateEnabled(VentusData vd) {
        this.setEnabled(vd.selection.isSingleExclusive(ISchematicRoom.class));
    }

    @Override
    public void addContextMenuItem(GroupedSequence root) {
        root.getNode(ContextMenuUtils.ContextMenuNode.ENABLE_SELECT.id).add(this.uiHook);
    }

    @Override
    public void run(VentusApp app, VentusData vd) {
        try (VentusData.WriteLock ignored = vd.lockWrite();
             VentusData.ReadLock ignored1 = vd.lockRead();){
            ISchematicRoom selectedRoom = (ISchematicRoom)vd.selection.flatten(ISchematicRoom.class).stream().findFirst().orElseThrow();
            ShaftSelectionWindow shaftChooser = new ShaftSelectionWindow(app, vd, selectedRoom);
            if (shaftChooser.doModal() == 1) {
                Undo.begin(Intl.intl("Select Flowpath Network"));
                Undo.insertUndoEntry_restoreSelection(vd);
                vd.selection.clear();
                FlowElementRoot elementRoot = (FlowElementRoot)vd.getComponentData(FlowElementData.GUID);
                FlowElement userSpecifiedConnection = shaftChooser.getChosenConnection();
                FlowElement userSpecifiedInclude = shaftChooser.getChosenSearchItem();
                Set<FlowElement> connectionTypes = userSpecifiedConnection != null ? Collections.singleton(userSpecifiedConnection) : Collections.emptySet();
                HashSet<FlowElement> includeTypes = userSpecifiedInclude != null ? Collections.singleton(userSpecifiedInclude) : new HashSet<FlowElement>(elementRoot.flatten(FlowElement.class));
                Set<ISchematicRoom> connectedZones = FlowPathUtil.findConnectedZones(selectedRoom, connectionTypes);
                Set<FlowPath> shaftPaths = FlowPathUtil.findConnectedFlowPathsOfTypes(connectedZones, includeTypes);
                vd.selection.selectAll(shaftPaths);
                Undo.end(vd);
            }
        }
    }

    private static class ShaftSelectionWindow
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private final guiTextField zoneName;
        private final MerlinComboBox<FlowElement> connectionCombo;
        private final MerlinComboBox<FlowElement> searchCombo;

        public ShaftSelectionWindow(VentusApp app, VentusData data, ISchematicRoom searchRoot) {
            super((Window)app.getMainFrame(), Intl.intl("Select Flowpaths"), 9);
            guiPanel mainPanel = this.getDialogPane();
            mainPanel.setLayout(new GridBagLayout());
            this.zoneName = new guiTextField(searchRoot.getName());
            this.zoneName.setEditable(false);
            this.connectionCombo = new MerlinComboBox<FlowElement>(data, ObjSources.fromModelRobust(data, FlowElement.class, Intl.intl("<None>")));
            this.searchCombo = new MerlinComboBox<FlowElement>(data, ObjSources.fromModelRobust(data, FlowElement.class, Intl.intl("<Any>")));
            GridBagHelper builder = new GridBagHelper(mainPanel);
            builder.addRow(Intl.intl("Zone:"), 1.0, this.zoneName, 1.0);
            builder.addRow(Intl.intl("Connected By:"), 1.0, this.connectionCombo, 1.0);
            builder.addRow(Intl.intl("Filter By:"), 1.0, this.searchCombo, 1.0);
            builder.finalizeRows();
        }

        public FlowElement getChosenConnection() {
            return (FlowElement)this.connectionCombo.getSelectedItem();
        }

        public FlowElement getChosenSearchItem() {
            return (FlowElement)this.searchCombo.getSelectedItem();
        }
    }
}

