/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.find;

import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.gui.AObjsList;
import thunderheadeng.gui.dialogs.FindAdvancedDialog;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.gui.framework.property.IPropComparisonEd;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.PropValue;
import ventus.EntryPoint;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.MerlinOpImpl;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.Visibility;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.props.PropertyDefs;
import ventus.gui.VentusObjsList;

class FindAdvancedAction
extends AMerlinOp {
    private final boolean d_inSelection;

    public FindAdvancedAction(boolean inSelection) {
        this.d_inSelection = inSelection;
    }

    @Override
    public void run(VentusApp app, VentusData vd) {
        if (this.d_inSelection) {
            IdentityHashSet<IMerlinObj> objs = new IdentityHashSet<IMerlinObj>(vd.selection.flatten(IMerlinObj.class));
            FindAdvancedDialog<VentusData, IMerlinObj> dlg = new FindAdvancedDialog<VentusData, IMerlinObj>((Window)app.getMainFrame(), Intl.intl("Advanced Search in Selection"), new AppCallback(vd), objs);
            dlg.doModeless();
        } else {
            FindAdvancedDialog<VentusData, IMerlinObj> dlg = new FindAdvancedDialog<VentusData, IMerlinObj>((Window)app.getMainFrame(), Intl.intl("Advanced Search"), new AppCallback(vd), null);
            dlg.doModeless();
        }
    }

    static class AppCallback
    implements FindAdvancedDialog.IAppCallback<VentusData, IMerlinObj> {
        private final VentusData d_vd;

        AppCallback(VentusData data) {
            this.d_vd = data;
        }

        @Override
        public VentusData getDomain() {
            return this.d_vd;
        }

        @Override
        public FindAdvancedDialog.IReadLock getReadLock() {
            VentusData.ReadLock lock = this.d_vd.lockRead();
            return () -> lock.close();
        }

        @Override
        public Consumer<IMerlinObj> selectNext(String undoMsg) {
            return obj -> {
                MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                    try (VentusData.WriteLock lock = this.d_vd.lockWrite();){
                        Undo.begin(undoMsg);
                        Undo.insertUndoEntry_restoreSelection(this.d_vd);
                        this.d_vd.selection.set(obj);
                        Undo.end(this.d_vd);
                    }
                });
                UIHook.run((Component)VentusApp.getApp().getActiveFrame(), "FindAdvancedAction.AppCallback.selectNext()", op, 0);
            };
        }

        @Override
        public Collection<?> getEntryPointChildren() {
            return EntryPointFactory.get(this.d_vd).tvEntryPoint.getChildren(this.d_vd, this.d_vd);
        }

        @Override
        public Collection<IMerlinObj> getFlatDescendentsIfComposite(Object obj) {
            if (obj instanceof Composite) {
                Composite composite = (Composite)obj;
                return composite.flatten();
            }
            return List.of();
        }

        @Override
        public ConvexHull[] getVisibleFloorHulls() {
            return Visibility.getVisibleFloorHulls(this.d_vd);
        }

        @Override
        public boolean isVisible(IMerlinObj obj, ConvexHull[] visibleFloorHulls) {
            return Visibility.isVisible(this.d_vd, obj, visibleFloorHulls);
        }

        @Override
        public Class<IMerlinObj> getObjType() {
            return IMerlinObj.class;
        }

        @Override
        public PropValue<?> getPropValWithDetails(IMerlinObj obj, IDisplayProp<?> prop) {
            return obj.getWithDetails(prop.asProp());
        }

        @Override
        public AObjsList<IMerlinObj> makeObjsList(String desc, boolean linkSelection, boolean autoSort, Collection<? extends IMerlinObj> objs) {
            return new VentusObjsList(this.d_vd, desc, linkSelection, autoSort, objs);
        }

        @Override
        public void selectAllSearchResults(List<IMerlinObj> objs, String undoMsg) {
            MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                try (VentusData.WriteLock lock = this.d_vd.lockWrite();){
                    Undo.begin(undoMsg);
                    Undo.insertUndoEntry_restoreSelection(this.d_vd);
                    this.d_vd.selection.set(new Object[0]);
                    Undo.end(this.d_vd);
                }
            });
            UIHook.run((Component)VentusApp.getApp().getActiveFrame(), "FindAdvancedAction.AppCallback.selectAllSearchResults()", op, 0);
        }

        @Override
        public IPropComparisonEd<?, ?> getPropertyEditor(Class<?> type, IDisplayProp<?> prop, guiPanel d_propertiesPanel) {
            return EntryPointFactory.get(type).getPropertyDefs(this.d_vd).getAttrComparisonEditor(prop.asProp()).get(d_propertiesPanel, this.d_vd);
        }

        @Override
        public ArrayList<Class<?>> getUnsortedObjTypes() {
            ArrayList objTypes = new ArrayList();
            for (EntryPoint ep : EntryPointFactory.getAll()) {
                PropertyDefs defs = ep.getPropertyDefs(this.d_vd);
                if (!ep.isSearchType(this.d_vd) || defs == null || !defs.props().stream().anyMatch(prop -> defs.getAttrComparisonEditor(prop) != null)) continue;
                objTypes.add(ep.clazz);
            }
            return objTypes;
        }

        @Override
        public PropertyDefsFramework<?, ?> getProps(Class<?> type) {
            return EntryPointFactory.get(type).getPropertyDefs(this.d_vd);
        }

        @Override
        public String getCategoryName(Class clazz) {
            return EntryPointFactory.get(clazz).getCategoryName(this.d_vd, null);
        }
    }
}

